#!/bin/sh

lsusb() {
find /sys/bus/usb/devices | while read mypath
do
    if [[ -f $mypath/idVendor && -f $mypath/idProduct ]]; then
        tmpDev=`basename $mypath | sed "s/usb\([0-9]*\)/\\1-0/"`
        Bus=`echo $tmpDev | cut -d\- -f1`
        Device=`echo $tmpDev | cut -d\- -f2`
        Vid=`cat $mypath/idVendor`
        Pid=`cat $mypath/idProduct`
        manufacturer=`cat $mypath/manufacturer 2>/dev/null`
        product=`cat $mypath/product 2>/dev/null`
        printf "%s:%s\n" $Vid $Pid
    fi
done
}

lsusb | while read vidpid
do
	case $vidpid in
		07ca:a800|07ca:a801)
			dvbt=a800
		;;
		15a4:9020|0ccd:0055|10b9:6000)
			dvbt=af9005
		;;
		15a4:9015|15a4:9016|0413:6029|2304:022b|1b80:e399|13d3:3226|13d3:3237|0ccd:0069|1b80:c160|07ca:a815|1ae7:0381|1462:8801|07ca:8150|10b9:8000|07ca:a309|1462:8807|1b80:e396|1b80:e39b|1b80:e395|15a4:901b|07ca:850a|07ca:a805|1b80:e397|1b80:c810|0458:4012|1b80:e400|1b80:c161|1b80:e39d|1b80:e402|0413:6a04|1b80:e383|1b80:e39a|0ccd:0097)
			dvbt=af9015
		;;
		15a4:1000|15a4:1001|15a4:1002|15a4:1003|15a4:9035|0ccd:0093|07ca:0825|07ca:a867)
			dvbt=af9035
		;;
		058f:6610)
			dvbt=au6610
		;;
		8086:9500|07ca:a310)
			dvbt=ce6230
		;;
		0ccd:0038)
			dvbt=cinergyT2
		;;
		10b8:1e14|10b8:1e78|2040:9941|2040:9950|2040:7050|07ca:a807|185b:1e78|1584:6003|0413:6f00|2040:7060|07ca:b808|2304:022c|0ccd:005a|2040:9580|10b8:1ef0|10b8:1ebc|2304:0228|10b8:1ebe|2304:0229|185b:1e80|07ca:b568|1044:7001|05d8:810f|0b05:171f|0b05:173f|2040:7070|2040:7080|0ccd:0058|2304:022e|2304:0236|2304:0237|1164:1edc|0ccd:0060|0ccd:0078|0413:6f01|2040:5200|2040:8400|1044:7002|1164:1f08|0b05:1736|2304:023a|2304:023b|0ccd:0062|0ccd:0081|1415:0003|1164:2edc|2040:b200|2040:b210|1164:0871|0fd9:0021|0fd9:0020|0413:60f6|0ccd:10a0|0ccd:10a1|1164:1efc|1164:1e8c|2304:0243|2013:0245|2013:0248|10b8:1e80|0ccd:00ab|10b8:1f98|10b8:1f90|1554:5010|1e59:0002|2304:0245|2304:0248|10b8:1fa0)
			dvbt=dib0700
		;;
		14aa:0001|14aa:0002|185b:d000|185b:d001|145f:010c|10b8:0bb8|10b8:0bb9|eb1a:17de|eb1a:17df|5032:0fa0|5032:0fa1|5032:0bb8|5032:0bb9|1025:005e|1025:005f|13d3:3201|13d3:3202|1822:3201|1822:3202|05d8:8105|05d8:8106|05d8:8107|05d8:8108|06e1:a333|0547:2235)
			dvbt=dibusb-mb
		;;
		10b8:0bc6|10b8:0bc7|05d8:8109|05d8:810a|04ca:f000|04ca:f001|eb1a:e360|eb1a:e361|5032:0bc6|5032:0bc7|05d8:810b|05d8:810c|0413:6025|0413:6026|10b9:5000|10b9:5001)
			dvbt=dibusb-mc
		;;
		14aa:0201|14aa:0301|14aa:0222|14aa:0221|14aa:022a|14aa:022b|14aa:0225|14aa:0226|14aa:0220|18f3:0220)
			dvbt=dtt200u
		;;
		06be:a232)
			dvbt=dtv5100
		;;
		18b4:1689|18b4:fffa|18b4:fffb|18b4:1001|18b4:1002)
			dvbt=ec168
		;;
		0db0:5581|05e3:f170)
			dvbt=gl861
		;;
		2040:9300|2040:9301)
			dvbt=nova-t-usb2
		;;
		187f:0010|187f:0100|187f:0200|187f:0201|187f:0300|2040:1700|2040:1800|2040:1801|2040:5500|2040:5510|2040:5520|2040:5530|2040:5580|2040:5590|2040:b900|2040:b910|2040:b980|2040:b990|2040:c000|2040:c010|2040:c080|2040:c090)
			dvbt=smsusb
		;;
		13d3:3205|13d3:3206|13d3:3223|13d3:3224)
			dvbt=vp7045
		;;
		0000:0000)
			dvbt=
		;;
		*)
			dvbt=dummy
			echo "Usb device $vidpid non supported." 1>&2
		;;
	esac
	if [[ "x$dvbt" != "x" && "x$dvbt" != "xdummy" ]]; then
		echo "Found compatible usb tuner $dvbt" 1>&2
		if [[ -f /etc/dvbt/$dvbt.sh ]]; then
			sh /etc/dvbt/$dvbt.sh		
		else
			echo "Driver $dvbt not installed" 1>&2
			echo "" 1>&2
			echo "" 1>&2
			echo "Please install driver for $dvbt device" 1>&2
			echo "" 1>&2
			echo "" 1>&2
		fi
	fi
done

killall -9 usbtuner && sleep 2

/usr/bin/usbtuner -n >/dev/null 2>&1 &
if [ -d /dev/dvb/adapter2 ]; then
 	if [ -f /dev/misc/vtuner1 ]; then
 		/usr/bin/usbtuner -a2 -v1 >/dev/null 2>&1 &
	fi
fi


exit 0
