#######################################################################
#
#    GetImdbCovers for Dreambox-Enigma2
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#######################################################################


import urllib, re, os
from Screens.Screen import Screen
from Screens.Console import Console
from Plugins.Plugin import PluginDescriptor
from Components.ActionMap import ActionMap
from Components.Label import Label
from os import listdir
from string import find
from commands import *



def Plugins(**kwargs):
	return [PluginDescriptor(name=_("GetImdbCovers"), description=_("GetImdbCovers"), where = [PluginDescriptor.WHERE_EXTENSIONSMENU], fnc=main)]



def main(session, **kwargs):
	session.open(Scripts)



class Scripts(Screen):
	skin = """
	<screen position="center,center" size="420,400" title="GetImdbCovers" >
		<widget name="main" position="0,0" size="420,400" font="Regular;20" />
	</screen>"""

	def __init__(self, session, args=None):
		Screen.__init__(self, session)
		self.session = session
		self.text="Press OK to start ... "
		self["main"] = Label()
		self["actions"] = ActionMap(["OkCancelActions"], {"ok": self.movie_list, "cancel": self.close}, -1)
		self.onShown.append(self.setMyText)
	
	def setMyText(self):
		self["main"].setText(self.text)
	
	
	def movie_list(self):
		self["main"].setText(_("Thread running"))
		getoutput("find /media/hdd/movie/ -path '*.ts' >movie_ls")
		with open("movie_ls","r") as myfile:
			mydata = myfile.readlines()
			count = len(mydata)
			print "Es wurden", count, "filme gefunden. \n"
			for m in mydata:
				moviename = m.replace('\n',"")
				titel = re.findall("-.*?-.(.*?).ts", moviename)
				titel2 = moviename.replace('.ts',".jpg")
				url = 'http://www.imdb.de/find?s=all&q='+titel[0]
				print "Titel:", titel2
				self.text="Titel:"
				self.setMyText()
				if os.path.exists(titel2):
					print "Poster vorhanden.. \n"
				else:
					print "imdb suche:", url
					self.findit(url,titel2)

	def findit(self,url,titel):
		urllib.URLopener.version = 'Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0; T312461)'
		data = urllib.urlopen(url).read()

	### richtigen titel finden..
		if re.match(".*?<p><b>Meistgesuchte Titel</b>", data, re.S):
	### wichtigen teil vom quelltext cutten
	#		print "Meistgesuchte Titel"
			startpos = find(data,'<p><b>Meistgesuchte Titel</b>')
			endpos = find(data,'onClick="')
			bereich = data[startpos:endpos]
	### get link :)
			link = re.findall('<a href="(.*?)"', bereich)
			link = 'http://www.imdb.de'+link[0]
			self.get_jpg(link,titel)

		elif re.match(".*?<p><b>Titel \(genaue &#xDC;bereinstimmung\)</b>", data, re.S):
	#		print "Titel Genaue ubereinstimmung"
	### wichtigen teil vom quelltext cutten
			startpos = find(data,"<b>Titel (genaue &#xDC;bereinstimmung)")
			endpos = find(data,'/title_exact/')
			bereich = data[startpos:endpos]
			id = re.findall('.*?<a href="/title/(.*?)/', bereich, re.S)
			link = 'http://www.imdb.de/title/'+id[0]
	### get link :)
			#link = 'http://www.imdb.de'+link[0]
			self.get_jpg(link,titel)
		
		elif re.match(".*?<p><b>Titel \(n&#xE4;herungsweise &#xDC;bereinstimmung\)</b>", data, re.S):
	#		print data
			startpos = find(data,'<p><b>Titel (n&#xE4;herungsweise &#xDC;bereinstimmung)</b>')
			endpos = find(data,'onClick="')
			bereich = data[startpos:endpos]
			link = re.findall('<a href="(.*?)"', bereich)
			link = 'http://www.imdb.de'+link[0]
			self.get_jpg(link,titel)

		elif re.match(".*?<b>Keine Treffer.</b>", data, re.S):
			print "nix gefunden. \n"
		else:
	#		print "direct link..yes.."
			link = re.findall('<link rel="canonical" href="(.*?)" /><meta', data, re.S)
			link = link[0]
			self.get_jpg(link,titel)

	def get_jpg(self,link,titel):
		url = link
		print "url:", url
		urllib.URLopener.version = 'Mozilla/4.0 (compatible; MSIE 5.5; Windows NT 5.0; T312461)'
		data = urllib.urlopen(url).read()
		if re.match('.*?http://i.media-imdb.com/images/SF0551c9453d5a268e1f2edb873492a05e/intl/de/title_addposter.jpg', data, re.S):
			print "Save to HDD: http://i.media-imdb.com/images/SF0551c9453d5a268e1f2edb873492a05e/intl/de/title_addposter.jpg >", titel, "\n"
			getoutput('wget -O "'+titel+'" http://i.media-imdb.com/images/SF0551c9453d5a268e1f2edb873492a05e/intl/de/title_addposter.jpg')
		else:
			link_poster = re.findall('<a name="poster".*?src="(.*?)"', data)
			final_poster = re.sub('._.*[a-zA-Z_0-9]', '.jpg', link_poster[0], re.S)
			print "Save to HDD:", final_poster, ">", titel, "\n"
			getoutput('wget -O "'+titel+'" '+final_poster)