/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ApplicationConfig;
import gui.IApplicationConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class ApplicationConfigHandler {
    private IApplicationConfig config = new ApplicationConfig();
    private static final Logger log = Logger.getLogger(ApplicationConfigHandler.class.getName());
    private boolean initialized = false;
    private File configFile = null;

    private void initConfig() {
        String filename = String.valueOf(System.getProperty("user.home")) + File.separator + ".tsStreamRipper.properties";
        this.configFile = new File(filename);
        if (!this.configFile.exists()) {
            log.info("Es existiert noch keine Config-Datei. Lege neue mit Default-Werten an ...");
            this.saveConfig();
        }
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            log.warning("Konfiguration l\u00e4\u00dft sich nicht laden!");
            log.throwing("ApplicationConfig", "CONSTRUCTOR", e);
        }
    }

    public IApplicationConfig getConfig() {
        if (!this.initialized) {
            this.initialized = true;
            this.initConfig();
        }
        return this.config;
    }

    public void resetConfig() {
        if (!this.initialized) {
            this.initialized = true;
            this.initConfig();
        }
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            log.warning("Konfiguration l\u00e4\u00dft sich nicht resetten!");
            log.throwing("ApplicationConfig", "resetConfig", e);
        }
    }

    private void loadConfig() throws IOException {
        log.fine("Lade Konfiguration ...");
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.configFile);
            props.load(fis);
            this.config.setHost(props.getProperty("host"));
            this.config.setPort(props.getProperty("port", "8001"));
            this.config.setWebport(props.getProperty("webport", "80"));
            this.config.setUsername(props.getProperty("username"));
            this.config.setPasswort(props.getProperty("passwort"));
            this.config.setBoxType(BoxType.valueOf(props.getProperty("boxType", "SAT")));
            this.config.setTmpDir(props.getProperty("tmpDir"));
            this.config.setConverter(Converter.valueOf(props.getProperty("converter", "KEINE_KONVERTIERUNG")));
            this.config.setFaacPath(props.getProperty("faacPath"));
            this.config.setLamePath(props.getProperty("lamePath"));
            this.config.setOverwrite(Boolean.valueOf(props.getProperty("overwrite", "FALSE")));
            this.config.setVerbose(Boolean.valueOf(props.getProperty("verbose", "FALSE")));
            this.config.setSwitchFilename(Boolean.valueOf(props.getProperty("switchFilename", "FALSE")));
            this.config.setMusic60er70er(props.getProperty("music60er70er"));
            this.config.setMusic80er90er(props.getProperty("music80er90er"));
            this.config.setMusicCountry(props.getProperty("musicCountry"));
            this.config.setMusicDeutscheCharts(props.getProperty("musicDeutscheCharts"));
            this.config.setMusicLovesongs(props.getProperty("musicLovesongs"));
            this.config.setMusicRnbHiphop(props.getProperty("musicRnbHiphop"));
            this.config.setMusicRockHymnen(props.getProperty("musicRockHymnen"));
            this.config.setMusicFreieAuswahl(props.getProperty("musicFreieAuswahl"));
            this.config.setRestdauerKorrektur(props.getProperty("restdauerKorrektur"));
            log.fine("Konfiguration geladen.");
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    private String getNullableString(String s) {
        return s == null ? "" : s;
    }

    private String getDefaultString(String s, String defaultValue) {
        return s == null ? defaultValue : s;
    }

    public void saveConfig() {
        if (!this.initialized) {
            this.initialized = true;
            this.initConfig();
        }
        log.fine("Speichere Konfiguration ...");
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(this.configFile);
                Properties props = new Properties();
                props.put("host", this.getNullableString(this.config.getHost()));
                props.put("port", this.getNullableString(this.config.getPort()));
                props.put("webport", this.getNullableString(this.config.getWebport()));
                props.put("username", this.getNullableString(this.config.getUsername()));
                props.put("passwort", this.getNullableString(this.config.getPasswort()));
                props.put("boxType", this.getNullableString(this.config.getBoxType().toString()));
                props.put("tmpDir", this.getNullableString(this.config.getTmpDir()));
                props.put("converter", this.getNullableString(this.config.getConverter().toString()));
                props.put("faacPath", this.getNullableString(this.config.getFaacPath()));
                props.put("lamePath", this.getNullableString(this.config.getLamePath()));
                props.put("overwrite", this.getNullableString(Boolean.toString(this.config.isOverwrite())));
                props.put("verbose", this.getNullableString(Boolean.toString(this.config.isVerbose())));
                props.put("switchFilename", this.getNullableString(Boolean.toString(this.config.isSwitchFilename())));
                props.put("music60er70er", this.getNullableString(this.config.getMusic60er70er()));
                props.put("music80er90er", this.getNullableString(this.config.getMusic80er90er()));
                props.put("musicCountry", this.getNullableString(this.config.getMusicCountry()));
                props.put("musicDeutscheCharts", this.getNullableString(this.config.getMusicDeutscheCharts()));
                props.put("musicLovesongs", this.getNullableString(this.config.getMusicLovesongs()));
                props.put("musicRnbHiphop", this.getNullableString(this.config.getMusicRnbHiphop()));
                props.put("musicRockHymnen", this.getNullableString(this.config.getMusicRockHymnen()));
                props.put("musicFreieAuswahl", this.getNullableString(this.config.getMusicFreieAuswahl()));
                props.put("restdauerKorrektur", this.getDefaultString(this.config.getRestdauerKorrektur(), "20"));
                props.store(fos, "tsStreamRipper Konfiguration");
            }
            catch (IOException e) {
                log.warning("Konfiguration l\u00e4\u00dft sich nicht speichern!");
                log.throwing("ApplicationConfig", "saveConfig", e);
                try {
                    fos.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static enum BoxType {
        SAT,
        KABEL;

    }

    public static enum Converter {
        KEINE_KONVERTIERUNG,
        AAC,
        MP3;

    }
}

