/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ApplicationConfigHandler;
import gui.GuiManagerBean;
import gui.IApplicationConfig;
import gui.MessageDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class Einstellungen
extends JDialog {
    private static final Logger log = Logger.getLogger(Einstellungen.class.getName());
    private MessageDialog dlgMessage = new MessageDialog(this);
    private static final long serialVersionUID = 1L;
    private JPanel panel1;
    private JLabel lblHostIp;
    private JTextField tfHost;
    private JLabel lblPort;
    private JTextField tfPort;
    private JLabel label4;
    private JTextField tfUsername;
    private JLabel label5;
    private JPasswordField tfPasswort;
    private JLabel lblSeperatorDreambox;
    private JLabel lblSeperatorVerzeichnisse;
    private JSeparator sepDirectory;
    private JLabel lblTmpVerzeichnis;
    private JTextField tfTmpDir;
    private JButton btnSelectTmpDir;
    private JLabel lblKonverterprogramme;
    private JLabel lblKonvertierung;
    private JComboBox cbKonvertierung;
    private JLabel lblFaacEncoder;
    private JTextField tfFaacEncoder;
    private JButton btnSelectFaacEncoder;
    private JLabel lblLameEncoder;
    private JTextField tfLameEncoder;
    private JButton btnSelectLameEncoder;
    private JLabel lblKonverterprogramme2;
    private JSeparator sepOptionen;
    private JCheckBox cbOverwrite;
    private JCheckBox cbSwitchFilename;
    private JCheckBox cbVerbose;
    private JLabel lblBoxtyp;
    private JComboBox cbBoxTyp;
    private JCheckBox cbRemoveOrig;
    private JSeparator sepKonverter;
    private JSeparator sepDreambox;
    private JLabel lblPort2;
    private JTextField tfWebPort;
    private JLabel lblRestdauer;
    private JTextField tfRestdauerOffset;
    private JLabel lblSekunden;
    private JPanel panelButtons;
    private JButton btnSpeichern;
    private JButton btnAbbrechen;

    private void readConfig() {
        IApplicationConfig config = GuiManagerBean.getInstance().getConfig();
        this.tfHost.setText(config.getHost());
        this.tfPort.setText(config.getPort());
        this.tfWebPort.setText(config.getWebport());
        this.tfUsername.setText(config.getUsername());
        this.tfPasswort.setText(config.getPasswort());
        this.tfTmpDir.setText(config.getTmpDir());
        this.tfFaacEncoder.setText(config.getFaacPath());
        this.tfLameEncoder.setText(config.getLamePath());
        this.tfTmpDir.setText(config.getTmpDir());
        this.cbOverwrite.setSelected(config.isOverwrite());
        this.cbSwitchFilename.setSelected(config.isSwitchFilename());
        this.cbRemoveOrig.setSelected(config.isRemoveOriginalAfterConvert());
        this.cbVerbose.setSelected(config.isVerbose());
        this.cbBoxTyp.setSelectedItem((Object)config.getBoxType());
        this.cbKonvertierung.setSelectedItem((Object)config.getConverter());
        this.tfRestdauerOffset.setText(config.getRestdauerKorrektur());
    }

    public Einstellungen() {
        this.initComponents();
        this.readConfig();
    }

    private void btnSelectTmpDirActionPerformed(ActionEvent e) {
        IApplicationConfig config = GuiManagerBean.getInstance().getConfig();
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            config.setTmpDir(file.getAbsolutePath());
            log.fine("Setze Verzeichnis f\u00fcr tempor\u00e4re Dateien auf : " + config.getTmpDir());
            this.readConfig();
        }
    }

    private void btnSelectFaacEncoderActionPerformed(ActionEvent e) {
        IApplicationConfig config = GuiManagerBean.getInstance().getConfig();
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            config.setFaacPath(file.getAbsolutePath());
            log.fine("Setze Pfad des FAAC Encoder auf : " + config.getFaacPath());
            this.readConfig();
        }
    }

    private void btnSelectLameEncoderActionPerformed(ActionEvent e) {
        IApplicationConfig config = GuiManagerBean.getInstance().getConfig();
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.tfLameEncoder.setText(file.getAbsolutePath());
            config.setLamePath(file.getAbsolutePath());
            log.fine("Setze Pfad des LAME Encoder auf : " + config.getLamePath());
        }
    }

    private boolean validateData() {
        File f;
        try {
            Integer.parseInt(this.tfRestdauerOffset.getText());
        }
        catch (NumberFormatException e) {
            this.dlgMessage.setErrorText(String.format("Musikende Offset :  '%s' ist keine g\u00fcltige Zahl.", this.tfRestdauerOffset.getText()));
            this.dlgMessage.setVisible(true);
            return false;
        }
        if (((ApplicationConfigHandler.Converter)((Object)this.cbKonvertierung.getSelectedItem())).equals((Object)ApplicationConfigHandler.Converter.MP3)) {
            if (this.tfLameEncoder.getText().trim().equals("")) {
                this.dlgMessage.setErrorText("Bitte geben Sie den vollqualifizierten Pfad auf den Lame Encoder an.");
                this.dlgMessage.setVisible(true);
                return false;
            }
            f = new File(this.tfLameEncoder.getText());
            if (f.isDirectory()) {
                this.dlgMessage.setErrorText("Lame Encoder: Sie haben ein Verzeichnis ausgew\u00e4hlt. Bitte geben Sie eine Programmdatei an.");
                this.dlgMessage.setVisible(true);
                return false;
            }
            if (!f.canExecute()) {
                log.warning("Ausgew\u00e4hlter Lame Encoder ist m\u00f6glicherweise keine Ausf\u00fchrbare Datei und die Konvertierung wird fehlschalgen!");
            }
        }
        if (((ApplicationConfigHandler.Converter)((Object)this.cbKonvertierung.getSelectedItem())).equals((Object)ApplicationConfigHandler.Converter.AAC)) {
            if (this.tfFaacEncoder.getText().trim().equals("")) {
                this.dlgMessage.setErrorText("Bitte geben Sie den vollqualifizierten Pfad auf den Faac Encoder an.");
                this.dlgMessage.setVisible(true);
                return false;
            }
            f = new File(this.tfFaacEncoder.getText());
            if (f.isDirectory()) {
                this.dlgMessage.setErrorText("Faac Encoder: Sie haben ein Verzeichnis ausgew\u00e4hlt. Bitte geben Sie eine Programmdatei an.");
                this.dlgMessage.setVisible(true);
                return false;
            }
            if (!f.canExecute()) {
                log.warning("Ausgew\u00e4hlter FAAC Encoder ist m\u00f6glicherweise keine ausf\u00fchrbare Datei und die Konvertierung wird fehlschlagen!");
            }
        }
        if (!this.tfTmpDir.getText().trim().equals("") && !(f = new File(this.tfTmpDir.getText())).isDirectory()) {
            this.dlgMessage.setErrorText("Temp Directory: Bitte w\u00e4hlen Sie ein Verzeichnis aus, oder l\u00f6schen es. Dann wird das Default-Tmp Verzeichnis verwendet");
            this.dlgMessage.setVisible(true);
            return false;
        }
        return true;
    }

    private void btnSpeichernActionPerformed(ActionEvent e) {
        if (this.validateData()) {
            this.writeProperties();
            GuiManagerBean.getInstance().saveConfig();
            this.dispose();
        }
    }

    private void writeProperties() {
        IApplicationConfig config = GuiManagerBean.getInstance().getConfig();
        config.setHost(this.tfHost.getText());
        config.setPort(this.tfPort.getText());
        config.setWebport(this.tfWebPort.getText());
        config.setUsername(this.tfUsername.getText());
        config.setPasswort(new String(this.tfPasswort.getPassword()));
        config.setTmpDir(this.tfTmpDir.getText());
        config.setFaacPath(this.tfFaacEncoder.getText());
        config.setLamePath(this.tfLameEncoder.getText());
        config.setTmpDir(this.tfTmpDir.getText());
        config.setOverwrite(this.cbOverwrite.isSelected());
        config.setSwitchFilename(this.cbSwitchFilename.isSelected());
        config.setRemoveOriginalAfterConvert(this.cbRemoveOrig.isSelected());
        config.setVerbose(this.cbVerbose.isSelected());
        config.setBoxType((ApplicationConfigHandler.BoxType)((Object)this.cbBoxTyp.getSelectedItem()));
        config.setConverter((ApplicationConfigHandler.Converter)((Object)this.cbKonvertierung.getSelectedItem()));
        config.setRestdauerKorrektur(this.tfRestdauerOffset.getText());
    }

    private void btnAbbrechenActionPerformed(ActionEvent e) {
        GuiManagerBean.getInstance().resetConfig();
        this.dispose();
    }

    private void initComponents() {
        this.panel1 = new JPanel();
        this.lblHostIp = new JLabel();
        this.tfHost = new JTextField();
        this.lblPort = new JLabel();
        this.tfPort = new JTextField();
        this.label4 = new JLabel();
        this.tfUsername = new JTextField();
        this.label5 = new JLabel();
        this.tfPasswort = new JPasswordField();
        this.lblSeperatorDreambox = new JLabel();
        this.lblSeperatorVerzeichnisse = new JLabel();
        this.sepDirectory = new JSeparator();
        this.lblTmpVerzeichnis = new JLabel();
        this.tfTmpDir = new JTextField();
        this.btnSelectTmpDir = new JButton();
        this.lblKonverterprogramme = new JLabel();
        this.lblKonvertierung = new JLabel();
        this.cbKonvertierung = new JComboBox();
        this.lblFaacEncoder = new JLabel();
        this.tfFaacEncoder = new JTextField();
        this.btnSelectFaacEncoder = new JButton();
        this.lblLameEncoder = new JLabel();
        this.tfLameEncoder = new JTextField();
        this.btnSelectLameEncoder = new JButton();
        this.lblKonverterprogramme2 = new JLabel();
        this.sepOptionen = new JSeparator();
        this.cbOverwrite = new JCheckBox();
        this.cbSwitchFilename = new JCheckBox();
        this.cbVerbose = new JCheckBox();
        this.lblBoxtyp = new JLabel();
        this.cbBoxTyp = new JComboBox();
        this.cbRemoveOrig = new JCheckBox();
        this.sepKonverter = new JSeparator();
        this.sepDreambox = new JSeparator();
        this.lblPort2 = new JLabel();
        this.tfWebPort = new JTextField();
        this.lblRestdauer = new JLabel();
        this.tfRestdauerOffset = new JTextField();
        this.lblSekunden = new JLabel();
        this.panelButtons = new JPanel();
        this.btnSpeichern = new JButton();
        this.btnAbbrechen = new JButton();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setModal(true);
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.tfHost.setBackground(Color.white);
        this.tfPort.setBackground(Color.white);
        this.btnSelectTmpDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Einstellungen.this.btnSelectTmpDirActionPerformed(e);
            }
        });
        this.btnSelectFaacEncoder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Einstellungen.this.btnSelectFaacEncoderActionPerformed(e);
            }
        });
        this.btnSelectLameEncoder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Einstellungen.this.btnSelectLameEncoderActionPerformed(e);
            }
        });
        this.tfWebPort.setBackground(Color.white);
        this.tfRestdauerOffset.setBackground(Color.white);
        GroupLayout panel1Layout = new GroupLayout(this.panel1);
        this.panel1.setLayout(panel1Layout);
        panel1Layout.setHorizontalGroup(panel1Layout.createParallelGroup().addGroup(panel1Layout.createSequentialGroup().addContainerGap().addGroup(panel1Layout.createParallelGroup().addGroup(panel1Layout.createSequentialGroup().addGap(40, 40, 40).addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(panel1Layout.createSequentialGroup().addComponent(this.lblHostIp, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfHost, -2, 200, -2)).addGroup(panel1Layout.createSequentialGroup().addComponent(this.label4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfUsername, -2, 200, -2))).addGroup(panel1Layout.createSequentialGroup().addComponent(this.label5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfPasswort, -2, -1, -2))).addGap(18, 18, 18).addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(panel1Layout.createParallelGroup().addGroup(panel1Layout.createSequentialGroup().addComponent(this.lblPort).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfPort, -2, 200, -2)).addGroup(GroupLayout.Alignment.TRAILING, panel1Layout.createSequentialGroup().addComponent(this.lblBoxtyp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbBoxTyp, -2, -1, -2))).addGroup(panel1Layout.createSequentialGroup().addComponent(this.lblPort2, -2, 125, -2).addGap(6, 6, 6).addComponent(this.tfWebPort, -2, 200, -2)))).addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, panel1Layout.createSequentialGroup().addGap(43, 43, 43).addComponent(this.lblTmpVerzeichnis, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfTmpDir).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelectTmpDir)).addGroup(GroupLayout.Alignment.LEADING, panel1Layout.createSequentialGroup().addGap(36, 36, 36).addGroup(panel1Layout.createParallelGroup().addComponent(this.cbRemoveOrig).addGroup(panel1Layout.createSequentialGroup().addGap(8, 8, 8).addGroup(panel1Layout.createParallelGroup().addGroup(panel1Layout.createSequentialGroup().addComponent(this.lblLameEncoder, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfLameEncoder, -2, 484, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelectLameEncoder)).addGroup(panel1Layout.createSequentialGroup().addComponent(this.lblFaacEncoder, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfFaacEncoder, -2, 484, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelectFaacEncoder)).addGroup(panel1Layout.createSequentialGroup().addComponent(this.lblKonvertierung, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbKonvertierung, -2, 200, -2))))))).addComponent(this.sepKonverter, -2, 704, -2).addGroup(panel1Layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.lblKonverterprogramme)).addGroup(panel1Layout.createSequentialGroup().addGap(37, 37, 37).addGroup(panel1Layout.createParallelGroup().addComponent(this.cbSwitchFilename).addComponent(this.cbOverwrite).addComponent(this.cbVerbose).addGroup(panel1Layout.createSequentialGroup().addComponent(this.lblRestdauer, -2, 148, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfRestdauerOffset, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSekunden, -2, 195, -2)))).addComponent(this.sepDirectory, -2, 704, -2).addComponent(this.sepDreambox, -2, 773, -2).addComponent(this.sepOptionen, -2, 719, -2).addGroup(panel1Layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblSeperatorVerzeichnisse)).addGroup(panel1Layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.lblKonverterprogramme2)).addGroup(panel1Layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.lblSeperatorDreambox))).addContainerGap()));
        panel1Layout.linkSize(0, this.label4, this.label5, this.lblBoxtyp, this.lblFaacEncoder, this.lblHostIp, this.lblKonvertierung, this.lblLameEncoder, this.lblPort, this.lblTmpVerzeichnis);
        panel1Layout.linkSize(0, this.cbBoxTyp, this.cbKonvertierung, this.tfHost, this.tfUsername);
        panel1Layout.linkSize(0, this.tfPasswort, this.tfPort);
        panel1Layout.linkSize(0, this.tfFaacEncoder, this.tfLameEncoder, this.tfTmpDir);
        panel1Layout.linkSize(0, this.sepDirectory, this.sepDreambox, this.sepKonverter, this.sepOptionen);
        panel1Layout.setVerticalGroup(panel1Layout.createParallelGroup().addGroup(panel1Layout.createSequentialGroup().addContainerGap().addComponent(this.lblSeperatorDreambox, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sepDreambox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panel1Layout.createParallelGroup().addGroup(panel1Layout.createSequentialGroup().addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfHost, -2, -1, -2).addComponent(this.lblHostIp)).addGap(6, 6, 6).addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfUsername, -2, -1, -2).addComponent(this.label4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label5).addComponent(this.tfPasswort, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.lblSeperatorVerzeichnisse)).addGroup(panel1Layout.createSequentialGroup().addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfPort, -2, -1, -2).addComponent(this.lblPort)).addGap(6, 6, 6).addGroup(panel1Layout.createParallelGroup().addGroup(panel1Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.lblPort2)).addComponent(this.tfWebPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblBoxtyp).addComponent(this.cbBoxTyp, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sepDirectory, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfTmpDir, -2, -1, -2).addComponent(this.btnSelectTmpDir).addComponent(this.lblTmpVerzeichnis)).addGap(18, 18, 18).addComponent(this.lblKonverterprogramme).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sepKonverter, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbKonvertierung, -2, -1, -2).addComponent(this.lblKonvertierung)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfFaacEncoder, -2, -1, -2).addComponent(this.btnSelectFaacEncoder).addComponent(this.lblFaacEncoder)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfLameEncoder, -2, -1, -2).addComponent(this.btnSelectLameEncoder).addComponent(this.lblLameEncoder)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbRemoveOrig).addGap(18, 18, 18).addComponent(this.lblKonverterprogramme2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sepOptionen, -2, -1, -2).addGap(12, 12, 12).addComponent(this.cbOverwrite).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSwitchFilename).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbVerbose).addGap(12, 12, 12).addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblRestdauer).addComponent(this.tfRestdauerOffset, -2, -1, -2).addComponent(this.lblSekunden)).addGap(60, 60, 60)));
        contentPane.add((Component)this.panel1, "Center");
        this.panelButtons.setBorder(null);
        this.panelButtons.setBackground(Color.lightGray);
        this.panelButtons.setLayout(new FlowLayout());
        ((FlowLayout)this.panelButtons.getLayout()).setAlignOnBaseline(true);
        this.btnSpeichern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Einstellungen.this.btnSpeichernActionPerformed(e);
            }
        });
        this.panelButtons.add(this.btnSpeichern);
        this.btnAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Einstellungen.this.btnAbbrechenActionPerformed(e);
            }
        });
        this.panelButtons.add(this.btnAbbrechen);
        contentPane.add((Component)this.panelButtons, "South");
        this.setSize(800, 705);
        this.setLocationRelativeTo(null);
        this.initComponentsI18n();
        this.cbBoxTyp.addItem(ApplicationConfigHandler.BoxType.SAT);
        this.cbBoxTyp.addItem(ApplicationConfigHandler.BoxType.KABEL);
        this.cbKonvertierung.addItem(ApplicationConfigHandler.Converter.KEINE_KONVERTIERUNG);
        this.cbKonvertierung.addItem(ApplicationConfigHandler.Converter.MP3);
        this.cbKonvertierung.addItem(ApplicationConfigHandler.Converter.AAC);
    }

    private void initComponentsI18n() {
        ResourceBundle bundle = ResourceBundle.getBundle("ui_dialog");
        this.setTitle(bundle.getString("config.this.title"));
        this.lblHostIp.setText(bundle.getString("config.lblHostIp.text"));
        this.tfHost.setToolTipText(bundle.getString("config.tfHost.toolTipText"));
        this.lblPort.setText(bundle.getString("config.lblPort.text"));
        this.tfPort.setToolTipText(bundle.getString("config.tfPort.toolTipText"));
        this.label4.setText(bundle.getString("config.label4.text"));
        this.tfUsername.setToolTipText(bundle.getString("config.tfUsername.toolTipText"));
        this.label5.setText(bundle.getString("config.label5.text"));
        this.tfPasswort.setToolTipText(bundle.getString("config.tfPasswort.toolTipText"));
        this.lblSeperatorDreambox.setText(bundle.getString("config.lblSeperatorDreambox.text"));
        this.lblSeperatorVerzeichnisse.setText(bundle.getString("config.lblSeperatorVerzeichnisse.text"));
        this.lblTmpVerzeichnis.setText(bundle.getString("config.lblTmpVerzeichnis.text"));
        this.tfTmpDir.setToolTipText(bundle.getString("config.tfTmpDir.toolTipText"));
        this.btnSelectTmpDir.setText(bundle.getString("config.btnSelectTmpDir.text"));
        this.btnSelectTmpDir.setToolTipText(bundle.getString("config.btnSelectTmpDir.toolTipText"));
        this.lblKonverterprogramme.setText(bundle.getString("config.lblKonverterprogramme.text"));
        this.lblKonvertierung.setText(bundle.getString("config.lblKonvertierung.text"));
        this.cbKonvertierung.setToolTipText(bundle.getString("config.cbKonvertierung.toolTipText"));
        this.lblFaacEncoder.setText(bundle.getString("config.lblFaacEncoder.text"));
        this.tfFaacEncoder.setToolTipText(bundle.getString("config.tfFaacEncoder.toolTipText"));
        this.btnSelectFaacEncoder.setText(bundle.getString("config.btnSelectFaacEncoder.text"));
        this.btnSelectFaacEncoder.setToolTipText(bundle.getString("config.btnSelectFaacEncoder.toolTipText"));
        this.lblLameEncoder.setText(bundle.getString("config.lblLameEncoder.text"));
        this.tfLameEncoder.setToolTipText(bundle.getString("config.tfLameEncoder.toolTipText"));
        this.btnSelectLameEncoder.setText(bundle.getString("config.btnSelectLameEncoder.text"));
        this.btnSelectLameEncoder.setToolTipText(bundle.getString("config.btnSelectLameEncoder.toolTipText"));
        this.lblKonverterprogramme2.setText(bundle.getString("config.lblKonverterprogramme2.text"));
        this.cbOverwrite.setText(bundle.getString("config.cbOverwrite.text"));
        this.cbOverwrite.setToolTipText(bundle.getString("config.cbOverwrite.toolTipText"));
        this.cbSwitchFilename.setText(bundle.getString("config.cbSwitchFilename.text"));
        this.cbSwitchFilename.setToolTipText(bundle.getString("config.cbSwitchFilename.toolTipText"));
        this.cbVerbose.setText(bundle.getString("config.cbVerbose.text"));
        this.cbVerbose.setToolTipText(bundle.getString("config.cbVerbose.toolTipText"));
        this.lblBoxtyp.setText(bundle.getString("MainWindow.lblBoxtyp.text"));
        this.cbRemoveOrig.setText(bundle.getString("MainWindow.cbRemoveOrig.text"));
        this.cbRemoveOrig.setToolTipText(bundle.getString("MainWindow.cbRemoveOrig.toolTipText"));
        this.lblPort2.setText(bundle.getString("MainWindow.lblPort2.text"));
        this.tfWebPort.setToolTipText(bundle.getString("MainWindow.tfWebPort.toolTipText"));
        this.lblRestdauer.setText(bundle.getString("MainWindow.lblRestdauer.text"));
        this.lblRestdauer.setToolTipText(bundle.getString("MainWindow.lblRestdauer.toolTipText"));
        this.tfRestdauerOffset.setToolTipText(bundle.getString("MainWindow.tfRestdauerOffset.toolTipText"));
        this.lblSekunden.setText(bundle.getString("MainWindow.lblSekunden.text"));
        this.lblSekunden.setToolTipText(bundle.getString("MainWindow.lblSekunden.toolTipText"));
        this.btnSpeichern.setText(bundle.getString("config.btnSpeichern.text"));
        this.btnAbbrechen.setText(bundle.getString("config.btnAbbrechen.text"));
    }
}

