/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ApplicationConfigHandler;
import gui.ApplicationLogHandler;
import gui.IApplicationConfig;
import gui.IGuiManagerBean;
import tsStreamRipper.util.logging.ILogEntryObserver;

public class GuiManagerBean
implements IGuiManagerBean {
    private boolean guiRunning = false;
    private boolean streamRunning = true;
    private ApplicationLogHandler loghandler = null;
    private ILogEntryObserver window = null;
    private ApplicationConfigHandler configHandler = new ApplicationConfigHandler();
    private static IGuiManagerBean instance = null;

    @Override
    public boolean isStreamRunning() {
        return this.streamRunning;
    }

    @Override
    public boolean isGuiRunning() {
        return this.guiRunning;
    }

    private void dumpClassLoader() {
        int i = 1;
        ClassLoader cl = this.getClass().getClassLoader();
        while (cl != null) {
            System.out.println("CL " + i++ + " > " + cl);
            cl = cl.getParent();
        }
        this.getClass().getClassLoader();
        System.out.println("System CL :" + ClassLoader.getSystemClassLoader());
        System.out.println("---------------------");
    }

    public static IGuiManagerBean getInstance() {
        if (instance == null) {
            instance = new GuiManagerBean();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoghandler(ApplicationLogHandler loghandler) {
        GuiManagerBean guiManagerBean = this;
        synchronized (guiManagerBean) {
            this.loghandler = loghandler;
            if (this.window != null) {
                loghandler.setMyLogObserver(this.window);
            }
        }
    }

    @Override
    public ApplicationLogHandler getLoghandler() {
        return this.loghandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWindow(ILogEntryObserver window) {
        GuiManagerBean guiManagerBean = this;
        synchronized (guiManagerBean) {
            this.guiRunning = true;
            this.window = window;
            if (this.loghandler != null) {
                this.loghandler.setMyLogObserver(window);
            }
        }
    }

    @Override
    public IApplicationConfig getConfig() {
        return this.configHandler.getConfig();
    }

    @Override
    public void setConfig(ApplicationConfigHandler configHandler) {
        this.configHandler = configHandler;
    }

    @Override
    public void saveConfig() {
        if (this.configHandler != null) {
            this.configHandler.saveConfig();
        }
    }

    @Override
    public void resetConfig() {
        if (this.configHandler != null) {
            this.configHandler.saveConfig();
        }
    }

    @Override
    public void setGuiRunning(boolean guiRunning) {
        this.guiRunning = guiRunning;
    }

    @Override
    public void setStreamRunning(boolean streamRunning) {
        this.streamRunning = streamRunning;
    }
}

