/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ApplicationConfigHandler;
import gui.ChannelEntry;
import gui.Einstellungen;
import gui.GuiManagerBean;
import gui.IApplicationConfig;
import gui.MessageDialog;
import gui.Verzeichnisse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import tsStreamRipper.Configuration;
import tsStreamRipper.StreamIt;
import tsStreamRipper.audio.ConverterFactory;
import tsStreamRipper.audio.ConverterOption;
import tsStreamRipper.dream.filestream.IFileStreamNameFormatter;
import tsStreamRipper.dream.filestream.InterpretTitelFormat;
import tsStreamRipper.dream.filestream.TitelInterpretFormat;
import tsStreamRipper.dream.webinterface.HttpParameter;
import tsStreamRipper.dream.webinterface.parser.EPGType;
import tsStreamRipper.dream.webstreaming.IExceptionCallback;
import tsStreamRipper.dream.webstreaming.StreamChannel;
import tsStreamRipper.util.logging.Config;
import tsStreamRipper.util.logging.ILogEntryObserver;

public class MainWindow
extends JFrame
implements ILogEntryObserver,
IExceptionCallback {
    private static final Logger log = Logger.getLogger(MainWindow.class.getName());
    private ApplicationConfigHandler configHandler = new ApplicationConfigHandler();
    private Properties channelIdList = new Properties();
    private StreamChannel chan = null;
    private MessageDialog dlgMessage = new MessageDialog(this);
    private static final int MAX_CHAR_LOG_BUFFER = 1000000;
    private static final long serialVersionUID = 1L;
    private JMenuBar menuBar;
    private JMenu menu;
    private JMenuItem menuEinstellungen;
    private JMenuItem menuVerzeichnisse;
    private JMenuItem menuQuit;
    private JPanel panelLog;
    private JScrollPane scrollPane1;
    private JTextArea logArea;
    private JPanel panelSelection;
    private JLabel label2;
    private JComboBox cbChannel;
    private JLabel label3;
    private JTextField tfSref;
    private JButton btnStream;
    private JLabel lblMusicDir;
    private JTextField tfMusicDir;
    private JButton btnAufnahmeverz;
    private JLabel lblAufnahmeLaeuft;
    private JButton btnStopp;
    private JLabel lblEPGType;
    private JComboBox cbEpgType;

    public MainWindow() {
        this.initComponents();
        this.modusKeineAufnahme();
        this.reloadConfig();
    }

    private void modusKeineAufnahme() {
        this.lblAufnahmeLaeuft.setVisible(false);
        this.btnStream.setEnabled(true);
        this.btnStopp.setEnabled(false);
        GuiManagerBean.getInstance().setStreamRunning(false);
    }

    private void modusAufnahme() {
        this.lblAufnahmeLaeuft.setVisible(true);
        this.btnStream.setEnabled(false);
        this.btnStopp.setEnabled(true);
        GuiManagerBean.getInstance().setStreamRunning(true);
    }

    private boolean validateStreamData() {
        if (this.tfSref.getText().trim().equals("")) {
            this.dlgMessage.setErrorText("Bitte geben Sie eine Channel ID an.");
            this.dlgMessage.setVisible(true);
            return false;
        }
        if (this.tfMusicDir.getText().trim().equals("")) {
            this.dlgMessage.setErrorText("Bitte geben Sie ein Aufnahmeverzeichnis an.");
            this.dlgMessage.setVisible(true);
            return false;
        }
        File f = new File(this.tfMusicDir.getText());
        if (!f.isDirectory()) {
            this.dlgMessage.setErrorText("Das angegebene Aufnahmeverzeichnis ist kein Verzeichnis!");
            this.dlgMessage.setVisible(true);
            return false;
        }
        IApplicationConfig c = this.configHandler.getConfig();
        if (c.getHost().trim().equals("") || c.getPort().trim().equals("")) {
            this.dlgMessage.setErrorText("Bitte gehen Sie in das Men\u00fc 'Einstellungen' und konfigurieren den Hostnamen und Port Ihrer Dreambox.");
            this.dlgMessage.setVisible(true);
            return false;
        }
        if (!"".equals(c.getTmpDir()) && !(f = new File(c.getTmpDir())).isDirectory()) {
            this.dlgMessage.setErrorText("Das angegebene Temp-Verzeichnis ist kein Verzeichnis! Tmp-Pfad in Einstellungen korrekt angeben oder Eintrag l\u00f6schen.");
            this.dlgMessage.setVisible(true);
            return false;
        }
        return true;
    }

    private void reloadConfig() {
        this.configHandler.resetConfig();
        try {
            if (this.configHandler.getConfig().getBoxType().equals((Object)ApplicationConfigHandler.BoxType.SAT)) {
                this.channelIdList.load(StreamIt.class.getResourceAsStream("/channel.properties"));
            } else if (this.configHandler.getConfig().getBoxType().equals((Object)ApplicationConfigHandler.BoxType.KABEL)) {
                this.channelIdList.load(StreamIt.class.getResourceAsStream("/channel_kd.properties"));
            } else {
                log.severe("Boxtyp unbekannt");
            }
        }
        catch (Exception e) {
            log.severe("Laden der Channel-Property Liste fehlgeschlagen.");
        }
        this.cbChannel.removeAllItems();
        this.cbChannel.addItem(ChannelEntry.FREI);
        this.cbChannel.addItem(ChannelEntry.CE_60er_70er);
        this.cbChannel.addItem(ChannelEntry.CE_80er_90er);
        this.cbChannel.addItem(ChannelEntry.CE_Country);
        this.cbChannel.addItem(ChannelEntry.CE_DeutscheCharts);
        this.cbChannel.addItem(ChannelEntry.CE_Lovesongs);
        this.cbChannel.addItem(ChannelEntry.CE_RnB_Hiphop);
        this.cbChannel.addItem(ChannelEntry.CE_RockHymnen);
        this.cbEpgType.removeAllItems();
        this.cbEpgType.addItem(EPGType.SKY_RADIO);
        this.cbEpgType.addItem(EPGType.KD_23_5_GRAD);
        this.cbEpgType.addItem(EPGType.SWISS_SATELLITE_RADIO);
    }

    private void startStreaming() {
        IApplicationConfig c = this.configHandler.getConfig();
        HttpParameter params = new HttpParameter(c.getHost(), Integer.parseInt(c.getWebport()), Integer.parseInt(c.getPort()), c.getUsername(), c.getPasswort());
        try {
            ConverterOption convertOpt = null;
            switch (c.getConverter()) {
                case KEINE_KONVERTIERUNG: {
                    break;
                }
                case MP3: {
                    convertOpt = new ConverterOption(ConverterFactory.ConverterType.MP3, new File(c.getLamePath()), c.isRemoveOriginalAfterConvert());
                    break;
                }
                case AAC: {
                    convertOpt = new ConverterOption(ConverterFactory.ConverterType.AAC, new File(c.getFaacPath()), c.isRemoveOriginalAfterConvert());
                    break;
                }
            }
            IFileStreamNameFormatter nameFormat = null;
            nameFormat = c.isSwitchFilename() ? new InterpretTitelFormat() : new TitelInterpretFormat();
            File tmpDir = null;
            if (!c.getTmpDir().trim().equals("")) {
                tmpDir = new File(c.getTmpDir());
            }
            EPGType epgType = (EPGType)((Object)this.cbEpgType.getSelectedItem());
            Configuration config = new Configuration(params, this.tfSref.getText(), tmpDir, new File(this.tfMusicDir.getText()), convertOpt, nameFormat, c.isOverwrite(), Integer.parseInt(c.getRestdauerKorrektur()), epgType);
            this.chan = new StreamChannel(this, config);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    MainWindow.this.chan.start();
                    try {
                        MainWindow.this.chan.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    MainWindow.this.modusKeineAufnahme();
                }
            };
            Thread t = new Thread(r);
            t.start();
        }
        catch (Exception e) {
            log.warning(e.getMessage());
        }
    }

    private static void createAndShowGUI() {
        log.finer("starte GUI ...");
        MainWindow mw = new MainWindow();
        mw.setVisible(true);
        GuiManagerBean.getInstance().setWindow(mw);
        log.info("tsStreamRipper Version 1.1.8");
        log.info("tsStreamRipper GUI initialisiert.");
        log.info("F\u00fcr die Kommandozeilen Hilfe das Programm mit 'java -jar tsStreamRipper.jar --help' starten.");
    }

    public static void showMainWindow() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GuiManagerBean.getInstance().setGuiRunning(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Config.configureRuntimeLogging(true, true);
                MainWindow.createAndShowGUI();
            }
        });
    }

    private void menuEinstellungenActionPerformed(ActionEvent e) {
        Einstellungen config = new Einstellungen();
        config.setVisible(true);
        if (GuiManagerBean.getInstance().isStreamRunning()) {
            log.warning("\u00c4nderungen an der Konfiguration sind erst f\u00fcr neue Streams aktiv!");
        }
        this.reloadConfig();
    }

    private void menuVerzeichnisseActionPerformed(ActionEvent e) {
        Verzeichnisse config = new Verzeichnisse(this);
        config.setVisible(true);
        if (GuiManagerBean.getInstance().isStreamRunning()) {
            log.warning("\u00c4nderungen an der Konfiguration sind erst f\u00fcr neue Streams aktiv!");
        }
        this.reloadConfig();
    }

    private void menuQuitActionPerformed(ActionEvent e) {
        this.quitProgram();
    }

    private void quitProgram() {
        log.info("Anwendung wird geschlossen ...");
        if (this.chan != null) {
            this.chan.stopStreamBaseThread();
        }
        this.setVisible(false);
        this.dispose();
    }

    private void cbChannelItemStateChanged(ItemEvent e) {
        ChannelEntry ce = (ChannelEntry)((Object)e.getItem());
        this.tfSref.setText(this.channelIdList.getProperty(ce.getChannelPropertiesKey()));
        this.tfSref.setEditable(false);
        this.cbEpgType.setEnabled(false);
        switch (ce) {
            case FREI: {
                this.tfSref.setText("");
                this.tfSref.setEditable(true);
                this.tfMusicDir.setText(this.configHandler.getConfig().getMusicFreieAuswahl());
                this.cbEpgType.setEnabled(true);
                break;
            }
            case CE_60er_70er: {
                this.cbEpgType.setSelectedItem((Object)EPGType.SKY_RADIO);
                this.tfMusicDir.setText(this.configHandler.getConfig().getMusic60er70er());
                break;
            }
            case CE_80er_90er: {
                this.cbEpgType.setSelectedItem((Object)EPGType.SKY_RADIO);
                this.tfMusicDir.setText(this.configHandler.getConfig().getMusic80er90er());
                break;
            }
            case CE_Country: {
                this.cbEpgType.setSelectedItem((Object)EPGType.SKY_RADIO);
                this.tfMusicDir.setText(this.configHandler.getConfig().getMusicCountry());
                break;
            }
            case CE_DeutscheCharts: {
                this.cbEpgType.setSelectedItem((Object)EPGType.SKY_RADIO);
                this.tfMusicDir.setText(this.configHandler.getConfig().getMusicDeutscheCharts());
                break;
            }
            case CE_Lovesongs: {
                this.cbEpgType.setSelectedItem((Object)EPGType.SKY_RADIO);
                this.tfMusicDir.setText(this.configHandler.getConfig().getMusicLovesongs());
                break;
            }
            case CE_RnB_Hiphop: {
                this.cbEpgType.setSelectedItem((Object)EPGType.SKY_RADIO);
                this.tfMusicDir.setText(this.configHandler.getConfig().getMusicRnbHiphop());
                break;
            }
            case CE_RockHymnen: {
                this.cbEpgType.setSelectedItem((Object)EPGType.SKY_RADIO);
                this.tfMusicDir.setText(this.configHandler.getConfig().getMusicRockHymnen());
                break;
            }
            default: {
                this.cbEpgType.setSelectedItem((Object)EPGType.SKY_RADIO);
                log.warning("Channeltyp unbekannt.");
            }
        }
    }

    private void btnStreamActionPerformed(ActionEvent e) {
        if (this.validateStreamData()) {
            this.modusAufnahme();
            this.startStreaming();
        }
    }

    private void btnAufnahmeverzActionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser(new File(this.tfMusicDir.getText()));
        fc.setFileSelectionMode(1);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.tfMusicDir.setText(file.getAbsolutePath());
        }
    }

    private void btnStoppActionPerformed(ActionEvent e) {
        log.info("Stoppe Streaming-Thread aufgrund Anwenderwunsch ...");
        this.chan.stopStreamBaseThread();
        this.modusKeineAufnahme();
    }

    private void thisWindowClosing(WindowEvent e) {
        this.quitProgram();
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.menu = new JMenu();
        this.menuEinstellungen = new JMenuItem();
        this.menuVerzeichnisse = new JMenuItem();
        this.menuQuit = new JMenuItem();
        this.panelLog = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.logArea = new JTextArea();
        this.panelSelection = new JPanel();
        this.label2 = new JLabel();
        this.cbChannel = new JComboBox();
        this.label3 = new JLabel();
        this.tfSref = new JTextField();
        this.btnStream = new JButton();
        this.lblMusicDir = new JLabel();
        this.tfMusicDir = new JTextField();
        this.btnAufnahmeverz = new JButton();
        this.lblAufnahmeLaeuft = new JLabel();
        this.btnStopp = new JButton();
        this.lblEPGType = new JLabel();
        this.cbEpgType = new JComboBox();
        this.setDefaultCloseOperation(3);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/icon_32.gif")).getImage());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.this.thisWindowClosing(e);
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.menuEinstellungen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.menuEinstellungenActionPerformed(e);
            }
        });
        this.menu.add(this.menuEinstellungen);
        this.menuVerzeichnisse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.menuVerzeichnisseActionPerformed(e);
            }
        });
        this.menu.add(this.menuVerzeichnisse);
        this.menuQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.menuQuitActionPerformed(e);
            }
        });
        this.menu.add(this.menuQuit);
        this.menuBar.add(this.menu);
        this.setJMenuBar(this.menuBar);
        this.panelLog.setLayout(new BorderLayout());
        this.scrollPane1.setViewportBorder(null);
        this.logArea.setRows(25);
        this.logArea.setWrapStyleWord(true);
        this.logArea.setLineWrap(true);
        this.logArea.setEditable(false);
        this.logArea.setFont(new Font("Courier", 0, 12));
        this.logArea.setColumns(80);
        this.scrollPane1.setViewportView(this.logArea);
        this.panelLog.add((Component)this.scrollPane1, "Center");
        contentPane.add((Component)this.panelLog, "Center");
        this.cbChannel.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MainWindow.this.cbChannelItemStateChanged(e);
            }
        });
        this.btnStream.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.btnStreamActionPerformed(e);
            }
        });
        this.btnAufnahmeverz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.btnAufnahmeverzActionPerformed(e);
            }
        });
        this.lblAufnahmeLaeuft.setForeground(Color.red);
        this.btnStopp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.this.btnStoppActionPerformed(e);
            }
        });
        this.cbEpgType.setEnabled(false);
        GroupLayout panelSelectionLayout = new GroupLayout(this.panelSelection);
        this.panelSelection.setLayout(panelSelectionLayout);
        panelSelectionLayout.setHorizontalGroup(panelSelectionLayout.createParallelGroup().addGroup(panelSelectionLayout.createSequentialGroup().addGap(19, 19, 19).addGroup(panelSelectionLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(panelSelectionLayout.createSequentialGroup().addGroup(panelSelectionLayout.createParallelGroup().addComponent(this.lblMusicDir).addComponent(this.lblAufnahmeLaeuft)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelSelectionLayout.createParallelGroup().addGroup(panelSelectionLayout.createSequentialGroup().addComponent(this.btnStream).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnStopp)).addGroup(panelSelectionLayout.createSequentialGroup().addComponent(this.tfMusicDir, -2, 550, -2).addGap(18, 18, 18).addComponent(this.btnAufnahmeverz)))).addGroup(panelSelectionLayout.createSequentialGroup().addGroup(panelSelectionLayout.createParallelGroup().addComponent(this.label2, -2, 146, -2).addComponent(this.label3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelSelectionLayout.createParallelGroup().addComponent(this.tfSref, -2, 550, -2).addGroup(panelSelectionLayout.createSequentialGroup().addComponent(this.cbChannel, -2, 199, -2).addGap(36, 36, 36).addComponent(this.lblEPGType, -2, 104, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbEpgType, -2, 199, -2))))).addGap(100, 100, 100)));
        panelSelectionLayout.linkSize(0, this.label2, this.lblMusicDir);
        panelSelectionLayout.setVerticalGroup(panelSelectionLayout.createParallelGroup().addGroup(panelSelectionLayout.createSequentialGroup().addGap(18, 18, 18).addGroup(panelSelectionLayout.createParallelGroup().addGroup(panelSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label2).addComponent(this.cbChannel, -2, -1, -2)).addGroup(panelSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblEPGType).addComponent(this.cbEpgType, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label3).addComponent(this.tfSref, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMusicDir).addComponent(this.tfMusicDir, -2, -1, -2).addComponent(this.btnAufnahmeverz)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(panelSelectionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblAufnahmeLaeuft).addComponent(this.btnStream).addComponent(this.btnStopp)).addContainerGap(-1, Short.MAX_VALUE)));
        contentPane.add((Component)this.panelSelection, "North");
        this.setSize(900, 600);
        this.setLocationRelativeTo(null);
        this.initComponentsI18n();
    }

    private void initComponentsI18n() {
        ResourceBundle bundle = ResourceBundle.getBundle("ui_dialog");
        this.setTitle(bundle.getString("MainWindow.this.title"));
        this.menu.setText(bundle.getString("MainWindow.menu.text"));
        this.menuEinstellungen.setText(bundle.getString("MainWindow.menuEinstellungen.text"));
        this.menuVerzeichnisse.setText(bundle.getString("MainWindow.menuVerzeichnisse.text"));
        this.menuQuit.setText(bundle.getString("MainWindow.menuQuit.text"));
        this.label2.setText(bundle.getString("MainWindow.label2.text"));
        this.cbChannel.setToolTipText(bundle.getString("MainWindow.cbChannel.toolTipText"));
        this.label3.setText(bundle.getString("MainWindow.label3.text"));
        this.label3.setToolTipText(bundle.getString("MainWindow.label3.toolTipText"));
        this.tfSref.setToolTipText(bundle.getString("MainWindow.tfSref.toolTipText"));
        this.btnStream.setText(bundle.getString("MainWindow.btnStream.text"));
        this.btnStream.setToolTipText(bundle.getString("MainWindow.btnStream.toolTipText"));
        this.lblMusicDir.setText(bundle.getString("MainWindow.lblMusicDir.text"));
        this.tfMusicDir.setToolTipText(bundle.getString("MainWindow.tfMusicDir.toolTipText"));
        this.btnAufnahmeverz.setText(bundle.getString("MainWindow.btnAufnahmeverz.text"));
        this.lblAufnahmeLaeuft.setText(bundle.getString("MainWindow.lblAufnahmeLaeuft.text"));
        this.btnStopp.setText(bundle.getString("MainWindow.btnStopp.text"));
        this.btnStopp.setToolTipText(bundle.getString("MainWindow.btnStopp.toolTipText"));
        this.lblEPGType.setText(bundle.getString("MainWindow.lblEPGType.text"));
        this.cbEpgType.setToolTipText(bundle.getString("MainWindow.cbEpgType.toolTipText"));
    }

    @Override
    public void publishLogRecord(String logRecord) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.logArea.getText());
        sb.append(logRecord);
        int diff = sb.length() - 1000000;
        if (diff > 0) {
            sb.delete(0, diff);
        }
        this.logArea.setText(sb.toString());
        this.logArea.scrollRectToVisible(new Rectangle(0, this.logArea.getHeight() - 2, 1, 1));
    }

    @Override
    public void exceptionOccured(Exception e) {
        log.severe("Stoppe Streaming : " + e.getMessage());
        this.modusKeineAufnahme();
    }
}

