/*
 * Decompiled with CFR 0.152.
 */
package mpeg2demux;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import mpeg2demux.MPEG2Addable;
import mpeg2demux.MPEG2Packet;
import mpeg2demux.MPEG2PacketInterface;
import mpeg2demux.MPEG2PacketStreamListener;
import mpeg2demux.MPEG2Parser;

public class MPEG2PESPacket
extends MPEG2Packet
implements MPEG2PacketInterface {
    @Override
    public boolean isMetaStreamPacket() {
        return (0xE0 & this.type) == 224 || (0xE0 & this.type) == 192;
    }

    @Override
    public boolean isVideoPacket() {
        return (0xE0 & this.type) == 224;
    }

    @Override
    public boolean isAudioPacket() {
        return (0xE0 & this.type) == 192;
    }

    @Override
    public boolean hasPTS() {
        return this.data != null && this.size > 0 && (0x80 & this.data[1]) > 0;
    }

    public boolean hasDTS() {
        return this.data != null && this.size > 0 && (0x40 & this.data[1]) > 0;
    }

    @Override
    public long getPTS() {
        if ((0x80 & this.data[1]) > 0) {
            return 0xFFFFFFFFL & (0xEL & (long)this.data[3]) << 28 | (0xFFL & (long)this.data[4]) << 22 | (0xFEL & (long)this.data[5]) << 14 | (0xFFL & (long)this.data[6]) << 7 | (long)((0xFE & this.data[7]) >>> 1);
        }
        return 0L;
    }

    public long getDTS() {
        if ((0x80 & this.data[1]) > 0) {
            return 0xFFFFFFFFL & (0xEL & (long)this.data[8]) << 28 | (0xFFL & (long)this.data[9]) << 22 | (0xFEL & (long)this.data[10]) << 14 | (0xFFL & (long)this.data[11]) << 7 | (long)((0xFE & this.data[12]) >>> 1);
        }
        return 0L;
    }

    @Override
    public void readPacket(InputStream in, MPEG2Parser parser) throws IOException {
        int psize;
        byte[] tmp = new byte[2];
        in.read(tmp, 0, 2);
        this.size = psize = ((0xFF & tmp[0]) << 8) + (0xFF & tmp[1]);
        this.data = new byte[this.size];
        in.read(this.data, 0, this.size);
        System.out.println(this.info());
    }

    @Override
    public String name() {
        String name = "MPEG2PESPacket";
        if ((this.type & 0xE0) == 224) {
            name = String.valueOf(name) + "(V)" + Integer.toHexString(0xFF & this.type);
        } else if ((this.type & 0xC0) == 192) {
            name = String.valueOf(name) + "(A)" + Integer.toHexString(0xFF & this.type);
        }
        if (this.size > 0 && (0x40 & this.data[1]) > 0) {
            name = String.valueOf(name) + " DTS";
        }
        return name;
    }

    @Override
    public String info() {
        StringWriter writer = new StringWriter();
        writer.write("MPEG2PESPacket:");
        if ((this.type & 0xE0) == 224) {
            writer.write("Video:");
        } else if ((this.type & 0xC0) == 192) {
            writer.write("Audio:");
        }
        writer.write(" Size:" + Long.toHexString(this.size) + "\n");
        writer.write("Flags(1):" + Integer.toBinaryString(0xFF & this.data[0]) + "\n");
        int flags = 0xFF & this.data[1];
        writer.write("Flags(2):" + Integer.toBinaryString(flags));
        if ((0x80 & flags) > 0) {
            writer.write(" PTS");
        }
        if ((0x40 & flags) > 0) {
            writer.write(" DTS");
        }
        if ((0x20 & flags) > 0) {
            writer.write(" ESCR");
        }
        if ((0x10 & flags) > 0) {
            writer.write(" ES-rate");
        }
        if ((8 & flags) > 0) {
            writer.write(" DSM trick mode");
        }
        if ((4 & flags) > 0) {
            writer.write(" add (c) info");
        }
        if ((2 & flags) > 0) {
            writer.write(" CRC");
        }
        if ((1 & flags) > 0) {
            writer.write(" Extension");
        }
        writer.write("\nPES Header length" + Integer.toHexString(0xFF & this.data[4]) + "\n");
        int i = 3;
        if ((0x80 & flags) > 0) {
            long PTS = 0xFFFFFFFFL & (0xEL & (long)this.data[i]) << 28 | (0xFFL & (long)this.data[i + 1]) << 22 | (0xFEL & (long)this.data[i + 2]) << 14 | (0xFFL & (long)this.data[i + 3]) << 7 | (long)((0xFE & this.data[i + 4]) >>> 1);
            int PTSf = (0xF0 & this.data[i]) >>> 4;
            writer.write("PTS: " + Long.toHexString(PTS) + " " + this.MpegTimeStampToString(PTS) + " PTS-Flags: " + Integer.toBinaryString(PTSf));
            i += 5;
        }
        if ((0x40 & flags) > 0) {
            long DTS = 0xFFFFFFFFL & (0xEL & (long)this.data[i]) << 28 | (0xFFL & (long)this.data[i + 1]) << 22 | (0xFEL & (long)this.data[i + 2]) << 14 | (0xFFL & (long)this.data[i + 3]) << 7 | (long)((0xFE & this.data[i + 4]) >>> 1);
            int DTSf = (0xF0 & this.data[i]) >>> 4;
            writer.write(" DTS: " + Long.toHexString(DTS) + " " + this.MpegTimeStampToString(DTS) + " DTS-Flags: " + Integer.toBinaryString(DTSf));
            i += 5;
        }
        if ((0x20 & flags) > 0) {
            long ESCR = 0xFFFFFFFFL & (0x42L & (long)this.data[i]) << 26 | (3L & (long)this.data[i]) << 28 | (0xFFL & (long)this.data[i + 1]) << 20 | (0xF8L & (long)this.data[i + 2]) << 12 | (3L & (long)this.data[i + 2]) << 13 | (0xFFL & (long)this.data[i + 3]) << 5 | (0xF8L & (long)this.data[i + 4]) >> 3;
            writer.write(" ESCR: " + Long.toHexString(ESCR));
            i += 6;
        }
        writer.write("\n");
        if ((0x10 & flags) > 0) {
            long ESR = 0xFFFFFFFFL & (long)((0x7F & this.data[i]) << 15) | (long)((0xFF & this.data[i + 1]) << 7) | (long)((0xFE & this.data[i + 2]) >>> 1);
            writer.write(" ES Rate: " + Long.toHexString(ESR * 50L) + "b/s");
            i += 6;
        }
        if ((8 & flags) > 0) {
            i += 4;
        }
        if ((4 & flags) > 0) {
            ++i;
        }
        if ((2 & flags) > 0) {
            i += 2;
        }
        if ((1 & flags) > 0) {
            flags = 0xFF & this.data[i];
            ++i;
            writer.write("\nFlags(3):" + Integer.toBinaryString(flags) + " ");
            if ((0x80 & flags) > 0) {
                writer.write(" Priv.Data");
            }
            if ((0x40 & flags) > 0) {
                writer.write(" Pack Header");
            }
            if ((0x20 & flags) > 0) {
                writer.write(" Seq.Counter");
            }
            if ((0x10 & flags) > 0) {
                writer.write(" P-STD Buffer");
            }
            if ((1 & flags) > 0) {
                writer.write(" PES-Extension");
            }
            writer.write("\n");
            if ((0x80 & flags) > 0) {
                i += 128;
            }
            if ((0x40 & flags) > 0) {
                int l = 0xFF & this.data[i];
                writer.write("Pack length:" + Integer.toHexString(l));
                i += l + 1;
            }
            if ((0x20 & flags) > 0) {
                int l = 0x7F & this.data[i];
                writer.write("Seq.Counter:" + Integer.toHexString(l));
                l = 0x7F & this.data[i + 1];
                writer.write("Stuffing length:" + Integer.toHexString(l));
                i += 2;
            }
            if ((0x10 & flags) > 0) {
                int m = 128;
                int l = 0xFF & this.data[i];
                if ((l & 0x20) > 0) {
                    writer.write("Scaled");
                    m = 1024;
                }
                l = ((l & 0x1F) << 8 | 0xFF & this.data[i]) * m;
                writer.write("P-STD Buff-Size:" + Integer.toHexString(l));
                i += 2;
            }
            if ((1 & flags) > 0) {
                int l = 0xFF & this.data[i];
                writer.write("Ext.Pack length:" + Integer.toHexString(l));
                i += l + 1;
            }
        }
        writer.write("\nSize of headers:" + Integer.toHexString(i));
        return writer.toString();
    }

    @Override
    public int sizePacketHeader() {
        int pad;
        if (this.data == null || this.size == 0) {
            return 0;
        }
        int i = this.data[2] + 3;
        if ((this.type & 0xE0) == 224 && this.data[i] != 0 && (pad = this.skipStuffingBytes(this.data, i, this.size)) > 0) {
            i += pad;
        }
        return i;
    }

    public int skipStuffingBytes(byte[] in, int start, int stop) {
        int i = start;
        while (i < stop) {
            if (in[i] != -1) break;
            ++i;
        }
        return i - start;
    }

    @Override
    public boolean parseEncapsulatedData(MPEG2PacketStreamListener listener, MPEG2Addable collector) {
        boolean res = true;
        MPEG2Parser parser = new MPEG2Parser();
        BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(this.getData()));
        try {
            res = parser.parsePStream(in, listener, collector);
        }
        catch (IOException e) {
            System.out.println("Exception:" + e);
        }
        return res;
    }
}

