/*
 * Decompiled with CFR 0.152.
 */
package mpeg2demux;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import mpeg2demux.MPEG2Addable;
import mpeg2demux.MPEG2PacketInterface;
import mpeg2demux.MPEG2PacketStreamListener;
import mpeg2demux.MPEG2Parser;

public class MPEG2Packet
implements MPEG2PacketInterface {
    public static final int MPEG2HeadSize = 4;
    protected long filePos;
    protected byte[] header = new byte[3];
    protected int type = 0;
    protected byte[] data;
    protected int size = 0;

    @Override
    public long getFilePos() {
        return this.filePos;
    }

    @Override
    public void setFilePos(long filePos) {
        this.filePos = filePos;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public void setHeader(byte[] header) {
        this.header = header;
    }

    @Override
    public int type() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public void setSize(int iSize) {
        this.size = iSize;
    }

    @Override
    public void readPacketWithSize(InputStream in, int size) throws IOException {
        in.read(this.data, 0, size);
    }

    @Override
    public void readPacket(InputStream in, MPEG2Parser parser) throws IOException {
    }

    @Override
    public void writePacket(OutputStream out) throws IOException {
        out.write(0);
        out.write(0);
        out.write(1);
        out.write(this.type);
        out.write(this.data, 0, this.size);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String name() {
        return "MPEG2-Packet";
    }

    @Override
    public String info() {
        return "MPEG2-Packet";
    }

    public String toString() {
        return this.name();
    }

    @Override
    public int sizePacketHeader() {
        return 0;
    }

    @Override
    public long getPTS() {
        return 0L;
    }

    @Override
    public boolean isMetaStreamPacket() {
        return false;
    }

    @Override
    public boolean isStructurePacket() {
        return true;
    }

    @Override
    public boolean isVideoPacket() {
        return false;
    }

    @Override
    public boolean isAudioPacket() {
        return false;
    }

    @Override
    public boolean hasPTS() {
        return false;
    }

    public String MpegTimeStampToString(long ts) {
        long r = 324000000L;
        long r1 = 5400000L;
        long h = ts / r;
        long min = (ts %= r) / r1;
        long sec = (ts %= r1) / 90000L;
        return String.valueOf(Long.toString(h)) + ":" + Long.toString(min) + "." + Long.toString(sec) + "." + Long.toString(ts %= 90000L);
    }

    @Override
    public boolean parseEncapsulatedData(MPEG2PacketStreamListener listener, MPEG2Addable collector) {
        return true;
    }
}

