/*
 * Decompiled with CFR 0.152.
 */
package mpeg2demux;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import mpeg2demux.MPEG2Addable;
import mpeg2demux.MPEG2Extension;
import mpeg2demux.MPEG2GroupHeader;
import mpeg2demux.MPEG2PESPacket;
import mpeg2demux.MPEG2Packet;
import mpeg2demux.MPEG2PacketInterface;
import mpeg2demux.MPEG2PacketStreamListener;
import mpeg2demux.MPEG2PictureHeader;
import mpeg2demux.MPEG2PictureSlice;
import mpeg2demux.MPEG2ProgramEndCode;
import mpeg2demux.MPEG2ProgramPack;
import mpeg2demux.MPEG2ProgramStreamSystemHeader;
import mpeg2demux.MPEG2SequenceEndCode;
import mpeg2demux.MPEG2SequenceHeader;

public class MPEG2Parser
implements MPEG2PacketStreamListener {
    public static final int MPEG2ProgramStreamSystemHeader = 187;
    public static final int MPEG2ProgramPack = 186;
    public static final int MPEG2ProgramEndCode = 185;
    public static final int MPEG2GroupHeader = 184;
    public static final int MPEG2SequenceEndCode = 183;
    public static final int MPEG2ExtensionHeader = 181;
    public static final int MPEG2SequenceHeader = 179;
    public static final int MPEG2UserData = 178;
    public static final int MPEG2PictureHeader = 0;
    public static final int MPEG2ESequenceExtensionID = 1;
    public static final int MPEG2ESequenceDisplayExtensionID = 2;
    public static final int MPEG2EQuantMatrixExtensionID = 3;
    public static final int MPEG2ECopyrightExtensionID = 4;
    public static final int MPEG2ESequenceScalableExtensionID = 5;
    public static final int MPEG2EPictureDisplayExtensionID = 7;
    public static final int MPEG2EPictureCodingExtensionID = 8;
    public static final int MPEG2EPictureSpatialScalableExtensionID = 9;
    public static final int MPEG2EPictureTemporalScalableExtensionID = 10;
    private static final int scanSize = 4096;
    private byte[] scanbuffer = new byte[4096];

    @Override
    public boolean onPacketReceive(MPEG2PacketInterface packet, long position, MPEG2Addable collector) {
        System.out.println("Position: " + Long.toHexString(position) + " " + packet.name());
        return true;
    }

    public static void main(String[] args) {
        MPEG2Parser mpeg2parser = new MPEG2Parser();
        switch (args.length) {
            case 1: {
                mpeg2parser.parsePESFile(args[0], mpeg2parser, null);
                break;
            }
            default: {
                System.out.println("Usage: MPEG2Parser file\n");
            }
        }
    }

    void parsePESFile(String filename, MPEG2PacketStreamListener listener, MPEG2Addable collector) {
        File file = new File(filename);
        try {
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                BufferedInputStream in = new BufferedInputStream(fileInputStream, 4096);
                this.parsePEStream(in, listener, collector);
                in.close();
            }
        }
        catch (IOException e) {
            System.out.println("Exception:" + e);
        }
    }

    public long scanForMPEGHeader(InputStream in, int max) throws IOException {
        int b;
        long counter = 0L;
        int index = 0;
        byte[] queue = new byte[3];
        while ((b = in.read()) >= 0 && counter < (long)max) {
            queue[index] = (byte)b;
            ++counter;
            if (++index != 3) continue;
            if (queue[0] == 0 && queue[1] == 0 && queue[2] == 1) {
                return (int)counter - 3;
            }
            queue[0] = queue[1];
            queue[1] = queue[2];
            index = 2;
        }
        return -counter;
    }

    public long readUptoMPEGHeader(InputStream in, int max, byte[] data) throws IOException {
        int b;
        long counter = 0L;
        int index = 0;
        while ((b = in.read()) >= 0 && counter < (long)max) {
            data[index] = (byte)b;
            ++counter;
            if (index > 2 && data[index - 2] == 0 && data[index - 1] == 0 && data[index] == 1) {
                return (int)counter - 3;
            }
            ++index;
        }
        return -counter;
    }

    public long scanForNextStartCode(InputStream in, int max) throws IOException {
        long startcode = this.scanForMPEGHeader(in, max);
        if (startcode >= 0L) {
            return in.read();
        }
        return startcode;
    }

    public boolean parsePEStream(InputStream in, MPEG2PacketStreamListener listener, MPEG2Addable collector) throws IOException {
        long counter = 0L;
        long offset = 0L;
        int ptype = -1;
        boolean cont = true;
        boolean scanForNextStartCode = true;
        do {
            if (scanForNextStartCode && (offset = this.scanForNextStartCode(in, 4096)) >= 0L) {
                ptype = (int)offset;
                if ((ptype & 0xE0) == 224 || (ptype & 0xE0) == 192) {
                    MPEG2PESPacket p = new MPEG2PESPacket();
                    p.setFilePos(counter);
                    p.setType(ptype);
                    p.readPacket(in, this);
                    scanForNextStartCode = true;
                    if (listener != null) {
                        cont = listener.onPacketReceive(p, counter, collector);
                    }
                    counter += (long)p.size();
                } else {
                    System.out.print("1> Undecoded packet:" + Integer.toHexString(ptype));
                }
            }
            if (cont) continue;
            return cont;
        } while (offset >= 0L || offset == -4096L);
        return true;
    }

    public boolean parsePStream(InputStream in, MPEG2PacketStreamListener listener, MPEG2Addable collector) throws IOException {
        long counter = 0L;
        long offset = 0L;
        int ptype = -1;
        int petype = -1;
        boolean cont = true;
        boolean scanForNextStartCode = true;
        MPEG2Packet p = null;
        do {
            if (scanForNextStartCode) {
                offset = this.scanForNextStartCode(in, 4096);
                ptype = offset >= 0L ? (int)offset : -1;
            }
            switch (ptype) {
                case -1: {
                    break;
                }
                case 186: {
                    p = new MPEG2ProgramPack();
                    p.setFilePos(counter);
                    p.readPacket(in, this);
                    scanForNextStartCode = true;
                    if (listener != null) {
                        cont = listener.onPacketReceive(p, counter, collector);
                    }
                    counter += (long)p.size();
                    break;
                }
                case 185: {
                    p = new MPEG2ProgramEndCode();
                    p.setFilePos(counter);
                    p.readPacket(in, this);
                    scanForNextStartCode = true;
                    if (listener != null) {
                        cont = listener.onPacketReceive(p, counter, collector);
                    }
                    counter += (long)p.size();
                    break;
                }
                case 184: {
                    p = new MPEG2GroupHeader();
                    p.setFilePos(counter);
                    p.readPacket(in, this);
                    scanForNextStartCode = true;
                    if (listener != null) {
                        cont = listener.onPacketReceive(p, counter, collector);
                    }
                    counter += (long)p.size();
                    break;
                }
                case 187: {
                    p = new MPEG2ProgramStreamSystemHeader();
                    p.setFilePos(counter);
                    p.readPacket(in, this);
                    scanForNextStartCode = true;
                    if (listener != null) {
                        cont = listener.onPacketReceive(p, counter, collector);
                    }
                    counter += (long)p.size();
                    break;
                }
                case 183: {
                    p = new MPEG2SequenceEndCode();
                    p.setFilePos(counter);
                    p.readPacket(in, this);
                    scanForNextStartCode = true;
                    if (listener != null) {
                        cont = listener.onPacketReceive(p, counter, collector);
                    }
                    counter += (long)p.size();
                    break;
                }
                case 179: {
                    byte[] tmp;
                    int size;
                    p = new MPEG2SequenceHeader();
                    p.setFilePos(counter);
                    p.readPacket(in, this);
                    if (listener != null) {
                        cont = listener.onPacketReceive(p, counter, collector);
                    }
                    counter += (long)p.size();
                    offset = this.scanForNextStartCode(in, 4096);
                    if (offset >= 0L) {
                        petype = (int)offset;
                    }
                    while (petype == 181 && !cont) {
                        p = new MPEG2Extension();
                        p.setFilePos(counter);
                        p.setType((byte)petype);
                        size = (int)this.readUptoMPEGHeader(in, 4096, this.scanbuffer);
                        if (size >= 0) {
                            tmp = new byte[size];
                            System.arraycopy(this.scanbuffer, 0, tmp, 0, size);
                            p.setData(tmp);
                            p.setSize(size);
                            if (listener != null) {
                                cont = cont && listener.onPacketReceive(p, counter, collector);
                            }
                            counter += (long)size;
                            petype = in.read();
                            continue;
                        }
                        System.out.print("Sequence extension header with wrong size:" + Long.toHexString(counter));
                    }
                    scanForNextStartCode = false;
                    ptype = petype;
                    break;
                }
                case 0: {
                    byte[] tmp;
                    int size;
                    p = new MPEG2PictureHeader();
                    p.setFilePos(counter);
                    p.readPacket(in, this);
                    if (listener != null) {
                        cont = listener.onPacketReceive(p, counter, collector);
                    }
                    counter += (long)p.size();
                    offset = this.scanForNextStartCode(in, 4096);
                    if (offset >= 0L) {
                        petype = (int)offset;
                    }
                    while (petype == 181 && !cont) {
                        p = new MPEG2Extension();
                        p.setType((byte)petype);
                        p.setFilePos(counter);
                        size = (int)this.readUptoMPEGHeader(in, 4096, this.scanbuffer);
                        if (size >= 0) {
                            tmp = new byte[size];
                            System.arraycopy(this.scanbuffer, 0, tmp, 0, size);
                            p.setData(tmp);
                            p.setSize(size);
                            if (listener != null) {
                                cont = cont && listener.onPacketReceive(p, counter, collector);
                            }
                            counter += (long)size;
                            petype = in.read();
                            continue;
                        }
                        System.out.print("Picture Extension header with wrong size:" + Long.toHexString(counter));
                    }
                    scanForNextStartCode = false;
                    ptype = petype;
                    break;
                }
                case 181: {
                    byte[] tmp;
                    p = new MPEG2Extension();
                    p.setType((byte)ptype);
                    p.setFilePos(counter);
                    int size = (int)this.readUptoMPEGHeader(in, 4096, this.scanbuffer);
                    if (size >= 0) {
                        tmp = new byte[size];
                        System.arraycopy(this.scanbuffer, 0, tmp, 0, size);
                        p.setData(tmp);
                        p.setSize(size);
                        if (listener != null) {
                            cont = cont && listener.onPacketReceive(p, counter, collector);
                        }
                        counter += (long)size;
                        petype = in.read();
                    } else {
                        System.out.print("Extension header with wrong size:" + Long.toHexString(counter));
                    }
                    scanForNextStartCode = false;
                    ptype = petype;
                    break;
                }
                default: {
                    byte[] tmp;
                    int size;
                    if ((ptype & 0xE0) == 224 || (ptype & 0xE0) == 192) {
                        System.out.print("PES packet in program stream:" + Long.toHexString(counter));
                        break;
                    }
                    if (ptype > 0 && ptype < 176) {
                        p = new MPEG2PictureSlice();
                        p.setFilePos(counter);
                        p.setType((byte)ptype);
                        size = (int)this.readUptoMPEGHeader(in, 4096, this.scanbuffer);
                        if (size >= 0) {
                            tmp = new byte[size];
                            System.arraycopy(this.scanbuffer, 0, tmp, 0, size);
                            p.setData(tmp);
                            p.setSize(size);
                            if (listener != null) {
                                cont = listener.onPacketReceive(p, counter, collector);
                            }
                            counter += (long)size;
                            ptype = in.read();
                            scanForNextStartCode = false;
                            break;
                        }
                        scanForNextStartCode = true;
                        break;
                    }
                    System.out.print("2> Undecoded packet:" + Integer.toHexString(ptype));
                }
            }
            if (cont) continue;
            return cont;
        } while (offset >= 0L || offset == -4096L);
        return true;
    }
}

