/*
 * Decompiled with CFR 0.152.
 */
package mpeg2demux;

import java.io.IOException;
import java.io.InputStream;
import mpeg2demux.MPEG2Packet;
import mpeg2demux.MPEG2PacketInterface;
import mpeg2demux.MPEG2Parser;

public class MPEG2PictureHeader
extends MPEG2Packet
implements MPEG2PacketInterface {
    @Override
    public String name() {
        String name = "MPEG2PictureHeader";
        return name;
    }

    public int getPictureType() {
        return (0x3F & this.data[1]) >> 3;
    }

    @Override
    public String info() {
        String name = "MPEG2PictureHeader";
        if (this.size > 2) {
            int picture_coding_type = (0x3F & this.data[1]) >> 3;
            switch (picture_coding_type) {
                case 1: {
                    name = String.valueOf(name) + " I-Frame";
                    break;
                }
                case 2: {
                    name = String.valueOf(name) + " P-Frame";
                    break;
                }
                case 3: {
                    name = String.valueOf(name) + " B-Frame";
                    break;
                }
            }
        }
        return name;
    }

    @Override
    public void readPacket(InputStream in, MPEG2Parser parser) throws IOException {
        byte[] tmp = new byte[2];
        this.type = 0;
        in.read(tmp, 0, 2);
        int psize = 4;
        int picture_coding_type = (0x3F & tmp[1]) >> 3;
        switch (picture_coding_type) {
            case 1: {
                break;
            }
            case 2: {
                psize = 5;
                break;
            }
            case 3: {
                psize = 5;
                break;
            }
        }
        this.data = new byte[psize];
        this.data[0] = tmp[0];
        this.data[1] = tmp[1];
        in.read(this.data, 2, psize - 2);
        this.size = psize;
    }
}

