/*
 * Decompiled with CFR 0.152.
 */
package mpeg2demux;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import mpeg2demux.MPEG2Packet;
import mpeg2demux.MPEG2PacketInterface;
import mpeg2demux.MPEG2Parser;

public class MPEG2SequenceHeader
extends MPEG2Packet
implements MPEG2PacketInterface {
    @Override
    public void readPacket(InputStream in, MPEG2Parser parser) throws IOException {
        byte[] tmp = new byte[8];
        byte[] tmp2 = new byte[64];
        this.type = 179;
        in.read(tmp, 0, 8);
        this.size = 8;
        byte flags = (byte)(3 & tmp[7]);
        if ((2 & flags) > 0) {
            in.read(tmp2, 0, 64);
            this.size += 64;
            flags = (byte)(flags | 1 & tmp2[63]);
        }
        if ((1 & flags) > 0) {
            this.size += 64;
        }
        this.data = new byte[this.size];
        System.arraycopy(tmp, 0, this.data, 0, 8);
        int offset = 8;
        if ((2 & flags) > 0) {
            System.arraycopy(tmp2, 0, this.data, offset, 64);
            offset += 64;
        }
        if ((1 & flags) > 0) {
            in.read(this.data, offset, 64);
        }
    }

    @Override
    public String name() {
        return "MPEG2 SequenceHeader";
    }

    @Override
    public String info() {
        String[] aspectRatios = new String[]{"inv!", "1:1", "3:4", "9:16", "1:2,21"};
        String[] frameRates = new String[]{"inv!", "23,976", "24", "25", "29,97", "30", "50", "59,94", "60"};
        StringWriter writer = new StringWriter();
        writer.write("MPEG2 SequenceHeader:\n");
        int i = 0;
        int width = (0xFF & this.data[i]) + (0xF0 & this.data[i + 1]) << 4;
        int height = (0xF & this.data[i + 1]) << 8 + (0xF0 & this.data[i + 2]);
        writer.write("Resolution: " + width + "x" + height + " ");
        int aspectRatio = (0xF0 & this.data[i + 3]) >>> 4;
        writer.write("AspectRatio: " + aspectRatios[aspectRatio] + " ");
        int frameRate = 0xF & this.data[i + 3];
        writer.write("Frame rate: " + frameRates[frameRate] + "\n");
        int bitrate = 0xFF & this.data[i + 4] | (0xFF & this.data[i + 5]) << 8 | (0xC0 & this.data[i + 6]) << 10;
        writer.write("Bitrate: " + bitrate * 400 + "Bits/s ");
        int vbvBufferSize = (0x1F & this.data[i + 6]) + (0xF7 & this.data[i + 7]) << 2;
        writer.write("VBV-Buffer-Size: " + vbvBufferSize + "\n");
        return writer.toString();
    }
}

