/*
 * Decompiled with CFR 0.152.
 */
package mpeg2demux;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import mpeg2demux.MPEG2Addable;
import mpeg2demux.MPEG2PacketInterface;
import mpeg2demux.MPEG2PacketStreamListener;
import mpeg2demux.MPEG2Parser;

public class MPEG2StreamDemuxer
implements MPEG2PacketStreamListener {
    private static int BufferSize = 4096;
    protected BufferedOutputStream audioOut;
    protected BufferedOutputStream videoOut;
    protected ArrayList infiles = new ArrayList();
    private static boolean audioPTS = false;
    private static boolean videoPTS = false;
    private static long firstAudioPTS;
    private static long firstVideoPTS;
    private int packetCounter = 0;

    public BufferedOutputStream getAudioOut() {
        return this.audioOut;
    }

    public void setAudioOut(BufferedOutputStream out) {
        this.audioOut = out;
    }

    public BufferedOutputStream getVideoOut() {
        return this.videoOut;
    }

    public void setVideoOut(BufferedOutputStream out) {
        this.videoOut = out;
    }

    private void closeOutputStreams() throws IOException {
        if (this.videoOut != null) {
            this.videoOut.close();
        }
        if (this.audioOut != null) {
            this.audioOut.close();
        }
    }

    private long videoAudioDelay() {
        long msec = (firstVideoPTS - firstAudioPTS) / 90L;
        return msec;
    }

    public int scanForMPEGAudioHeaderArray(byte[] in, int start, int stop) {
        int index = 0;
        int i = start;
        byte[] queue = new byte[3];
        while (i < stop) {
            queue[index] = in[i];
            ++i;
            if (++index != 2) continue;
            if (queue[0] == -1 && queue[1] == -4) {
                return i - start - 2;
            }
            queue[0] = queue[1];
            index = 1;
        }
        return -(i - start);
    }

    public static boolean determineAVDelay(MPEG2PacketInterface packet) {
        if (packet.isAudioPacket() && packet.hasPTS()) {
            if (!audioPTS) {
                firstAudioPTS = packet.getPTS();
            }
            audioPTS = true;
        }
        if (packet.isVideoPacket() && packet.hasPTS()) {
            if (!videoPTS) {
                firstVideoPTS = packet.getPTS();
            }
            videoPTS = true;
        }
        return videoPTS && audioPTS;
    }

    @Override
    public boolean onPacketReceive(MPEG2PacketInterface packet, long position, MPEG2Addable collector) {
        block8: {
            int sizeHeader = packet.sizePacketHeader();
            int sizeData = packet.size() - sizeHeader;
            ++this.packetCounter;
            try {
                if (packet.isMetaStreamPacket()) {
                    if (packet.isAudioPacket() && this.audioOut != null && (packet.hasPTS() || audioPTS)) {
                        if (!audioPTS) {
                            firstAudioPTS = packet.getPTS();
                            int skip = this.scanForMPEGAudioHeaderArray(packet.getData(), sizeHeader, packet.size());
                            if (skip > 0) {
                                sizeHeader += skip;
                                sizeData -= skip;
                            }
                        }
                        this.audioOut.write(packet.getData(), sizeHeader, sizeData);
                        audioPTS = true;
                    }
                    if (packet.isVideoPacket() && this.videoOut != null && (packet.hasPTS() || videoPTS)) {
                        this.videoOut.write(packet.getData(), sizeHeader, sizeData);
                        if (!videoPTS) {
                            firstVideoPTS = packet.getPTS();
                        }
                        videoPTS = true;
                    }
                    break block8;
                }
                System.out.println("This stream must be a PES stream. Demuxing aborted");
                return false;
            }
            catch (IOException e) {
                System.out.println("Exception:" + e);
            }
        }
        return true;
    }

    private void demuxFile(String inFilename, MPEG2PacketStreamListener listener, MPEG2Addable collector) {
        MPEG2Parser parser = new MPEG2Parser();
        parser.parsePESFile(inFilename, listener, collector);
    }

    private void printUsage() {
        System.out.println("Usage: MPEG2StreamDemuxer -i\"file1[,file2]\" -v\"videoout\" -a\"audioout\"\n");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean parseArg(String argString, char actionChar, ArrayList filenames) {
        reader = new StringReader(argString);
        writer = new StringWriter();
        state = 0;
        try {
            block5: while (true) lbl-1000:
            // 5 sources

            {
                if (!reader.ready()) {
                    return false;
                }
                switch (state) {
                    case 0: {
                        c = (char)reader.read();
                        if (c < 0 || c != 45) continue block5;
                        ac = (char)reader.read();
                        if (ac != actionChar) return false;
                        state = 1;
                        ** break;
                    }
                }
                c = reader.read();
                if (c < 0) {
                    filenames.add(writer.toString());
                    return true;
                }
                if (c == 44) {
                    filenames.add(writer.toString());
                    writer = new StringWriter();
                    ** break;
                }
                writer.write(c);
            }
        }
        catch (IOException e) {
            System.out.println("Exception:" + e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        MPEG2StreamDemuxer demuxer = new MPEG2StreamDemuxer();
        ArrayList outfilesVideo = new ArrayList();
        ArrayList outfilesAudio = new ArrayList();
        System.out.println("MPEG2StreamDemuxer V1.2 - 2004-03-07 written by A.Rosenberg");
        System.out.println("       send bugs and comments to mpeg2demuxer@rosen-berg.de\n");
        try {
            switch (args.length) {
                case 1: {
                    if (!demuxer.parseArg(args[0], 'i', demuxer.infiles)) {
                        demuxer.printUsage();
                        return;
                    }
                    MPEG2PacketStreamListener localListener = new MPEG2PacketStreamListener(){
                        MPEG2PacketStreamListener localListener2 = new MPEG2PacketStreamListener(){

                            @Override
                            public boolean onPacketReceive(MPEG2PacketInterface packet, long position, MPEG2Addable collector) {
                                if (packet.type() == 179) {
                                    System.out.println(packet.info());
                                }
                                return true;
                            }
                        };

                        @Override
                        public boolean onPacketReceive(MPEG2PacketInterface packet, long position, MPEG2Addable collector) {
                            if (packet.isMetaStreamPacket()) {
                                packet.parseEncapsulatedData(this.localListener2, null);
                            } else if (packet.type() == 179) {
                                System.out.println(packet.info());
                            }
                            return !MPEG2StreamDemuxer.determineAVDelay(packet);
                        }
                    };
                    int i = 0;
                    while (true) {
                        if (i >= demuxer.infiles.size()) {
                            return;
                        }
                        System.out.println(demuxer.infiles.get(i) + "\n");
                        demuxer.demuxFile((String)demuxer.infiles.get(i), localListener, null);
                        System.out.println("Video/Audio delay (ms):" + demuxer.videoAudioDelay());
                        ++i;
                    }
                }
                case 2: {
                    if (!demuxer.parseArg(args[0], 'i', demuxer.infiles)) {
                        demuxer.printUsage();
                        return;
                    }
                    if (demuxer.parseArg(args[1], 'v', outfilesVideo)) {
                        File videoFile = new File((String)outfilesVideo.get(0));
                        FileOutputStream videoOutputStream = new FileOutputStream(videoFile);
                        BufferedOutputStream videoOut = new BufferedOutputStream(videoOutputStream, BufferSize);
                        demuxer.setVideoOut(videoOut);
                    } else if (demuxer.parseArg(args[1], 'a', outfilesAudio)) {
                        File audioFile = new File((String)outfilesAudio.get(0));
                        FileOutputStream audioOutputStream = new FileOutputStream(audioFile);
                        BufferedOutputStream audioOut = new BufferedOutputStream(audioOutputStream, BufferSize);
                        demuxer.setAudioOut(audioOut);
                    }
                    int i = 0;
                    while (true) {
                        if (i >= demuxer.infiles.size()) {
                            demuxer.closeOutputStreams();
                            return;
                        }
                        System.out.println(demuxer.infiles.get(i) + "\n");
                        demuxer.demuxFile((String)demuxer.infiles.get(i), demuxer, null);
                        ++i;
                    }
                }
                case 3: {
                    if (!demuxer.parseArg(args[0], 'i', demuxer.infiles)) {
                        demuxer.printUsage();
                        return;
                    }
                    if (demuxer.parseArg(args[1], 'v', outfilesVideo)) {
                        if (!demuxer.parseArg(args[2], 'a', outfilesAudio)) {
                            demuxer.printUsage();
                            return;
                        }
                        File videoFile = new File((String)outfilesVideo.get(0));
                        FileOutputStream videoOutputStream = new FileOutputStream(videoFile);
                        BufferedOutputStream videoOut = new BufferedOutputStream(videoOutputStream, BufferSize);
                        demuxer.setVideoOut(videoOut);
                        File audioFile = new File((String)outfilesAudio.get(0));
                        FileOutputStream audioOutputStream = new FileOutputStream(audioFile);
                        BufferedOutputStream audioOut = new BufferedOutputStream(audioOutputStream, BufferSize);
                        demuxer.setAudioOut(audioOut);
                    }
                    int i = 0;
                    while (i < demuxer.infiles.size()) {
                        System.out.println(demuxer.infiles.get(i) + "\n");
                        demuxer.demuxFile((String)demuxer.infiles.get(i), demuxer, null);
                        System.out.println("processed " + demuxer.packetCounter + " packets\n");
                        System.out.println("Video/Audio delay (ms):" + demuxer.videoAudioDelay());
                        ++i;
                    }
                    return;
                }
            }
            demuxer.printUsage();
            return;
        }
        catch (IOException e) {
            System.out.println("Exception:" + e);
        }
    }
}

