/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jaudiotagger.audio.generic.AbstractTag;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.datatype.Artwork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericTag
extends AbstractTag {
    private static EnumSet<FieldKey> supportedKeys = EnumSet.of(FieldKey.ALBUM, new FieldKey[]{FieldKey.ARTIST, FieldKey.TITLE, FieldKey.TRACK, FieldKey.GENRE, FieldKey.COMMENT, FieldKey.YEAR});

    @Override
    protected boolean isAllowedEncoding(String enc) {
        return true;
    }

    @Override
    public TagField createField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (supportedKeys.contains((Object)genericKey)) {
            return new GenericTagTextField(genericKey.name(), value);
        }
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    @Override
    public String getFirst(FieldKey genericKey) throws KeyNotFoundException {
        if (supportedKeys.contains((Object)genericKey)) {
            return this.getFirst(genericKey.name());
        }
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    @Override
    public void deleteField(FieldKey genericKey) throws KeyNotFoundException {
        if (!supportedKeys.contains((Object)genericKey)) {
            throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
        }
        this.deleteField(genericKey.name());
    }

    @Override
    public TagField getFirstField(FieldKey genericKey) throws KeyNotFoundException {
        if (supportedKeys.contains((Object)genericKey)) {
            return this.getFirstField(genericKey.name());
        }
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    @Override
    public List<Artwork> getArtworkList() {
        return Collections.emptyList();
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    private class GenericTagTextField
    implements TagTextField {
        private String content;
        private final String id;

        public GenericTagTextField(String fieldId, String initialContent) {
            this.id = fieldId;
            this.content = initialContent;
        }

        public void copyContent(TagField field) {
            if (field instanceof TagTextField) {
                this.content = ((TagTextField)field).getContent();
            }
        }

        public String getContent() {
            return this.content;
        }

        public String getEncoding() {
            return "ISO-8859-1";
        }

        public String getId() {
            return this.id;
        }

        public byte[] getRawContent() {
            return this.content == null ? new byte[]{} : Utils.getDefaultBytes(this.content, this.getEncoding());
        }

        public boolean isBinary() {
            return false;
        }

        public void isBinary(boolean b) {
        }

        public boolean isCommon() {
            return true;
        }

        public boolean isEmpty() {
            return this.content.equals("");
        }

        public void setContent(String s) {
            this.content = s;
        }

        public void setEncoding(String s) {
        }

        public String toString() {
            return this.getContent();
        }
    }
}

