/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.logging.Level;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.exceptions.UnableToCreateFileException;
import org.jaudiotagger.audio.exceptions.UnableToModifyFileException;
import org.jaudiotagger.audio.exceptions.UnableToRenameFileException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.logging.FileSystemMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.datatype.Artwork;
import org.jaudiotagger.tag.id3.AbstractID3Tag;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3Frames;
import org.jaudiotagger.tag.id3.ID3SyncSafeInteger;
import org.jaudiotagger.tag.id3.ID3v22Frames;
import org.jaudiotagger.tag.id3.ID3v23Frames;
import org.jaudiotagger.tag.id3.ID3v24Frames;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyUrlLink;
import org.jaudiotagger.tag.id3.framebody.FrameBodyAPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPIC;
import org.jaudiotagger.tag.id3.framebody.FrameBodyPOPM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPOS;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTRCK;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTXXX;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUFID;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUSLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUnsupported;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWOAR;
import org.jaudiotagger.tag.id3.framebody.FrameBodyWXXX;
import org.jaudiotagger.tag.reference.PictureTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractID3v2Tag
extends AbstractID3Tag
implements Tag {
    protected static final String TYPE_HEADER = "header";
    protected static final String TYPE_BODY = "body";
    protected static final byte[] TAG_ID = new byte[]{73, 68, 51};
    public static final int TAG_HEADER_LENGTH = 10;
    protected static final int FIELD_TAGID_LENGTH = 3;
    protected static final int FIELD_TAG_MAJOR_VERSION_LENGTH = 1;
    protected static final int FIELD_TAG_MINOR_VERSION_LENGTH = 1;
    protected static final int FIELD_TAG_FLAG_LENGTH = 1;
    protected static final int FIELD_TAG_SIZE_LENGTH = 4;
    protected static final int FIELD_TAGID_POS = 0;
    protected static final int FIELD_TAG_MAJOR_VERSION_POS = 3;
    protected static final int FIELD_TAG_MINOR_VERSION_POS = 4;
    protected static final int FIELD_TAG_FLAG_POS = 5;
    protected static final int FIELD_TAG_SIZE_POS = 6;
    protected static final int TAG_SIZE_INCREMENT = 100;
    private static final long MAXIMUM_WRITABLE_CHUNK_SIZE = 10000000L;
    public HashMap frameMap = null;
    protected static final String TYPE_DUPLICATEFRAMEID = "duplicateFrameId";
    protected String duplicateFrameId = "";
    protected static final String TYPE_DUPLICATEBYTES = "duplicateBytes";
    protected int duplicateBytes = 0;
    protected static final String TYPE_EMPTYFRAMEBYTES = "emptyFrameBytes";
    protected int emptyFrameBytes = 0;
    protected static final String TYPE_FILEREADSIZE = "fileReadSize";
    protected int fileReadSize = 0;
    protected static final String TYPE_INVALIDFRAMEBYTES = "invalidFrameBytes";
    protected int invalidFrameBytes = 0;

    public AbstractID3v2Tag() {
    }

    protected AbstractID3v2Tag(AbstractID3v2Tag copyObject) {
    }

    protected void copyPrimitives(AbstractID3v2Tag copyObject) {
        logger.info("Copying Primitives");
        this.duplicateFrameId = copyObject.duplicateFrameId;
        this.duplicateBytes = copyObject.duplicateBytes;
        this.emptyFrameBytes = copyObject.emptyFrameBytes;
        this.fileReadSize = copyObject.fileReadSize;
        this.invalidFrameBytes = copyObject.invalidFrameBytes;
    }

    protected void copyFrames(AbstractID3v2Tag copyObject) {
        this.frameMap = new LinkedHashMap();
        for (Object o1 : copyObject.frameMap.keySet()) {
            String id = (String)o1;
            Object o = copyObject.frameMap.get(id);
            if (o instanceof AbstractID3v2Frame) {
                this.addFrame((AbstractID3v2Frame)o);
                continue;
            }
            if (!(o instanceof ArrayList)) continue;
            ListIterator li = ((ArrayList)o).listIterator();
            while (li.hasNext()) {
                this.addFrame((AbstractID3v2Frame)li.next());
            }
        }
    }

    protected abstract void addFrame(AbstractID3v2Frame var1);

    public int getDuplicateBytes() {
        return this.duplicateBytes;
    }

    public String getDuplicateFrameId() {
        return this.duplicateFrameId;
    }

    public int getEmptyFrameBytes() {
        return this.emptyFrameBytes;
    }

    public int getInvalidFrameBytes() {
        return this.invalidFrameBytes;
    }

    public int getFileReadBytes() {
        return this.fileReadSize;
    }

    public boolean hasFrame(String identifier) {
        return this.frameMap.containsKey(identifier);
    }

    public boolean hasFrameAndBody(String identifier) {
        if (this.hasFrame(identifier)) {
            Object o = this.getFrame(identifier);
            if (o instanceof AbstractID3v2Frame) {
                return !(((AbstractID3v2Frame)o).getBody() instanceof FrameBodyUnsupported);
            }
            return true;
        }
        return false;
    }

    public boolean hasFrameOfType(String identifier) {
        Iterator iterator = this.frameMap.keySet().iterator();
        boolean found = false;
        while (iterator.hasNext() && !found) {
            String key = (String)iterator.next();
            if (!key.startsWith(identifier)) continue;
            found = true;
        }
        return found;
    }

    public Object getFrame(String identifier) {
        return this.frameMap.get(identifier);
    }

    @Override
    public String getFirst(String identifier) {
        AbstractID3v2Frame frame = this.getFirstField(identifier);
        if (frame == null) {
            return "";
        }
        if (frame.getBody() instanceof FrameBodyCOMM) {
            return ((FrameBodyCOMM)frame.getBody()).getText();
        }
        if (frame.getBody() instanceof FrameBodyUSLT) {
            return ((FrameBodyUSLT)frame.getBody()).getFirstTextValue();
        }
        if (frame.getBody() instanceof AbstractFrameBodyTextInfo) {
            return ((AbstractFrameBodyTextInfo)frame.getBody()).getFirstTextValue();
        }
        if (frame.getBody() instanceof AbstractFrameBodyUrlLink) {
            return ((AbstractFrameBodyUrlLink)frame.getBody()).getUrlLink();
        }
        if (frame.getBody() instanceof FrameBodyTRCK) {
            return String.valueOf(((FrameBodyTRCK)frame.getBody()).getTrackNo());
        }
        if (frame.getBody() instanceof FrameBodyTPOS) {
            return String.valueOf(((FrameBodyTPOS)frame.getBody()).getDiscNo());
        }
        return frame.getBody().toString();
    }

    @Override
    public TagField getFirstField(FieldKey genericKey) throws KeyNotFoundException {
        List<TagField> fields = this.getFields(genericKey);
        if (fields.size() > 0) {
            return fields.get(0);
        }
        return null;
    }

    @Override
    public AbstractID3v2Frame getFirstField(String identifier) {
        Object object = this.getFrame(identifier);
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            return (AbstractID3v2Frame)((List)object).get(0);
        }
        return (AbstractID3v2Frame)object;
    }

    public void setFrame(AbstractID3v2Frame frame) {
        this.frameMap.put(frame.getIdentifier(), frame);
    }

    protected abstract ID3Frames getID3Frames();

    @Override
    public void setField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, value);
        this.setField(tagfield);
    }

    @Override
    public void addField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, value);
        this.addField(tagfield);
    }

    public void mergeDuplicateFrames(AbstractID3v2Frame newFrame, List<AbstractID3v2Frame> frames) {
        ListIterator<AbstractID3v2Frame> li = frames.listIterator();
        while (li.hasNext()) {
            AbstractID3v2Frame nextFrame = li.next();
            if (newFrame.getBody() instanceof FrameBodyTXXX) {
                if (!((FrameBodyTXXX)newFrame.getBody()).getDescription().equals(((FrameBodyTXXX)nextFrame.getBody()).getDescription())) continue;
                li.set(newFrame);
                this.frameMap.put(newFrame.getId(), frames);
                return;
            }
            if (newFrame.getBody() instanceof FrameBodyWXXX) {
                if (!((FrameBodyWXXX)newFrame.getBody()).getDescription().equals(((FrameBodyWXXX)nextFrame.getBody()).getDescription())) continue;
                li.set(newFrame);
                this.frameMap.put(newFrame.getId(), frames);
                return;
            }
            if (newFrame.getBody() instanceof FrameBodyCOMM) {
                if (!((FrameBodyCOMM)newFrame.getBody()).getDescription().equals(((FrameBodyCOMM)nextFrame.getBody()).getDescription())) continue;
                li.set(newFrame);
                this.frameMap.put(newFrame.getId(), frames);
                return;
            }
            if (newFrame.getBody() instanceof FrameBodyUFID) {
                if (!((FrameBodyUFID)newFrame.getBody()).getOwner().equals(((FrameBodyUFID)nextFrame.getBody()).getOwner())) continue;
                li.set(newFrame);
                this.frameMap.put(newFrame.getId(), frames);
                return;
            }
            if (newFrame.getBody() instanceof FrameBodyUSLT) {
                if (!((FrameBodyUSLT)newFrame.getBody()).getDescription().equals(((FrameBodyUSLT)nextFrame.getBody()).getDescription())) continue;
                li.set(newFrame);
                this.frameMap.put(newFrame.getId(), frames);
                return;
            }
            if (newFrame.getBody() instanceof FrameBodyPOPM) {
                if (!((FrameBodyPOPM)newFrame.getBody()).getEmailToUser().equals(((FrameBodyPOPM)nextFrame.getBody()).getEmailToUser())) continue;
                li.set(newFrame);
                this.frameMap.put(newFrame.getId(), frames);
                return;
            }
            if (newFrame.getBody() instanceof FrameBodyTRCK) {
                FrameBodyTRCK newBody = (FrameBodyTRCK)newFrame.getBody();
                FrameBodyTRCK oldBody = (FrameBodyTRCK)nextFrame.getBody();
                if (newBody.getTrackNo() != null && newBody.getTrackNo() > 0) {
                    oldBody.setTrackNo(newBody.getTrackNo());
                }
                if (newBody.getTrackTotal() != null && newBody.getTrackTotal() > 0) {
                    oldBody.setTrackTotal(newBody.getTrackTotal());
                }
                return;
            }
            if (!(newFrame.getBody() instanceof FrameBodyTPOS)) continue;
            FrameBodyTPOS newBody = (FrameBodyTPOS)newFrame.getBody();
            FrameBodyTPOS oldBody = (FrameBodyTPOS)nextFrame.getBody();
            if (newBody.getDiscNo() > 0) {
                oldBody.setDiscNo(newBody.getDiscNo());
            }
            if (newBody.getDiscTotal() > 0) {
                oldBody.setDiscTotal(newBody.getDiscTotal());
            }
            return;
        }
        frames.add(newFrame);
        this.frameMap.put(newFrame.getId(), frames);
    }

    @Override
    public void setField(TagField field) throws FieldDataInvalidException {
        if (!(field instanceof AbstractID3v2Frame)) {
            throw new FieldDataInvalidException("Field " + field + " is not of type AbstractID3v2Frame");
        }
        AbstractID3v2Frame newFrame = (AbstractID3v2Frame)field;
        Object obj = this.frameMap.get(field.getId());
        if (obj == null || !this.getID3Frames().isMultipleAllowed(newFrame.getId())) {
            this.frameMap.put(field.getId(), field);
        } else if (obj instanceof AbstractID3v2Frame) {
            ArrayList<AbstractID3v2Frame> frames = new ArrayList<AbstractID3v2Frame>();
            frames.add((AbstractID3v2Frame)obj);
            this.mergeDuplicateFrames(newFrame, frames);
        } else if (obj instanceof List) {
            this.mergeDuplicateFrames(newFrame, (List)obj);
        }
    }

    @Override
    public void addField(TagField field) throws FieldDataInvalidException {
        if (field == null) {
            return;
        }
        if (!(field instanceof AbstractID3v2Frame)) {
            throw new FieldDataInvalidException("Field " + field + " is not of type AbstractID3v2Frame");
        }
        Object o = this.frameMap.get(field.getId());
        if (o instanceof List) {
            List list = (List)o;
            list.add(field);
        } else if (o == null) {
            this.frameMap.put(field.getId(), field);
        } else {
            ArrayList<TagField> list = new ArrayList<TagField>();
            list.add((TagField)o);
            list.add(field);
            this.frameMap.put(field.getId(), list);
        }
    }

    public void setFrame(String identifier, List<AbstractID3v2Frame> multiFrame) {
        logger.finest("Adding " + multiFrame.size() + " frames for " + identifier);
        this.frameMap.put(identifier, multiFrame);
    }

    public int getFrameCount() {
        if (this.frameMap == null) {
            return 0;
        }
        return this.frameMap.size();
    }

    public Iterator getFrameOfType(String identifier) {
        Iterator iterator = this.frameMap.keySet().iterator();
        HashSet result = new HashSet();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!key.startsWith(identifier)) continue;
            result.add(this.frameMap.get(key));
        }
        return result.iterator();
    }

    @Override
    public void delete(RandomAccessFile file) throws IOException {
        byte[] buffer = new byte[3];
        FileChannel fc = file.getChannel();
        fc.position();
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        fc.read(byteBuffer, 0L);
        byteBuffer.flip();
        if (this.seek(byteBuffer)) {
            file.seek(0L);
            file.write(buffer);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractID3v2Tag)) {
            return false;
        }
        AbstractID3v2Tag object = (AbstractID3v2Tag)obj;
        return this.frameMap.equals(object.frameMap) && super.equals(obj);
    }

    @Override
    public Iterator iterator() {
        return this.frameMap.values().iterator();
    }

    public void removeFrame(String identifier) {
        logger.finest("Removing frame with identifier:" + identifier);
        this.frameMap.remove(identifier);
    }

    public void removeUnsupportedFrames() {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof AbstractID3v2Frame) || !(((AbstractID3v2Frame)o).getBody() instanceof FrameBodyUnsupported)) continue;
            logger.finest("Removing frame" + ((AbstractID3v2Frame)o).getIdentifier());
            i.remove();
        }
    }

    public void removeFrameOfType(String identifier) {
        HashSet<String> result = new HashSet<String>();
        for (Object k : this.frameMap.keySet()) {
            String key = (String)k;
            if (!key.startsWith(identifier)) continue;
            result.add(key);
        }
        for (String string : result) {
            logger.finest("Removing frame with identifier:" + string + "because starts with:" + identifier);
            this.frameMap.remove(string);
        }
    }

    public void write(File file, long audioStartByte) throws IOException {
    }

    protected FileLock getFileLockForWriting(FileChannel fileChannel, String filePath) throws IOException {
        FileLock fileLock;
        logger.finest("locking fileChannel for " + filePath);
        try {
            fileLock = fileChannel.tryLock();
        }
        catch (IOException exception) {
            return null;
        }
        if (fileLock == null) {
            throw new IOException(ErrorMessage.GENERAL_WRITE_FAILED_FILE_LOCKED.getMsg(filePath));
        }
        return fileLock;
    }

    @Override
    public void write(RandomAccessFile file) throws IOException {
    }

    public void write(WritableByteChannel channel) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getV2TagSizeIfExists(File file) throws IOException {
        ByteBuffer bb;
        FileInputStream fis;
        block11: {
            FileChannel fc;
            block9: {
                long l;
                block10: {
                    fis = null;
                    fc = null;
                    bb = null;
                    try {
                        fis = new FileInputStream(file);
                        fc = fis.getChannel();
                        bb = ByteBuffer.allocate(10);
                        fc.read(bb);
                        bb.flip();
                        if (bb.limit() >= 10) break block9;
                        l = 0L;
                        Object var7_6 = null;
                        if (fc == null) break block10;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        if (fc != null) {
                            fc.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                        throw throwable;
                    }
                    fc.close();
                }
                if (fis != null) {
                    fis.close();
                }
                return l;
            }
            Object var7_7 = null;
            if (fc == null) break block11;
            fc.close();
        }
        if (fis != null) {
            fis.close();
        }
        byte[] tagIdentifier = new byte[3];
        bb.get(tagIdentifier, 0, 3);
        if (!Arrays.equals(tagIdentifier, TAG_ID)) {
            return 0L;
        }
        byte majorVersion = bb.get();
        if (majorVersion != 2 && majorVersion != 3 && majorVersion != 4) {
            return 0L;
        }
        bb.get();
        bb.get();
        int frameSize = ID3SyncSafeInteger.bufferToValue(bb);
        return frameSize += 10;
    }

    @Override
    public boolean seek(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        logger.info("ByteBuffer pos:" + byteBuffer.position() + ":limit" + byteBuffer.limit() + ":cap" + byteBuffer.capacity());
        byte[] tagIdentifier = new byte[3];
        byteBuffer.get(tagIdentifier, 0, 3);
        if (!Arrays.equals(tagIdentifier, TAG_ID)) {
            return false;
        }
        if (byteBuffer.get() != this.getMajorVersion()) {
            return false;
        }
        return byteBuffer.get() == this.getRevision();
    }

    protected int calculateTagSize(int tagSize, int audioStart) {
        if (tagSize <= audioStart) {
            return audioStart;
        }
        return tagSize + 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustPadding(File file, int paddingSize, long audioStart) throws FileNotFoundException, IOException {
        FileChannel fcOut;
        File paddedFile;
        logger.finer("Need to move audio file to accomodate tag");
        FileChannel fcIn = null;
        ByteBuffer paddingBuffer = ByteBuffer.wrap(new byte[paddingSize]);
        try {
            paddedFile = File.createTempFile(Utils.getMinBaseFilenameAllowedForTempFile(file), ".new", file.getParentFile());
            logger.finest("Created temp file:" + paddedFile.getName() + " for " + file.getName());
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, ioe.getMessage(), ioe);
            if (ioe.getMessage().equals(FileSystemMessage.ACCESS_IS_DENIED.getMsg())) {
                logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(file.getName(), file.getParentFile().getPath()));
                throw new UnableToCreateFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(file.getName(), file.getParentFile().getPath()));
            }
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(file.getName(), file.getParentFile().getPath()));
            throw new UnableToCreateFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_CREATE_TEMPORARY_FILE_IN_FOLDER.getMsg(file.getName(), file.getParentFile().getPath()));
        }
        try {
            fcOut = new FileOutputStream(paddedFile).getChannel();
        }
        catch (FileNotFoundException ioe) {
            logger.log(Level.SEVERE, ioe.getMessage(), ioe);
            logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_TO_MODIFY_TEMPORARY_FILE_IN_FOLDER.getMsg(file.getName(), file.getParentFile().getPath()));
            throw new UnableToModifyFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_MODIFY_TEMPORARY_FILE_IN_FOLDER.getMsg(file.getName(), file.getParentFile().getPath()));
        }
        try {
            fcIn = new FileInputStream(file).getChannel();
            long written = fcOut.write(paddingBuffer);
            logger.finer("Copying:" + (file.length() - audioStart) + "bytes");
            long audiolength = file.length() - audioStart;
            if (audiolength <= 10000000L) {
                long written2 = fcIn.transferTo(audioStart, audiolength, fcOut);
                logger.finer("Written padding:" + written + " Data:" + written2);
                if (written2 != audiolength) {
                    throw new RuntimeException(ErrorMessage.MP3_UNABLE_TO_ADJUST_PADDING.getMsg(audiolength, written2));
                }
            } else {
                long noOfChunks = audiolength / 10000000L;
                long lastChunkSize = audiolength % 10000000L;
                long written2 = 0L;
                int i = 0;
                while ((long)i < noOfChunks) {
                    written2 += fcIn.transferTo(audioStart + (long)i * 10000000L, 10000000L, fcOut);
                    Runtime.getRuntime().gc();
                    ++i;
                }
                logger.finer("Written padding:" + written + " Data:" + (written2 += fcIn.transferTo(audioStart + noOfChunks * 10000000L, lastChunkSize, fcOut)));
                if (written2 != audiolength) {
                    throw new RuntimeException(ErrorMessage.MP3_UNABLE_TO_ADJUST_PADDING.getMsg(audiolength, written2));
                }
            }
            long lastModified = file.lastModified();
            if (fcIn != null && fcIn.isOpen()) {
                fcIn.close();
            }
            if (fcOut != null && fcOut.isOpen()) {
                fcOut.close();
            }
            this.replaceFile(file, paddedFile);
            paddedFile.setLastModified(lastModified);
            Object var21_16 = null;
        }
        catch (Throwable throwable) {
            Object var21_17 = null;
            try {
                if (fcIn != null && fcIn.isOpen()) {
                    fcIn.close();
                }
                if (fcOut != null && fcOut.isOpen()) {
                    fcOut.close();
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Problem closing channels and locks:" + e.getMessage(), e);
            }
            throw throwable;
        }
        try {
            if (fcIn != null && fcIn.isOpen()) {
                fcIn.close();
            }
            if (fcOut != null && fcOut.isOpen()) {
                fcOut.close();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Problem closing channels and locks:" + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeBufferToFile(File file, ByteBuffer headerBuffer, byte[] bodyByteBuffer, int padding, int sizeIncPadding, long audioStartLocation) throws IOException {
        FileChannel fc;
        block10: {
            fc = null;
            FileLock fileLock = null;
            if ((long)sizeIncPadding > audioStartLocation) {
                logger.finest("Adjusting Padding");
                this.adjustPadding(file, sizeIncPadding, audioStartLocation);
            }
            try {
                try {
                    fc = new RandomAccessFile(file, "rws").getChannel();
                    fileLock = this.getFileLockForWriting(fc, file.getPath());
                    fc.write(headerBuffer);
                    fc.write(ByteBuffer.wrap(bodyByteBuffer));
                    fc.write(ByteBuffer.wrap(new byte[padding]));
                }
                catch (FileNotFoundException fe) {
                    logger.log(Level.SEVERE, this.getLoggingFilename() + fe.getMessage(), fe);
                    if (fe.getMessage().equals(FileSystemMessage.ACCESS_IS_DENIED.getMsg())) {
                        logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getPath()));
                        throw new UnableToModifyFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getPath()));
                    }
                    logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getPath()));
                    throw new UnableToCreateFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getPath()));
                }
                catch (IOException ioe) {
                    logger.log(Level.SEVERE, this.getLoggingFilename() + ioe.getMessage(), ioe);
                    if (ioe.getMessage().equals(FileSystemMessage.ACCESS_IS_DENIED.getMsg())) {
                        logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getParentFile().getPath()));
                        throw new UnableToModifyFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getParentFile().getPath()));
                    }
                    logger.severe(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getParentFile().getPath()));
                    throw new UnableToCreateFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_OPEN_FILE_FOR_EDITING.getMsg(file.getParentFile().getPath()));
                }
                Object var12_9 = null;
                if (fc == null) return;
                if (fileLock == null) break block10;
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                if (fc == null) throw throwable;
                if (fileLock != null) {
                    fileLock.release();
                }
                fc.close();
                throw throwable;
            }
            fileLock.release();
        }
        fc.close();
    }

    private void replaceFile(File originalFile, File newFile) throws IOException {
        File originalFileBackup = new File(originalFile.getAbsoluteFile().getParentFile().getPath(), AudioFile.getBaseFilename(originalFile) + ".old");
        int count = 1;
        while (originalFileBackup.exists()) {
            originalFileBackup = new File(originalFile.getAbsoluteFile().getParentFile().getPath(), AudioFile.getBaseFilename(originalFile) + ".old" + count);
            ++count;
        }
        boolean renameOriginalResult = originalFile.renameTo(originalFileBackup);
        if (!renameOriginalResult) {
            logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_ORIGINAL_FILE_TO_BACKUP.getMsg(originalFile.getAbsolutePath(), originalFileBackup.getName()));
            throw new UnableToRenameFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_ORIGINAL_FILE_TO_BACKUP.getMsg(originalFile.getAbsolutePath(), originalFileBackup.getName()));
        }
        boolean renameResult = newFile.renameTo(originalFile);
        if (!renameResult) {
            if (!newFile.exists()) {
                logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_NEW_FILE_DOESNT_EXIST.getMsg(newFile.getAbsolutePath()));
            }
            if (!(renameOriginalResult = originalFileBackup.renameTo(originalFile))) {
                logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_ORIGINAL_BACKUP_TO_ORIGINAL.getMsg(originalFileBackup.getAbsolutePath(), originalFile.getName()));
            }
            logger.warning(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(originalFile.getAbsolutePath(), newFile.getName()));
            throw new UnableToRenameFileException(ErrorMessage.GENERAL_WRITE_FAILED_TO_RENAME_TO_ORIGINAL_FILE.getMsg(originalFile.getAbsolutePath(), newFile.getName()));
        }
        boolean deleteResult = originalFileBackup.delete();
        if (!deleteResult) {
            logger.warning(ErrorMessage.GENERAL_WRITE_WARNING_UNABLE_TO_DELETE_BACKUP_FILE.getMsg(originalFileBackup.getAbsolutePath()));
        }
    }

    protected void copyFrameIntoMap(String id, AbstractID3v2Frame newFrame) {
        if (this.frameMap.containsKey(newFrame.getIdentifier())) {
            Object o = this.frameMap.get(newFrame.getIdentifier());
            if (o instanceof AbstractID3v2Frame) {
                ArrayList<AbstractID3v2Frame> list = new ArrayList<AbstractID3v2Frame>();
                list.add((AbstractID3v2Frame)o);
                list.add(newFrame);
                this.frameMap.put(newFrame.getIdentifier(), list);
            } else {
                List list = (List)o;
                list.add(newFrame);
            }
        } else {
            this.frameMap.put(newFrame.getIdentifier(), newFrame);
        }
    }

    protected void loadFrameIntoMap(String frameId, AbstractID3v2Frame next) {
        if (ID3v24Frames.getInstanceOf().isMultipleAllowed(frameId) || ID3v23Frames.getInstanceOf().isMultipleAllowed(frameId) || ID3v22Frames.getInstanceOf().isMultipleAllowed(frameId)) {
            if (this.frameMap.containsKey(frameId)) {
                Object o = this.frameMap.get(frameId);
                if (o instanceof ArrayList) {
                    ArrayList multiValues = (ArrayList)o;
                    multiValues.add(next);
                    logger.finer("Adding Multi Frame(1)" + frameId);
                } else {
                    ArrayList<AbstractID3v2Frame> multiValues = new ArrayList<AbstractID3v2Frame>();
                    multiValues.add((AbstractID3v2Frame)o);
                    multiValues.add(next);
                    this.frameMap.put(frameId, multiValues);
                    logger.finer("Adding Multi Frame(2)" + frameId);
                }
            } else {
                logger.finer("Adding Multi FrameList(3)" + frameId);
                this.frameMap.put(frameId, next);
            }
        } else if (this.frameMap.containsKey(frameId)) {
            logger.warning("Duplicate Frame" + frameId);
            this.duplicateFrameId = this.duplicateFrameId + frameId + "; ";
            this.duplicateBytes += ((AbstractID3v2Frame)this.frameMap.get(frameId)).getSize();
        } else {
            logger.finer("Adding Frame" + frameId);
            this.frameMap.put(frameId, next);
        }
    }

    @Override
    public int getSize() {
        int size = 0;
        for (Object o : this.frameMap.values()) {
            AbstractID3v2Frame frame;
            if (o instanceof AbstractID3v2Frame) {
                frame = (AbstractID3v2Frame)o;
                size += frame.getSize();
                continue;
            }
            ArrayList multiFrames = (ArrayList)o;
            ListIterator li = multiFrames.listIterator();
            while (li.hasNext()) {
                frame = (AbstractID3v2Frame)li.next();
                size += frame.getSize();
            }
        }
        return size;
    }

    protected ByteArrayOutputStream writeFramesToBuffer() throws IOException {
        ByteArrayOutputStream bodyBuffer = new ByteArrayOutputStream();
        TreeSet sortedWriteOrder = new TreeSet(this.getPreferredFrameOrderComparator());
        sortedWriteOrder.addAll(this.frameMap.keySet());
        for (String id : sortedWriteOrder) {
            AbstractID3v2Frame frame;
            Object o = this.frameMap.get(id);
            if (o instanceof AbstractID3v2Frame) {
                frame = (AbstractID3v2Frame)o;
                frame.write(bodyBuffer);
                continue;
            }
            ArrayList multiFrames = (ArrayList)o;
            ListIterator li = multiFrames.listIterator();
            while (li.hasNext()) {
                frame = (AbstractID3v2Frame)li.next();
                frame.write(bodyBuffer);
            }
        }
        return bodyBuffer;
    }

    public abstract Comparator getPreferredFrameOrderComparator();

    public void createStructure() {
        this.createStructureHeader();
        this.createStructureBody();
    }

    public void createStructureHeader() {
        MP3File.getStructureFormatter().addElement(TYPE_DUPLICATEBYTES, this.duplicateBytes);
        MP3File.getStructureFormatter().addElement(TYPE_DUPLICATEFRAMEID, this.duplicateFrameId);
        MP3File.getStructureFormatter().addElement(TYPE_EMPTYFRAMEBYTES, this.emptyFrameBytes);
        MP3File.getStructureFormatter().addElement(TYPE_FILEREADSIZE, this.fileReadSize);
        MP3File.getStructureFormatter().addElement(TYPE_INVALIDFRAMEBYTES, this.invalidFrameBytes);
    }

    public void createStructureBody() {
        MP3File.getStructureFormatter().openHeadingElement(TYPE_BODY, "");
        for (Object o : this.frameMap.values()) {
            AbstractID3v2Frame frame;
            if (o instanceof AbstractID3v2Frame) {
                frame = (AbstractID3v2Frame)o;
                frame.createStructure();
                continue;
            }
            ArrayList multiFrames = (ArrayList)o;
            ListIterator li = multiFrames.listIterator();
            while (li.hasNext()) {
                frame = (AbstractID3v2Frame)li.next();
                frame.createStructure();
            }
        }
        MP3File.getStructureFormatter().closeHeadingElement(TYPE_BODY);
    }

    @Override
    public List<TagField> get(String id) throws KeyNotFoundException {
        Object o = this.getFrame(id);
        if (o == null) {
            return new ArrayList<TagField>();
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof AbstractID3v2Frame) {
            ArrayList<TagField> list = new ArrayList<TagField>();
            list.add((TagField)o);
            return list;
        }
        throw new RuntimeException("Found entry in frameMap that was not a frame or a list:" + o);
    }

    public abstract AbstractID3v2Frame createFrame(String var1);

    @Override
    public boolean hasCommonFields() {
        return true;
    }

    @Override
    public boolean hasField(String id) {
        return this.get(id).size() != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.frameMap.size() == 0;
    }

    @Override
    public Iterator<TagField> getFields() {
        final Iterator it = this.frameMap.entrySet().iterator();
        final Iterator itHasNext = this.frameMap.entrySet().iterator();
        return new Iterator<TagField>(){
            Map.Entry<String, Object> latestEntry = null;
            private Iterator<TagField> fieldsIt;

            private void changeIt() {
                if (!it.hasNext()) {
                    return;
                }
                while (it.hasNext()) {
                    ArrayList<TagField> l;
                    Map.Entry e = (Map.Entry)it.next();
                    this.latestEntry = (Map.Entry)itHasNext.next();
                    if (e.getValue() instanceof List) {
                        l = (ArrayList<TagField>)e.getValue();
                        if (l.size() == 0) continue;
                        this.fieldsIt = l.iterator();
                        break;
                    }
                    l = new ArrayList<TagField>();
                    l.add((TagField)e.getValue());
                    this.fieldsIt = l.iterator();
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.fieldsIt != null && this.fieldsIt.hasNext()) {
                    return true;
                }
                if (!itHasNext.hasNext()) {
                    return false;
                }
                return itHasNext.hasNext();
            }

            @Override
            public TagField next() {
                if (this.fieldsIt == null) {
                    this.changeIt();
                }
                if (this.fieldsIt != null && !this.fieldsIt.hasNext()) {
                    this.changeIt();
                }
                if (this.fieldsIt == null) {
                    throw new NoSuchElementException();
                }
                return this.fieldsIt.next();
            }

            @Override
            public void remove() {
                this.fieldsIt.remove();
            }
        };
    }

    @Override
    public int getFieldCount() {
        Iterator<TagField> it = this.getFields();
        int count = 0;
        try {
            while (true) {
                it.next();
                ++count;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            return count;
        }
    }

    @Override
    public boolean setEncoding(String enc) throws FieldDataInvalidException {
        throw new UnsupportedOperationException("Not Implemented Yet");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getFirst(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        FrameAndSubId frameAndSubId = this.getFrameAndSubIdFromGenericKey(genericKey);
        if (genericKey != FieldKey.TRACK && genericKey != FieldKey.TRACK_TOTAL && genericKey != FieldKey.DISC_NO && genericKey != FieldKey.DISC_TOTAL) return this.doGetFirst(frameAndSubId);
        AbstractID3v2Frame frame = this.getFirstField(frameAndSubId.getFrameId());
        if (frame == null) return "";
        if (genericKey == FieldKey.TRACK) {
            return String.valueOf(((FrameBodyTRCK)frame.getBody()).getTrackNo());
        }
        if (genericKey == FieldKey.TRACK_TOTAL) {
            return String.valueOf(((FrameBodyTRCK)frame.getBody()).getTrackTotal());
        }
        if (genericKey == FieldKey.DISC_NO) {
            return String.valueOf(((FrameBodyTPOS)frame.getBody()).getDiscNo());
        }
        if (genericKey != FieldKey.DISC_TOTAL) return "";
        return String.valueOf(((FrameBodyTPOS)frame.getBody()).getDiscTotal());
    }

    @Override
    public TagField createField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        FrameAndSubId formatKey = this.getFrameAndSubIdFromGenericKey(genericKey);
        if (genericKey == FieldKey.TRACK) {
            AbstractID3v2Frame frame = this.createFrame(formatKey.getFrameId());
            FrameBodyTRCK framebody = (FrameBodyTRCK)frame.getBody();
            framebody.setTrackNo(Integer.parseInt(value));
            return frame;
        }
        if (genericKey == FieldKey.TRACK_TOTAL) {
            AbstractID3v2Frame frame = this.createFrame(formatKey.getFrameId());
            FrameBodyTRCK framebody = (FrameBodyTRCK)frame.getBody();
            framebody.setTrackTotal(Integer.parseInt(value));
            return frame;
        }
        if (genericKey == FieldKey.DISC_NO) {
            AbstractID3v2Frame frame = this.createFrame(formatKey.getFrameId());
            FrameBodyTPOS framebody = (FrameBodyTPOS)frame.getBody();
            framebody.setDiscNo(Integer.parseInt(value));
            return frame;
        }
        if (genericKey == FieldKey.DISC_TOTAL) {
            AbstractID3v2Frame frame = this.createFrame(formatKey.getFrameId());
            FrameBodyTPOS framebody = (FrameBodyTPOS)frame.getBody();
            framebody.setDiscTotal(Integer.parseInt(value));
            return frame;
        }
        return this.doCreateTagField(formatKey, value);
    }

    protected TagField doCreateTagField(FrameAndSubId formatKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        AbstractID3v2Frame frame = this.createFrame(formatKey.getFrameId());
        if (frame.getBody() instanceof FrameBodyUFID) {
            ((FrameBodyUFID)frame.getBody()).setOwner(formatKey.getSubId());
            try {
                ((FrameBodyUFID)frame.getBody()).setUniqueIdentifier(value.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("When encoding UFID charset ISO-8859-1 was deemed unsupported");
            }
        } else if (frame.getBody() instanceof FrameBodyTXXX) {
            ((FrameBodyTXXX)frame.getBody()).setDescription(formatKey.getSubId());
            ((FrameBodyTXXX)frame.getBody()).setText(value);
        } else if (frame.getBody() instanceof FrameBodyWXXX) {
            ((FrameBodyWXXX)frame.getBody()).setDescription(formatKey.getSubId());
            ((FrameBodyWXXX)frame.getBody()).setUrlLink(value);
        } else if (frame.getBody() instanceof FrameBodyCOMM) {
            ((FrameBodyCOMM)frame.getBody()).setText(value);
        } else if (frame.getBody() instanceof FrameBodyUSLT) {
            ((FrameBodyUSLT)frame.getBody()).setDescription("");
            ((FrameBodyUSLT)frame.getBody()).setLyric(value);
        } else if (frame.getBody() instanceof FrameBodyWOAR) {
            ((FrameBodyWOAR)frame.getBody()).setUrlLink(value);
        } else if (frame.getBody() instanceof AbstractFrameBodyTextInfo) {
            ((AbstractFrameBodyTextInfo)frame.getBody()).setText(value);
        } else {
            if (frame.getBody() instanceof FrameBodyAPIC || frame.getBody() instanceof FrameBodyPIC) {
                throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
            }
            throw new FieldDataInvalidException("Field with key of:" + formatKey.getFrameId() + ":does not accept cannot parse data:" + value);
        }
        return frame;
    }

    protected String doGetFirst(FrameAndSubId formatKey) throws KeyNotFoundException {
        if (formatKey.getSubId() == null) {
            return this.getFirst(formatKey.getFrameId());
        }
        List<TagField> list = this.get(formatKey.getFrameId());
        ListIterator<TagField> li = list.listIterator();
        while (li.hasNext()) {
            AbstractTagFrameBody next = ((AbstractID3v2Frame)li.next()).getBody();
            if (next instanceof FrameBodyTXXX) {
                if (!((FrameBodyTXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                return ((FrameBodyTXXX)next).getText();
            }
            if (next instanceof FrameBodyWXXX) {
                if (!((FrameBodyWXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                return ((FrameBodyWXXX)next).getUrlLink();
            }
            if (next instanceof FrameBodyUFID) {
                if (!Arrays.equals(((FrameBodyUFID)next).getUniqueIdentifier(), formatKey.getSubId().getBytes())) continue;
                return new String(((FrameBodyUFID)next).getUniqueIdentifier());
            }
            throw new RuntimeException("Need to implement getFields(FieldKey genericKey) for:" + next.getClass());
        }
        return "";
    }

    public TagField createLinkedArtworkField(String url) {
        AbstractID3v2Frame frame = this.createFrame(this.getFrameAndSubIdFromGenericKey(FieldKey.COVER_ART).getFrameId());
        if (frame.getBody() instanceof FrameBodyAPIC) {
            FrameBodyAPIC body = (FrameBodyAPIC)frame.getBody();
            body.setObjectValue("PictureData", Utils.getDefaultBytes(url, "ISO-8859-1"));
            body.setObjectValue("PictureType", PictureTypes.DEFAULT_ID);
            body.setObjectValue("MIMEType", "-->");
            body.setObjectValue("Description", "");
        } else if (frame.getBody() instanceof FrameBodyPIC) {
            FrameBodyPIC body = (FrameBodyPIC)frame.getBody();
            body.setObjectValue("PictureData", Utils.getDefaultBytes(url, "ISO-8859-1"));
            body.setObjectValue("PictureType", PictureTypes.DEFAULT_ID);
            body.setObjectValue("ImageType", "-->");
            body.setObjectValue("Description", "");
        }
        return frame;
    }

    @Override
    public void deleteField(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        FrameAndSubId formatKey = this.getFrameAndSubIdFromGenericKey(genericKey);
        this.doDeleteTagField(formatKey);
    }

    protected void doDeleteTagField(FrameAndSubId formatKey) throws KeyNotFoundException {
        if (formatKey.getSubId() == null) {
            this.removeFrame(formatKey.getFrameId());
        } else {
            List<TagField> list = this.get(formatKey.getFrameId());
            ListIterator<TagField> li = list.listIterator();
            while (li.hasNext()) {
                AbstractTagFrameBody next = ((AbstractID3v2Frame)li.next()).getBody();
                if (next instanceof FrameBodyTXXX) {
                    if (!((FrameBodyTXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                    li.remove();
                    continue;
                }
                if (next instanceof FrameBodyWXXX) {
                    if (!((FrameBodyWXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                    li.remove();
                    continue;
                }
                if (next instanceof FrameBodyUFID) {
                    if (!Arrays.equals(((FrameBodyUFID)next).getUniqueIdentifier(), formatKey.getSubId().getBytes())) continue;
                    li.remove();
                    continue;
                }
                throw new RuntimeException("Need to implement getFields(FieldKey genericKey) for:" + next.getClass());
            }
        }
    }

    protected abstract FrameAndSubId getFrameAndSubIdFromGenericKey(FieldKey var1);

    @Override
    public List<TagField> getFields(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        FrameAndSubId formatKey = this.getFrameAndSubIdFromGenericKey(genericKey);
        List<TagField> list = this.get(formatKey.getFrameId());
        ArrayList<TagField> filteredList = new ArrayList<TagField>();
        String subFieldId = formatKey.getSubId();
        String frameid = formatKey.getFrameId();
        if (subFieldId != null) {
            for (TagField tagfield : list) {
                AbstractTagFrameBody next = ((AbstractID3v2Frame)tagfield).getBody();
                if (next instanceof FrameBodyTXXX) {
                    if (!((FrameBodyTXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                    filteredList.add(tagfield);
                    continue;
                }
                if (next instanceof FrameBodyWXXX) {
                    if (!((FrameBodyWXXX)next).getDescription().equals(formatKey.getSubId())) continue;
                    filteredList.add(tagfield);
                    continue;
                }
                if (next instanceof FrameBodyUFID) {
                    if (!Arrays.equals(((FrameBodyUFID)next).getUniqueIdentifier(), formatKey.getSubId().getBytes())) continue;
                    filteredList.add(tagfield);
                    continue;
                }
                throw new RuntimeException("Need to implement getFields(FieldKey genericKey) for:" + next.getClass());
            }
            return filteredList;
        }
        return list;
    }

    @Override
    public Artwork getFirstArtwork() {
        List<Artwork> artwork = this.getArtworkList();
        if (artwork.size() > 0) {
            return artwork.get(0);
        }
        return null;
    }

    @Override
    public void setField(Artwork artwork) throws FieldDataInvalidException {
        this.setField(this.createField(artwork));
    }

    @Override
    public void addField(Artwork artwork) throws FieldDataInvalidException {
        this.addField(this.createField(artwork));
    }

    @Override
    public void deleteArtworkField() throws KeyNotFoundException {
        this.deleteField(FieldKey.COVER_ART);
    }

    class FrameAndSubId {
        private String frameId;
        private String subId;

        public FrameAndSubId(String frameId, String subId) {
            this.frameId = frameId;
            this.subId = subId;
        }

        public String getFrameId() {
            return this.frameId;
        }

        public String getSubId() {
            return this.subId;
        }
    }
}

