/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.jaudiotagger.audio.generic.AbstractTag;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.datatype.Artwork;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.Mp4TagField;
import org.jaudiotagger.tag.mp4.field.Mp4DiscNoField;
import org.jaudiotagger.tag.mp4.field.Mp4GenreField;
import org.jaudiotagger.tag.mp4.field.Mp4TagByteField;
import org.jaudiotagger.tag.mp4.field.Mp4TagCoverField;
import org.jaudiotagger.tag.mp4.field.Mp4TagReverseDnsField;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextField;
import org.jaudiotagger.tag.mp4.field.Mp4TagTextNumberField;
import org.jaudiotagger.tag.mp4.field.Mp4TrackField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mp4Tag
extends AbstractTag {
    private static final EnumMap<FieldKey, Mp4FieldKey> tagFieldToMp4Field = new EnumMap(FieldKey.class);

    private TagField createGenreField(String content) {
        if (content == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        if (Mp4GenreField.isValidGenre(content)) {
            return new Mp4GenreField(content);
        }
        return new Mp4TagTextField(Mp4FieldKey.GENRE_CUSTOM.getFieldName(), content);
    }

    @Override
    protected boolean isAllowedEncoding(String enc) {
        return enc.equals("UTF-8");
    }

    @Override
    public String toString() {
        return "Mpeg4 " + super.toString();
    }

    @Override
    public List<TagField> getFields(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return super.get(tagFieldToMp4Field.get((Object)genericKey).getFieldName());
    }

    public List<TagField> get(Mp4FieldKey mp4FieldKey) throws KeyNotFoundException {
        if (mp4FieldKey == null) {
            throw new KeyNotFoundException();
        }
        return super.get(mp4FieldKey.getFieldName());
    }

    @Override
    public String getFirst(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        if (genericKey == FieldKey.GENRE) {
            List<TagField> genres = this.get(Mp4FieldKey.GENRE.getFieldName());
            if (genres.size() == 0) {
                genres = this.get(Mp4FieldKey.GENRE_CUSTOM.getFieldName());
            }
            if (genres.size() > 0) {
                return ((TagTextField)genres.get(0)).getContent();
            }
            return "";
        }
        if (genericKey == FieldKey.TRACK) {
            Mp4TrackField trackField;
            List<TagField> list = this.get(tagFieldToMp4Field.get((Object)genericKey));
            if (list.size() > 0 && (trackField = (Mp4TrackField)list.get(0)).getTrackNo() > 0) {
                return String.valueOf(trackField.getTrackNo());
            }
        } else if (genericKey == FieldKey.TRACK_TOTAL) {
            Mp4TrackField trackField;
            List<TagField> list = this.get(tagFieldToMp4Field.get((Object)genericKey));
            if (list.size() > 0 && (trackField = (Mp4TrackField)list.get(0)).getTrackTotal() > 0) {
                return String.valueOf(trackField.getTrackTotal());
            }
        } else if (genericKey == FieldKey.DISC_NO) {
            Mp4DiscNoField discField;
            List<TagField> list = this.get(tagFieldToMp4Field.get((Object)genericKey));
            if (list.size() > 0 && (discField = (Mp4DiscNoField)list.get(0)).getDiscNo() > 0) {
                return String.valueOf(discField.getDiscNo());
            }
        } else if (genericKey == FieldKey.DISC_TOTAL) {
            Mp4DiscNoField discField;
            List<TagField> list = this.get(tagFieldToMp4Field.get((Object)genericKey));
            if (list.size() > 0 && (discField = (Mp4DiscNoField)list.get(0)).getDiscTotal() > 0) {
                return String.valueOf(discField.getDiscTotal());
            }
        } else {
            return super.getFirst(tagFieldToMp4Field.get((Object)genericKey).getFieldName());
        }
        return "";
    }

    public String getFirst(Mp4FieldKey mp4Key) throws KeyNotFoundException {
        if (mp4Key == null) {
            throw new KeyNotFoundException();
        }
        return super.getFirst(mp4Key.getFieldName());
    }

    @Override
    public Mp4TagField getFirstField(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        return (Mp4TagField)super.getFirstField(tagFieldToMp4Field.get((Object)genericKey).getFieldName());
    }

    public Mp4TagField getFirstField(Mp4FieldKey mp4Key) throws KeyNotFoundException {
        if (mp4Key == null) {
            throw new KeyNotFoundException();
        }
        return (Mp4TagField)super.getFirstField(mp4Key.getFieldName());
    }

    @Override
    public void deleteField(FieldKey genericKey) throws KeyNotFoundException {
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        super.deleteField(tagFieldToMp4Field.get((Object)genericKey).getFieldName());
    }

    public void deleteField(Mp4FieldKey mp4Key) throws KeyNotFoundException {
        if (mp4Key == null) {
            throw new KeyNotFoundException();
        }
        super.deleteField(mp4Key.getFieldName());
    }

    public TagField createArtworkField(byte[] data) {
        return new Mp4TagCoverField(data);
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        return new Mp4TagCoverField(artwork.getBinaryData());
    }

    @Override
    public TagField createField(FieldKey genericKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (value == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        if (genericKey == null) {
            throw new KeyNotFoundException();
        }
        if (genericKey == FieldKey.TRACK) {
            return new Mp4TrackField(Integer.parseInt(value));
        }
        if (genericKey == FieldKey.TRACK_TOTAL) {
            return new Mp4TrackField(0, Integer.parseInt(value));
        }
        if (genericKey == FieldKey.DISC_NO) {
            return new Mp4DiscNoField(Integer.parseInt(value));
        }
        if (genericKey == FieldKey.DISC_TOTAL) {
            return new Mp4DiscNoField(0, Integer.parseInt(value));
        }
        return this.createField(tagFieldToMp4Field.get((Object)genericKey), value);
    }

    @Override
    public void setField(TagField field) {
        if (field == null) {
            return;
        }
        if (field.getId().equals(Mp4FieldKey.TRACK.getFieldName())) {
            List list = (List)this.fields.get(field.getId());
            if (list == null || list.size() == 0) {
                super.setField(field);
            } else {
                Mp4TrackField existingTrackField = (Mp4TrackField)list.get(0);
                Mp4TrackField newTrackField = (Mp4TrackField)field;
                Short trackNo = existingTrackField.getTrackNo();
                Short trackTotal = existingTrackField.getTrackTotal();
                if (newTrackField.getTrackNo() > 0) {
                    trackNo = newTrackField.getTrackNo();
                }
                if (newTrackField.getTrackTotal() > 0) {
                    trackTotal = newTrackField.getTrackTotal();
                }
                Mp4TrackField mergedTrackField = new Mp4TrackField(trackNo.shortValue(), trackTotal.shortValue());
                super.setField(mergedTrackField);
            }
        } else if (field.getId().equals(Mp4FieldKey.DISCNUMBER.getFieldName())) {
            List list = (List)this.fields.get(field.getId());
            if (list == null || list.size() == 0) {
                super.setField(field);
            } else {
                Mp4DiscNoField existingDiscNoField = (Mp4DiscNoField)list.get(0);
                Mp4DiscNoField newDiscNoField = (Mp4DiscNoField)field;
                Short discNo = existingDiscNoField.getDiscNo();
                Short discTotal = existingDiscNoField.getDiscTotal();
                if (newDiscNoField.getDiscNo() > 0) {
                    discNo = newDiscNoField.getDiscNo();
                }
                if (newDiscNoField.getDiscTotal() > 0) {
                    discTotal = newDiscNoField.getDiscTotal();
                }
                Mp4DiscNoField mergedDiscNoField = new Mp4DiscNoField(discNo.shortValue(), discTotal.shortValue());
                super.setField(mergedDiscNoField);
            }
        } else {
            super.setField(field);
        }
    }

    public TagField createField(Mp4FieldKey mp4FieldKey, String value) throws KeyNotFoundException, FieldDataInvalidException {
        if (value == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        if (mp4FieldKey == null) {
            throw new KeyNotFoundException();
        }
        switch (mp4FieldKey) {
            case COMPILATION: {
                if (value.equals("true")) {
                    value = Mp4TagByteField.TRUE_VALUE;
                }
                return new Mp4TagByteField(mp4FieldKey, value, mp4FieldKey.getFieldLength());
            }
            case RATING: 
            case BPM: 
            case CONTENT_TYPE: 
            case TV_SEASON: 
            case TV_EPISODE: 
            case TOOL: {
                return new Mp4TagByteField(mp4FieldKey, value, mp4FieldKey.getFieldLength());
            }
            case GENRE: {
                return this.createGenreField(value);
            }
            case PODCAST_URL: 
            case EPISODE_GLOBAL_ID: {
                return new Mp4TagTextNumberField(mp4FieldKey.getFieldName(), value);
            }
            case DISCNUMBER: {
                return new Mp4DiscNoField(value);
            }
            case TRACK: {
                return new Mp4TrackField(value);
            }
            case MUSICBRAINZ_TRACKID: 
            case MUSICBRAINZ_ARTISTID: 
            case MUSICBRAINZ_ALBUMID: 
            case MUSICBRAINZ_ALBUMARTISTID: 
            case MUSICBRAINZ_DISCID: 
            case MUSICIP_PUID: 
            case ASIN: 
            case MUSICBRAINZ_ALBUM_STATUS: 
            case MUSICBRAINZ_ALBUM_TYPE: 
            case RELEASECOUNTRY: 
            case PART_OF_GAPLESS_ALBUM: 
            case ITUNES_SMPB: 
            case ITUNES_NORM: 
            case CDDB_1: 
            case CDDB_TRACKNUMBER: 
            case CDDB_IDS: 
            case LYRICIST: 
            case CONDUCTOR: 
            case REMIXER: 
            case ENGINEER: 
            case PRODUCER: 
            case DJMIXER: 
            case MIXER: 
            case MOOD: 
            case ISRC: 
            case MEDIA: 
            case LABEL: 
            case CATALOGNO: 
            case BARCODE: 
            case URL_OFFICIAL_RELEASE_SITE: 
            case URL_DISCOGS_RELEASE_SITE: 
            case URL_WIKIPEDIA_RELEASE_SITE: 
            case URL_OFFICIAL_ARTIST_SITE: 
            case URL_DISCOGS_ARTIST_SITE: 
            case URL_WIKIPEDIA_ARTIST_SITE: 
            case LANGUAGE: 
            case KEY: 
            case URL_LYRICS_SITE: {
                return new Mp4TagReverseDnsField(mp4FieldKey, value);
            }
            case ARTWORK: {
                throw new UnsupportedOperationException(ErrorMessage.ARTWORK_CANNOT_BE_CREATED_WITH_THIS_METHOD.getMsg());
            }
        }
        return new Mp4TagTextField(mp4FieldKey.getFieldName(), value);
    }

    @Override
    public List<Artwork> getArtworkList() {
        List<TagField> coverartList = this.get(Mp4FieldKey.ARTWORK);
        ArrayList<Artwork> artworkList = new ArrayList<Artwork>(coverartList.size());
        for (TagField next : coverartList) {
            Mp4TagCoverField mp4CoverArt = (Mp4TagCoverField)next;
            Artwork artwork = new Artwork();
            artwork.setBinaryData(mp4CoverArt.getData());
            artwork.setMimeType(Mp4TagCoverField.getMimeTypeForImageType(mp4CoverArt.getFieldType()));
            artworkList.add(artwork);
        }
        return artworkList;
    }

    static {
        tagFieldToMp4Field.put(FieldKey.ARTIST, Mp4FieldKey.ARTIST);
        tagFieldToMp4Field.put(FieldKey.ALBUM, Mp4FieldKey.ALBUM);
        tagFieldToMp4Field.put(FieldKey.TITLE, Mp4FieldKey.TITLE);
        tagFieldToMp4Field.put(FieldKey.TRACK, Mp4FieldKey.TRACK);
        tagFieldToMp4Field.put(FieldKey.YEAR, Mp4FieldKey.DAY);
        tagFieldToMp4Field.put(FieldKey.GENRE, Mp4FieldKey.GENRE);
        tagFieldToMp4Field.put(FieldKey.COMMENT, Mp4FieldKey.COMMENT);
        tagFieldToMp4Field.put(FieldKey.ALBUM_ARTIST, Mp4FieldKey.ALBUM_ARTIST);
        tagFieldToMp4Field.put(FieldKey.COMPOSER, Mp4FieldKey.COMPOSER);
        tagFieldToMp4Field.put(FieldKey.GROUPING, Mp4FieldKey.GROUPING);
        tagFieldToMp4Field.put(FieldKey.DISC_NO, Mp4FieldKey.DISCNUMBER);
        tagFieldToMp4Field.put(FieldKey.BPM, Mp4FieldKey.BPM);
        tagFieldToMp4Field.put(FieldKey.ENCODER, Mp4FieldKey.ENCODER);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_ARTISTID, Mp4FieldKey.MUSICBRAINZ_ARTISTID);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_RELEASEID, Mp4FieldKey.MUSICBRAINZ_ALBUMID);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_RELEASEARTISTID, Mp4FieldKey.MUSICBRAINZ_ALBUMARTISTID);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_TRACK_ID, Mp4FieldKey.MUSICBRAINZ_TRACKID);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_DISC_ID, Mp4FieldKey.MUSICBRAINZ_DISCID);
        tagFieldToMp4Field.put(FieldKey.MUSICIP_ID, Mp4FieldKey.MUSICIP_PUID);
        tagFieldToMp4Field.put(FieldKey.AMAZON_ID, Mp4FieldKey.ASIN);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_RELEASE_STATUS, Mp4FieldKey.MUSICBRAINZ_ALBUM_STATUS);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_RELEASE_TYPE, Mp4FieldKey.MUSICBRAINZ_ALBUM_TYPE);
        tagFieldToMp4Field.put(FieldKey.MUSICBRAINZ_RELEASE_COUNTRY, Mp4FieldKey.RELEASECOUNTRY);
        tagFieldToMp4Field.put(FieldKey.LYRICS, Mp4FieldKey.LYRICS);
        tagFieldToMp4Field.put(FieldKey.IS_COMPILATION, Mp4FieldKey.COMPILATION);
        tagFieldToMp4Field.put(FieldKey.ARTIST_SORT, Mp4FieldKey.ARTIST_SORT);
        tagFieldToMp4Field.put(FieldKey.ALBUM_ARTIST_SORT, Mp4FieldKey.ALBUM_ARTIST_SORT);
        tagFieldToMp4Field.put(FieldKey.ALBUM_SORT, Mp4FieldKey.ALBUM_SORT);
        tagFieldToMp4Field.put(FieldKey.TITLE_SORT, Mp4FieldKey.TITLE_SORT);
        tagFieldToMp4Field.put(FieldKey.COMPOSER_SORT, Mp4FieldKey.COMPOSER_SORT);
        tagFieldToMp4Field.put(FieldKey.COVER_ART, Mp4FieldKey.ARTWORK);
        tagFieldToMp4Field.put(FieldKey.ISRC, Mp4FieldKey.ISRC);
        tagFieldToMp4Field.put(FieldKey.CATALOG_NO, Mp4FieldKey.CATALOGNO);
        tagFieldToMp4Field.put(FieldKey.BARCODE, Mp4FieldKey.BARCODE);
        tagFieldToMp4Field.put(FieldKey.RECORD_LABEL, Mp4FieldKey.LABEL);
        tagFieldToMp4Field.put(FieldKey.LYRICIST, Mp4FieldKey.LYRICIST);
        tagFieldToMp4Field.put(FieldKey.CONDUCTOR, Mp4FieldKey.CONDUCTOR);
        tagFieldToMp4Field.put(FieldKey.REMIXER, Mp4FieldKey.REMIXER);
        tagFieldToMp4Field.put(FieldKey.MOOD, Mp4FieldKey.MOOD);
        tagFieldToMp4Field.put(FieldKey.MEDIA, Mp4FieldKey.MEDIA);
        tagFieldToMp4Field.put(FieldKey.URL_OFFICIAL_RELEASE_SITE, Mp4FieldKey.URL_OFFICIAL_RELEASE_SITE);
        tagFieldToMp4Field.put(FieldKey.URL_DISCOGS_RELEASE_SITE, Mp4FieldKey.URL_DISCOGS_RELEASE_SITE);
        tagFieldToMp4Field.put(FieldKey.URL_WIKIPEDIA_RELEASE_SITE, Mp4FieldKey.URL_WIKIPEDIA_RELEASE_SITE);
        tagFieldToMp4Field.put(FieldKey.URL_OFFICIAL_ARTIST_SITE, Mp4FieldKey.URL_OFFICIAL_ARTIST_SITE);
        tagFieldToMp4Field.put(FieldKey.URL_DISCOGS_ARTIST_SITE, Mp4FieldKey.URL_DISCOGS_ARTIST_SITE);
        tagFieldToMp4Field.put(FieldKey.URL_WIKIPEDIA_ARTIST_SITE, Mp4FieldKey.URL_WIKIPEDIA_ARTIST_SITE);
        tagFieldToMp4Field.put(FieldKey.LANGUAGE, Mp4FieldKey.LANGUAGE);
        tagFieldToMp4Field.put(FieldKey.KEY, Mp4FieldKey.KEY);
        tagFieldToMp4Field.put(FieldKey.URL_LYRICS_SITE, Mp4FieldKey.URL_LYRICS_SITE);
        tagFieldToMp4Field.put(FieldKey.TRACK_TOTAL, Mp4FieldKey.TRACK);
        tagFieldToMp4Field.put(FieldKey.DISC_TOTAL, Mp4FieldKey.DISCNUMBER);
    }
}

