/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper;

import gui.MainWindow;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import javazoom.jl.decoder.BitstreamException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.codec.DecoderException;
import tsStreamRipper.CliOptionComparator;
import tsStreamRipper.Configuration;
import tsStreamRipper.audio.ConverterFactory;
import tsStreamRipper.audio.ConverterOption;
import tsStreamRipper.dream.filestream.IFileStreamNameFormatter;
import tsStreamRipper.dream.filestream.InterpretTitelFormat;
import tsStreamRipper.dream.filestream.TitelInterpretFormat;
import tsStreamRipper.dream.webinterface.HttpParameter;
import tsStreamRipper.dream.webinterface.parser.EPGType;
import tsStreamRipper.dream.webstreaming.IExceptionCallback;
import tsStreamRipper.dream.webstreaming.StreamChannel;
import tsStreamRipper.util.logging.Config;

public class StreamIt
implements IExceptionCallback {
    private static final Logger log = Logger.getLogger(StreamIt.class.getName());
    private static String host = null;
    private static int port = 8001;
    private static int restdauerOffset = 20;
    private static int webPort = 80;
    private static String channelId = null;
    private static String channel = null;
    private static String dest = null;
    private static String tmpDir = System.getProperty("java.io.tmpdir");
    private static String user = "";
    private static String pass = "";
    private static boolean verbose = false;
    private static ConverterOption convertOpt = null;
    private static EPGType epgType = EPGType.SKY_RADIO;
    private static IFileStreamNameFormatter nameFormat = null;
    private static boolean overwriteExisting = false;
    private static Properties channelIdList = new Properties();
    public static final String version = "tsStreamRipper Version 1.1.8";

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            log.info("Starte tsStreamRipper GUI ...");
            MainWindow.showMainWindow();
            return;
        }
        Options opt = StreamIt.createCliOptions();
        try {
            boolean del;
            GnuParser parser = new GnuParser();
            CommandLine line = parser.parse(opt, args);
            if (line.hasOption("help")) {
                StreamIt.printHelp(opt);
                return;
            }
            if (line.hasOption("host")) {
                host = line.getOptionValue("host");
            }
            if (line.hasOption("streamport")) {
                port = Integer.parseInt(line.getOptionValue("streamport"));
            }
            if (line.hasOption("remainTimeOffset")) {
                restdauerOffset = Integer.parseInt(line.getOptionValue("remainTimeOffset"));
            }
            if (line.hasOption("webport")) {
                webPort = Integer.parseInt(line.getOptionValue("webport"));
            }
            if (line.hasOption("channelId")) {
                channelId = line.getOptionValue("channelId");
            }
            if (line.hasOption("channel")) {
                channel = line.getOptionValue("channel");
                channelIdList.load(StreamIt.class.getResourceAsStream("/channel.properties"));
                channelId = channelIdList.getProperty(channel);
                if (channelId == null) {
                    log.severe(String.format("Channel '%s' ist unbekannt.", channel));
                }
            }
            if (line.hasOption("channelKd")) {
                channel = line.getOptionValue("channel");
                channelIdList.load(StreamIt.class.getResourceAsStream("/channel_kd.properties"));
                channelId = channelIdList.getProperty(channel);
                if (channelId == null) {
                    log.severe(String.format("Channel '%s' ist unbekannt.", channel));
                }
            }
            if (line.hasOption("musicDir")) {
                dest = line.getOptionValue("musicDir");
            }
            if (line.hasOption("user")) {
                user = line.getOptionValue("user");
            }
            if (line.hasOption("pass")) {
                pass = line.getOptionValue("pass");
            }
            if (line.hasOption("tmpDir")) {
                tmpDir = line.getOptionValue("tmpDir");
            }
            if (line.hasOption("verbose")) {
                verbose = true;
            }
            if (line.hasOption("convert")) {
                del = true;
                if (line.hasOption("keepOrig")) {
                    del = false;
                }
                try {
                    convertOpt = new ConverterOption(ConverterFactory.ConverterType.AAC, new File(line.getOptionValue("convert")), del);
                }
                catch (Exception e) {
                    log.warning(e.getMessage());
                    convertOpt = null;
                }
            }
            if (line.hasOption("convert_mp3")) {
                del = true;
                if (line.hasOption("keepOrig")) {
                    del = false;
                }
                try {
                    convertOpt = new ConverterOption(ConverterFactory.ConverterType.MP3, new File(line.getOptionValue("convert_mp3")), del);
                }
                catch (Exception e) {
                    log.warning(e.getMessage());
                    convertOpt = null;
                }
            }
            if (line.hasOption("overwrite")) {
                overwriteExisting = true;
            }
            if (host == null) {
                log.severe("-host nicht gesetzt!");
                StreamIt.printHelp(opt);
                System.exit(1);
            }
            if (channelId == null) {
                log.severe("-channel, channelKd oder -channelId ist nicht gesetzt");
                StreamIt.printHelp(opt);
                System.exit(1);
            }
            nameFormat = line.hasOption("switchFilenameFormat") ? new InterpretTitelFormat() : new TitelInterpretFormat();
            if (line.hasOption("epgType")) {
                String epgTypeStr = line.getOptionValue("epgType");
                if ("sky".equalsIgnoreCase(epgTypeStr)) {
                    epgType = EPGType.SKY_RADIO;
                } else if ("swiss".equalsIgnoreCase(epgTypeStr)) {
                    epgType = EPGType.SWISS_SATELLITE_RADIO;
                } else if ("kd".equalsIgnoreCase(epgTypeStr)) {
                    epgType = EPGType.KD_23_5_GRAD;
                } else {
                    log.severe("Ung\u00fcltiger epgType gesetzt : '" + epgTypeStr + "'");
                    StreamIt.printHelp(opt);
                    System.exit(1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            StreamIt.printHelp(opt);
        }
        Config.configureRuntimeLogging(verbose, false);
        log.info("Starte tsStreamRipper ... ");
        log.info(version);
        if (dest == null) {
            log.severe("'-musicDir' Verzeichnis wurde nicht angegeben oder existiert nicht. Programm endet jetzt");
            return;
        }
        log.info(String.format("Verbose : %s", Boolean.toString(verbose)));
        StreamIt si = new StreamIt();
        si.stream();
    }

    private static void printHelp(Options options) {
        System.out.println(version);
        HelpFormatter formatter = new HelpFormatter();
        formatter.setOptionComparator(new CliOptionComparator());
        formatter.printHelp("java -jar tsStreamRipper.jar -host <host> -musicDir <dir> [-channel <chan> | -channelKd <chan> | -channelId <id>] [options]", options);
    }

    private void stream() throws IOException, BitstreamException, DecoderException {
        File tempDir = null;
        File destDir = null;
        if (tmpDir != null) {
            tempDir = new File(tmpDir);
        }
        if (dest != null) {
            destDir = new File(dest);
        }
        if (tempDir != null && !tempDir.exists()) {
            log.severe(String.format("tmpDir '%s' existiert nicht, oder keine Berechtigung zum Zugriff.", tempDir.getAbsoluteFile()));
            System.exit(1);
        }
        if (destDir != null && !destDir.exists()) {
            log.severe(String.format("'musicDir' Parameter fehlerhaft. Zielverzeichnis '%s' existiert nicht, oder keine Berechtigung zum Zugriff.", destDir.getAbsoluteFile()));
            System.exit(1);
        }
        HttpParameter params = new HttpParameter(host, webPort, port, user, pass);
        try {
            Configuration conf = new Configuration(params, channelId, tempDir, destDir, convertOpt, nameFormat, overwriteExisting, restdauerOffset, epgType);
            StreamChannel chan = new StreamChannel(this, conf);
            chan.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static Options createCliOptions() {
        Options options = new Options();
        OptionBuilder.withArgName("host/ip");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Dreambox Hostname oder IP Adresse");
        Option host = OptionBuilder.create("host");
        OptionBuilder.withArgName("portnumber");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription("Dreambox Streaming-Portnummer. Default ist 8001.");
        Option port = OptionBuilder.create("streamport");
        OptionBuilder.withArgName("portnumber");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription("Dreambox Webinterface-Portnummer. Default ist 80.");
        Option webport_opt = OptionBuilder.create("webport");
        OptionBuilder.withArgName("username");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription("Falls HTTP Authentifizierung aktiv ist : Username");
        Option user = OptionBuilder.create("user");
        OptionBuilder.withArgName("passwort");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription("Falls HTTP Authentifizierung aktiv ist : Passwort");
        Option pass = OptionBuilder.create("pass");
        OptionBuilder.withArgName("name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("SAT Musikkanal der Aufgezeichnet werden soll. Derzeit sind sind folgende SKY Kanaele vorkonfiguriert und werden als <name> Parameter akzeptiert:\r\n- 60er_70er\r\n- 80er_90er\r\n- country\r\n- deutsche_charts\r\n- lovesongs\r\n- rnb_hiphop\r\n- rock_hymnen");
        Option channel = OptionBuilder.create("channel");
        OptionBuilder.withArgName("name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("KD Musikkanal der Aufgezeichnet werden soll. Vorkonfiguriert wie SAT.");
        Option optChannelKd = OptionBuilder.create("channelKd");
        OptionBuilder.withArgName("sRef");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Hier kann direkt die 'sRef' Referenz des Musikkanals angegeben werden. Die Parameter '-channelId' und '-channel' schliessen sich gegenseitig aus.");
        Option channelSref = OptionBuilder.create("channelId");
        OptionBuilder.withArgName("dir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Verzeichnis in dem gerippte Musikstuecke abgelegt werden.");
        Option ziel = OptionBuilder.create("musicDir");
        OptionBuilder.withArgName("dir");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription("Verzeichnis in dem temporaere Streams gespeichert werden.");
        Option tmpDir = OptionBuilder.create("tmpDir");
        OptionBuilder.withDescription("Ausf\u00fchrliches Logging aktivieren");
        Option verbose = OptionBuilder.create("verbose");
        OptionBuilder.withArgName("Sekunden");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription("Offset f\u00fcr gemeldete Restdauer des Liedende vom Web-Interface in Sekunden. Default ist +20 Sekunden.");
        Option remainOffset = OptionBuilder.create("remainTimeOffset");
        OptionBuilder.withArgName("sky|swiss|kd");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withDescription("EPG Typ. Unterst\u00fctzt derzeit : Sky Radio ('sky'), Swiss Satellite Radio ('swiss') und KD 23,5\u00b0 ('kd'). Default ist 'sky'.");
        Option epgTypeOpt = OptionBuilder.create("epgType");
        OptionBuilder.withArgName("faacFile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Konvertierung MP2 Dateien nach m4a.");
        Option convert = OptionBuilder.create("convert");
        OptionBuilder.withArgName("lameFile");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Konvertierung MP2 Dateien nach mp3.");
        Option convertmp3 = OptionBuilder.create("convert_mp3");
        OptionBuilder.withDescription("Vorhandenen Titel \u00fcberschreiben. Default : False");
        Option overwrite = OptionBuilder.create("overwrite");
        OptionBuilder.withDescription("Dieser Hilfetext");
        Option help = OptionBuilder.create("help");
        OptionBuilder.withDescription("Bei Konvertierung : Originale MP2-Datei behalten. Per Default werden diese gel\u00f6scht.");
        Option delConvert = OptionBuilder.create("keepOrig");
        OptionBuilder.withDescription("Musik-Dateiname im Format \"[Interpret] - [Titel]\" speichern.");
        Option filenameOption = OptionBuilder.create("switchFilenameFormat");
        options.addOption(host);
        options.addOption(port);
        options.addOption(webport_opt);
        options.addOption(ziel);
        options.addOption(tmpDir);
        options.addOption(user);
        options.addOption(pass);
        options.addOption(verbose);
        options.addOption(overwrite);
        options.addOption(delConvert);
        options.addOption(filenameOption);
        options.addOption(help);
        options.addOption(remainOffset);
        options.addOption(epgTypeOpt);
        OptionGroup convertGroup = new OptionGroup();
        convertGroup.addOption(convert);
        convertGroup.addOption(convertmp3);
        options.addOptionGroup(convertGroup);
        OptionGroup chanGroup = new OptionGroup();
        chanGroup.addOption(channel);
        chanGroup.addOption(optChannelKd);
        chanGroup.addOption(channelSref);
        options.addOptionGroup(chanGroup);
        return options;
    }

    @Override
    public void exceptionOccured(Exception e) {
        log.severe("Das Streaming meldet einen Fehler : " + e.getMessage());
    }
}

