/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.audio;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.logging.Logger;
import tsStreamRipper.audio.IExternalEncoder;

public abstract class BaseConvert
extends Thread
implements IExternalEncoder {
    private static final Logger log = Logger.getLogger(BaseConvert.class.getName());
    private boolean removeOrig = true;
    private File in = null;

    public BaseConvert(boolean removeOrig, File in) {
        this.removeOrig = removeOrig;
        this.in = in;
    }

    @Override
    public void startEncoding() {
        this.start();
    }

    protected abstract String getConverterName();

    protected abstract String getTargetFileFormat();

    @Override
    public void run() {
        this.preConvert();
        this.convert();
        this.postConvert();
    }

    private void convert() {
        block33: {
            StringBuilder sb = new StringBuilder();
            ProcessBuilder pb = new ProcessBuilder(this.getArgumentList());
            Process p = null;
            try {
                pb.redirectErrorStream(true);
                p = pb.start();
                BufferedReader isr = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = null;
                while ((line = isr.readLine()) != null) {
                    sb.append(line);
                }
                int exit = p.waitFor();
                if (exit != 0) {
                    log.warning("Konvertierung ist m\u00f6glicherweise fehlgeschlagen. Errorcode : " + exit);
                    log.warning(String.format("Gesamte Programmausgabe : \r\n%s", sb.toString()));
                }
            }
            catch (IOException e) {
                log.throwing("BaseConvert", "run", e);
                try {
                    p.getInputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    p.getOutputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    p.getErrorStream().close();
                }
                catch (IOException iOException) {}
                break block33;
            }
            catch (InterruptedException e) {
                try {
                    log.throwing("BaseConvert", "run", e);
                    break block33;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        p.getInputStream().close();
                    }
                    catch (IOException iOException) {}
                    try {
                        p.getOutputStream().close();
                    }
                    catch (IOException iOException) {}
                    try {
                        p.getErrorStream().close();
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                p.getInputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                p.getOutputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                p.getErrorStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        log.finer(String.format("Konvertierung zu %s beendet.", this.getTargetFileFormat()));
    }

    protected void preConvert() {
    }

    protected void postConvert() {
        if (this.removeOrig) {
            log.finer("Entferne Originaldatei " + this.in.getAbsolutePath());
            this.in.delete();
        }
        log.fine(String.format("Konvertierung nach %s beendet.", this.getTargetFileFormat()));
    }

    protected abstract List<String> getArgumentList();

    public boolean isRemoveOrig() {
        return this.removeOrig;
    }

    public File getInfile() {
        return this.in;
    }
}

