/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.audio;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javazoom.jl.converter.Converter;
import javazoom.jl.decoder.JavaLayerException;
import tsStreamRipper.audio.BaseConvert;
import tsStreamRipper.audio.ID3;

public class ConvertMp2ToAAC
extends BaseConvert {
    private static final Logger log = Logger.getLogger(ConvertMp2ToAAC.class.getName());
    private File in = null;
    private File out = null;
    private File tmpWavFile = null;
    private File faac = null;
    private ID3 id3 = null;

    public ConvertMp2ToAAC(File in, File out, ID3 id3, File tmpDir, File faac, boolean removeOrig) throws IOException {
        super(removeOrig, in);
        this.in = in;
        this.out = out;
        this.tmpWavFile = File.createTempFile("tmpWav", null, tmpDir);
        this.faac = faac;
        this.id3 = id3;
        if (faac != null && !faac.exists()) {
            throw new IOException("FAAC encoder path fehlerhaft : " + faac.getAbsolutePath());
        }
    }

    @Override
    protected void preConvert() {
        super.preConvert();
        Converter wavConv = new Converter();
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Convertiere MP3 File " + this.in.getAbsolutePath());
                log.fine("  - WAV File " + this.tmpWavFile.getAbsolutePath());
                log.fine("  - MP4 File " + this.out.getAbsolutePath());
            }
            log.finer("Konvertiere zun\u00e4chst zu einem WAV-File");
            wavConv.convert(this.in.getAbsolutePath(), this.tmpWavFile.getAbsolutePath());
        }
        catch (JavaLayerException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void postConvert() {
        if (log.isLoggable(Level.FINER)) {
            log.finer("L\u00f6sche tempor\u00e4re Wave Datei : " + this.tmpWavFile.getAbsolutePath());
        }
        this.tmpWavFile.delete();
        super.postConvert();
    }

    @Override
    protected List<String> getArgumentList() {
        LinkedList<String> args = new LinkedList<String>();
        args.add(this.faac.getAbsolutePath());
        args.add("-o");
        args.add(this.out.getAbsolutePath());
        args.add("--artist");
        args.add(this.id3.getInterpret());
        args.add("--title");
        args.add(this.id3.getTitel());
        args.add("--album");
        args.add(this.id3.getAlbum());
        args.add("--year");
        args.add(this.id3.getJahr());
        args.add(this.tmpWavFile.getAbsolutePath());
        return args;
    }

    @Override
    protected String getConverterName() {
        return "FAAC";
    }

    @Override
    protected String getTargetFileFormat() {
        return "M4A";
    }
}

