/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.audio;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tsStreamRipper.audio.BaseConvert;
import tsStreamRipper.audio.ConvertMp2ToAAC;
import tsStreamRipper.audio.ID3;

public class ConvertMp2ToMp3
extends BaseConvert {
    private static final Logger log = Logger.getLogger(ConvertMp2ToAAC.class.getName());
    private File out = null;
    private File lame = null;
    private ID3 id3 = null;

    public ConvertMp2ToMp3(File in, File out, ID3 id3, File lame, boolean removeOrig) throws IOException {
        super(removeOrig, in);
        this.out = out;
        this.lame = lame;
        this.id3 = id3;
        if (lame != null && !lame.exists()) {
            throw new IOException("LAME encoder path fehlerhaft : " + lame.getAbsolutePath());
        }
    }

    @Override
    protected void preConvert() {
        super.preConvert();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Convertiere MP2-File " + this.getInfile().getAbsolutePath());
            log.fine("  -> MP3 File : " + this.out.getAbsolutePath());
        }
    }

    @Override
    protected List<String> getArgumentList() {
        LinkedList<String> args = new LinkedList<String>();
        args.add(this.lame.getAbsolutePath());
        args.add("-V");
        args.add("2");
        args.add("--disptime");
        args.add("1000");
        args.add("--nohist");
        args.add("--flush");
        args.add("--ta");
        args.add(this.id3.getInterpret());
        args.add("--tt");
        args.add(this.id3.getTitel());
        args.add("--tl");
        args.add(this.id3.getAlbum());
        args.add("--ty");
        args.add(this.id3.getJahr());
        args.add(this.getInfile().getAbsolutePath());
        args.add(this.out.getAbsolutePath());
        return args;
    }

    @Override
    protected String getConverterName() {
        return "LAME";
    }

    @Override
    protected String getTargetFileFormat() {
        return "MP3";
    }
}

