/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.audio;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import tsStreamRipper.audio.ConvertMp2ToAAC;
import tsStreamRipper.audio.ConvertMp2ToMp3;
import tsStreamRipper.audio.ConverterOption;
import tsStreamRipper.audio.ID3;
import tsStreamRipper.audio.IExternalEncoder;

public class ConverterFactory {
    private static final Logger log = Logger.getLogger(ConverterFactory.class.getName());

    public static IExternalEncoder getEncoder(ConverterOption opt, File inFile, ID3 id3, File tmpDir) {
        CharSequence outFileName = inFile.getAbsolutePath();
        outFileName = outFileName.subSequence(0, outFileName.length() - 3);
        StringBuilder sb = new StringBuilder(outFileName).append(ConverterFactory.getFileExtension(opt.getType()));
        File outFile = new File(sb.toString());
        if (opt.getType().equals((Object)ConverterType.MP3)) {
            CharSequence mp2FileName = inFile.getAbsolutePath();
            mp2FileName = mp2FileName.subSequence(0, mp2FileName.length() - 3);
            File tmpFile = new File(mp2FileName + "mp2");
            inFile.renameTo(tmpFile);
            inFile = tmpFile;
            log.fine(" : " + inFile.getAbsolutePath());
        }
        if (opt.getType().equals((Object)ConverterType.AAC)) {
            try {
                return new ConvertMp2ToAAC(inFile, outFile, id3, tmpDir, opt.getConverterPath(), opt.isRemoveOriginalFile());
            }
            catch (IOException e) {
                log.severe("Fehler beim Erstellen des Converter-Threads:");
                e.printStackTrace();
            }
        } else if (opt.getType().equals((Object)ConverterType.MP3)) {
            try {
                return new ConvertMp2ToMp3(inFile, outFile, id3, opt.getConverterPath(), opt.isRemoveOriginalFile());
            }
            catch (IOException e) {
                log.severe("Fehler beim Erstellen des Converter-Threads:");
                e.printStackTrace();
            }
        } else {
            log.severe("Unknown Type : " + opt.getType().toString());
        }
        return null;
    }

    private static String getFileExtension(ConverterType type) {
        switch (type) {
            case AAC: {
                return "m4a";
            }
            case MP3: {
                return "mp3";
            }
        }
        log.severe("Unknown Type : " + type.toString());
        return "";
    }

    public static enum ConverterType {
        AAC,
        MP3;

    }
}

