/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.dream.filestream;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import tsStreamRipper.audio.ID3;
import tsStreamRipper.dream.filestream.IFileStreamNameFormatter;
import tsStreamRipper.dream.filestream.TitelInterpretFormat;

public class FileStream {
    private static long skipCounter = 0L;
    private ID3 id3 = new ID3();
    private static long skipDoubleCounter = 0L;
    private static long completeCounter = 0L;
    private static final Logger log = Logger.getLogger(FileStream.class.getName());
    private FileOutputStream out = null;
    private FileChannel outChannel = null;
    private File outFile = null;
    private File newFile = null;
    private boolean saveFile = true;
    private String skipReason = "";
    private File destinationDirectory = null;
    private boolean overwriteFiles = false;
    private IFileStreamNameFormatter fileNameStrategy = null;

    public FileStream() {
        this(null, null, new TitelInterpretFormat(), false);
    }

    public FileStream(File workDir, File destinationDirectory, IFileStreamNameFormatter filenameStrategy, boolean overwriteFiles) {
        this.destinationDirectory = destinationDirectory;
        this.fileNameStrategy = filenameStrategy;
        this.overwriteFiles = overwriteFiles;
        try {
            this.outFile = File.createTempFile("stream" + System.currentTimeMillis(), null, workDir);
            log.finer("create Temporary File : " + this.outFile.getAbsolutePath());
            this.out = new FileOutputStream(this.outFile);
            this.outChannel = this.out.getChannel();
        }
        catch (IOException e) {
            log.severe("Temporaere Datei kann nicht angelegt werden. Stoppe Aufnahme.");
        }
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void writeBuffer(ByteBuffer buffer) {
        buffer.flip();
        try {
            while (buffer.hasRemaining()) {
                this.outChannel.write(buffer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void closeFile() {
        block33: {
            try {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    try {
                        try {
                            String s = this.getNewFilename("mp3");
                            this.checkFileExists();
                            if (this.saveFile) {
                                this.newFile = new File(s);
                                log.info(String.format("Erstelle Musik-Datei : %s", s));
                                this.copyFile(this.outFile, this.newFile);
                                if (log.isLoggable(Level.FINER)) {
                                    log.finer("append ID3V2 Tag");
                                }
                                log.fine("F\u00fcge ID3 Tags zur Datei hinzu ...");
                                this.appendId3Tag(this.newFile);
                                ++completeCounter;
                                break block33;
                            }
                            log.info(String.format("Ueberspringe Lied  : %s", s));
                            log.info(String.format("Grund : %s (%d / %d / %d)", this.skipReason, completeCounter, skipDoubleCounter, skipCounter));
                        }
                        catch (Exception e) {
                            log.severe("Fehler beim erstellen der Musikdatei aus dem Datenstrom.");
                            log.throwing("FileStream", "closeFile", e);
                            if (log.isLoggable(Level.FINER)) {
                                log.finer("deleting old file : " + this.outFile.getAbsoluteFile());
                            }
                            this.outFile.delete();
                        }
                        break block33;
                    }
                    finally {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("deleting old file : " + this.outFile.getAbsoluteFile());
                        }
                        this.outFile.delete();
                    }
                }
            }
            catch (Throwable throwable) {
                block35: {
                    try {
                        try {
                            String s = this.getNewFilename("mp3");
                            this.checkFileExists();
                            if (this.saveFile) {
                                this.newFile = new File(s);
                                log.info(String.format("Erstelle Musik-Datei : %s", s));
                                this.copyFile(this.outFile, this.newFile);
                                if (log.isLoggable(Level.FINER)) {
                                    log.finer("append ID3V2 Tag");
                                }
                                log.fine("F\u00fcge ID3 Tags zur Datei hinzu ...");
                                this.appendId3Tag(this.newFile);
                                ++completeCounter;
                            } else {
                                log.info(String.format("Ueberspringe Lied  : %s", s));
                                log.info(String.format("Grund : %s (%d / %d / %d)", this.skipReason, completeCounter, skipDoubleCounter, skipCounter));
                            }
                        }
                        catch (Exception e) {
                            log.severe("Fehler beim erstellen der Musikdatei aus dem Datenstrom.");
                            log.throwing("FileStream", "closeFile", e);
                            if (log.isLoggable(Level.FINER)) {
                                log.finer("deleting old file : " + this.outFile.getAbsoluteFile());
                            }
                            this.outFile.delete();
                            break block35;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("deleting old file : " + this.outFile.getAbsoluteFile());
                        }
                        this.outFile.delete();
                        throw throwable2;
                    }
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("deleting old file : " + this.outFile.getAbsoluteFile());
                    }
                    this.outFile.delete();
                }
                throw throwable;
            }
            try {
                try {
                    String s = this.getNewFilename("mp3");
                    this.checkFileExists();
                    if (this.saveFile) {
                        this.newFile = new File(s);
                        log.info(String.format("Erstelle Musik-Datei : %s", s));
                        this.copyFile(this.outFile, this.newFile);
                        if (log.isLoggable(Level.FINER)) {
                            log.finer("append ID3V2 Tag");
                        }
                        log.fine("F\u00fcge ID3 Tags zur Datei hinzu ...");
                        this.appendId3Tag(this.newFile);
                        ++completeCounter;
                        break block33;
                    }
                    log.info(String.format("Ueberspringe Lied  : %s", s));
                    log.info(String.format("Grund : %s (%d / %d / %d)", this.skipReason, completeCounter, skipDoubleCounter, skipCounter));
                }
                catch (Exception e) {
                    log.severe("Fehler beim erstellen der Musikdatei aus dem Datenstrom.");
                    log.throwing("FileStream", "closeFile", e);
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("deleting old file : " + this.outFile.getAbsoluteFile());
                    }
                    this.outFile.delete();
                }
            }
            finally {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("deleting old file : " + this.outFile.getAbsoluteFile());
                }
                this.outFile.delete();
            }
        }
    }

    private boolean checkFileExists() {
        String s = this.getNewFilename("mp2");
        File f = new File(s);
        if (f.exists()) {
            if (this.saveFile && this.overwriteFiles) {
                log.finer("L\u00f6sche vorhandene Datei zwecks \u00dcberschreibung : " + s);
                f.delete();
                return false;
            }
            this.skipFileExists(String.format("Musikdatei '%s' existiert schon.", s));
            return true;
        }
        s = this.getNewFilename("mp3");
        f = new File(s);
        if (f.exists()) {
            if (this.saveFile && this.overwriteFiles) {
                log.finer("L\u00f6sche vorhandene Datei zwecks \u00dcberschreibung : " + s);
                f.delete();
                return false;
            }
            this.skipFileExists(String.format("Musikdatei '%s' existiert schon.", s));
            return true;
        }
        s = this.getNewFilename("m4a");
        f = new File(s);
        if (f.exists()) {
            if (this.saveFile && this.overwriteFiles) {
                log.finer("L\u00f6sche vorhandene Datei zwecks \u00dcberschreibung : " + s);
                f.delete();
                return false;
            }
            this.skipFileExists(String.format("Musikdatei '%s' existiert schon.", s));
            return true;
        }
        return false;
    }

    private String getNewFilename(String extension) {
        String s = null;
        String dir = null;
        if (this.destinationDirectory != null) {
            dir = this.destinationDirectory.getAbsolutePath();
        } else {
            dir = this.outFile.getParent();
            if (dir == null) {
                dir = "/";
            }
        }
        s = String.format("%s%s%s.%s", dir, File.separator, this.fileNameStrategy.getFilename(this.getStringFilename(this.getTitel()), this.getStringFilename(this.getInterpret()), this.getStringFilename(this.getAlbum()), this.getStringFilename(this.getJahr())), extension);
        return s;
    }

    private String getStringFilename(String source) {
        if (source == null) {
            return "NULL";
        }
        return source.replaceAll("[\\/:\"*?<>|]", "&").trim();
    }

    public String getInterpret() {
        return this.id3.getInterpret();
    }

    public void setInterpret(String interpret) {
        this.id3.setInterpret(interpret);
    }

    public String getTitel() {
        return this.id3.getTitel();
    }

    public void setTitel(String titel) {
        this.id3.setTitel(titel);
    }

    public String getAlbum() {
        return this.id3.getAlbum();
    }

    public void setAlbum(String album) {
        this.id3.setAlbum(album);
    }

    public String getJahr() {
        return this.id3.getJahr();
    }

    public void setJahr(String jahr) {
        this.id3.setJahr(jahr);
    }

    private void appendId3Tag(File f) {
        try {
            AudioFile audio = AudioFileIO.read(f);
            Tag tag = audio.getTagOrCreateAndSetDefault();
            tag.setField(FieldKey.ARTIST, this.getInterpret());
            tag.setField(FieldKey.ALBUM, this.getAlbum());
            tag.setField(FieldKey.TITLE, this.getTitel());
            tag.setField(FieldKey.YEAR, this.getJahr());
            audio.commit();
        }
        catch (CannotReadException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TagException e) {
            e.printStackTrace();
        }
        catch (ReadOnlyFileException e) {
            e.printStackTrace();
        }
        catch (InvalidAudioFrameException e) {
            e.printStackTrace();
        }
        catch (CannotWriteException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void skipFileExists(String skipReason) {
        ++skipDoubleCounter;
        this.saveFile = false;
        this.skipReason = skipReason;
    }

    public void skipFileError(String skipReason) {
        ++skipCounter;
        this.saveFile = false;
        this.skipReason = skipReason;
    }

    public boolean isSaveFile() {
        return this.saveFile;
    }

    public String toString() {
        String.format("Titel: '%s'  Interpret : '%s'  Album : '%s'", this.getTitel(), this.getInterpret(), this.getAlbum());
        return super.toString();
    }

    public void copyFile(File source, File destination) {
        block5: {
            FileChannel fileChannel = null;
            WritableByteChannel wc = null;
            try {
                try {
                    FileInputStream fis = new FileInputStream(source);
                    FileOutputStream fos = new FileOutputStream(destination);
                    fileChannel = fis.getChannel();
                    wc = Channels.newChannel(fos);
                    fileChannel.transferTo(0L, fileChannel.size(), wc);
                }
                catch (Exception e) {
                    log.severe("Fehler beim kopieren der Musikdatei in das Zielverzeichnis. Dateirechte pr\u00fcfen.");
                    log.throwing(this.getClass().getName(), "copyFile", e);
                    this.closeChannel(fileChannel);
                    this.closeChannel(wc);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.closeChannel(fileChannel);
                this.closeChannel(wc);
                throw throwable;
            }
            this.closeChannel(fileChannel);
            this.closeChannel(wc);
        }
    }

    private void closeChannel(Channel c) {
        try {
            c.close();
        }
        catch (IOException e) {
            log.throwing("FileStream", "closeChannel", e);
        }
    }

    public boolean equals(Object obj) {
        return this.id3.equals(obj);
    }

    public int hashCode() {
        return this.id3.hashCode();
    }

    public ID3 getId3() {
        return this.id3;
    }

    public File getNewFile() {
        return this.newFile;
    }
}

