/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.dream.webinterface.parser;

import java.lang.reflect.Constructor;
import java.util.logging.Logger;
import tsStreamRipper.dream.filestream.FileStream;
import tsStreamRipper.dream.webinterface.parser.KdEpgInfo;
import tsStreamRipper.dream.webinterface.parser.SkyRadioEpgInfo;
import tsStreamRipper.dream.webinterface.parser.SwissSatelliteRadioEpgInfo;
import tsStreamRipper.dream.webstreaming.IEitCallback;

public enum EPGType {
    SKY_RADIO("SKY Radio", SkyRadioEpgInfo.class),
    SWISS_SATELLITE_RADIO("Swiss Satellite Radio", SwissSatelliteRadioEpgInfo.class),
    KD_23_5_GRAD("KD 23,5\u00b0", KdEpgInfo.class);

    private static final Logger log;
    private String display = null;
    private Class<? extends IEitCallback> epgClass = null;

    static {
        log = Logger.getLogger(EPGType.class.getName());
    }

    public String toString() {
        return this.display;
    }

    private EPGType(String display, Class<? extends IEitCallback> epgClass) {
        this.display = display;
        this.epgClass = epgClass;
    }

    public IEitCallback getEpgParser(FileStream fs) {
        try {
            Constructor<? extends IEitCallback> constructor = this.epgClass.getConstructor(FileStream.class);
            IEitCallback epgParser = constructor.newInstance(fs);
            return epgParser;
        }
        catch (Exception e) {
            log.severe("Kann EPG Parser nicht instanziieren.");
            throw new RuntimeException(e);
        }
    }
}

