/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.dream.webinterface.parser;

import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import tsStreamRipper.dream.webinterface.parser.E2Event;
import tsStreamRipper.dream.webstreaming.IDurationCallback;
import tsStreamRipper.dream.webstreaming.IEitCallback;

public class GetCurrentParser
extends DefaultHandler {
    private static final Logger log = Logger.getLogger(GetCurrentParser.class.getName());
    private IDurationCallback duration = null;
    private IEitCallback epgCallback = null;
    private State currentState = null;
    private E2Event event = null;
    private E2Event currentEvent = null;

    public GetCurrentParser(IDurationCallback duration, IEitCallback epgCallback) {
        this.duration = duration;
        this.epgCallback = epgCallback;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentState = this.getEnumState(qName);
        if (this.currentState == null) {
            return;
        }
        switch (this.currentState) {
            case e2event: {
                this.event = new E2Event();
                break;
            }
        }
    }

    private State getEnumState(String enumName) {
        try {
            State s = State.valueOf(enumName);
            return s;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentState == null) {
            return;
        }
        switch (this.currentState) {
            case e2eventcurrenttime: {
                this.event.addE2eventcurrenttime(new String(ch, start, length));
                break;
            }
            case e2eventstart: {
                this.event.addE2eventstart(new String(ch, start, length));
                break;
            }
            case e2eventid: {
                this.event.addE2eventid(new String(ch, start, length));
                break;
            }
            case e2eventdescriptionextended: {
                this.event.addE2eventdescriptionextended(new String(ch, start, length));
                break;
            }
            case e2eventtitle: {
                this.event.addE2eventtitle(new String(ch, start, length));
                break;
            }
            case e2eventremaining: {
                this.event.addE2eventremaining(new String(ch, start, length));
                break;
            }
            case e2eventdescription: {
                this.event.adde2Eventdescription(new String(ch, start, length));
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        State endState = this.getEnumState(qName);
        if (endState == null) {
            return;
        }
        switch (endState) {
            case e2event: {
                if (this.event.isCurrentRunningEvent()) {
                    this.currentEvent = this.event;
                }
                this.event = new E2Event();
                break;
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.currentEvent != null) {
            this.duration.setDuration(this.currentEvent.getRemaining());
            this.epgCallback.setTitle(this.currentEvent.getE2eventtitle());
            this.epgCallback.setEventDescription(this.currentEvent.getE2eventdescription());
            this.epgCallback.setExtendedInfo(this.currentEvent.getE2eventdescriptionextended());
            log.info(String.format("Aktueller Stream : %s mit Restdauer von %s Sekunden.", this.currentEvent.getE2eventtitle(), this.currentEvent.getRemaining()));
        } else {
            log.warning("Keine Information \u00fcber aktuellen Stream vorhanden.");
            log.warning("Falls HTTP Authentifizierung aktiv ist, muss \"-user\" und \"-pass\" gesetzt sein!");
        }
    }

    public static enum State {
        e2eventlist,
        e2eventservicereference,
        e2event,
        e2eventid,
        e2eventstart,
        e2eventcurrenttime,
        e2eventremaining,
        e2eventdescription,
        e2eventdescriptionextended,
        e2eventtitle;

    }
}

