/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.dream.webstreaming;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Logger;

public class ObservableOutputStream
extends OutputStream {
    private static final Logger log = Logger.getLogger(ObservableOutputStream.class.getName());
    private PipedInputStream in = null;
    private PipedOutputStream outPipe = null;
    private OutputStream base = null;

    public ObservableOutputStream(OutputStream out) {
        this.base = out;
        this.in = new PipedInputStream();
        try {
            this.outPipe = new PipedOutputStream(this.in);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.base.write(b);
            this.outPipe.write(b);
        }
        catch (IOException e) {
            log.finer(e.getMessage());
        }
    }

    public InputStream getObserver() {
        return this.in;
    }
}

