/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.dream.webstreaming;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import tsStreamRipper.dream.webinterface.HttpParameter;
import tsStreamRipper.dream.webstreaming.IExceptionCallback;

public abstract class StreamBase
extends Thread {
    private HttpParameter httpParameter = null;
    private IExceptionCallback exceptionCallback = null;
    private boolean stopStreaming = false;

    public StreamBase(HttpParameter httpParameter, IExceptionCallback exceptionCallback) {
        this.httpParameter = httpParameter;
        this.exceptionCallback = exceptionCallback;
    }

    protected HttpEntity getEntity() throws Exception {
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            BasicHttpContext localContext = new BasicHttpContext();
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), new UsernamePasswordCredentials(this.httpParameter.getUser(), this.httpParameter.getPass()));
            localContext.setAttribute("http.auth.credentials-provider", credsProvider);
            HttpGet httpget = new HttpGet(this.getUrl());
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget, localContext);
            HttpEntity entity = response.getEntity();
            return entity;
        }
        catch (Exception e) {
            this.exceptionCallback.exceptionOccured(e);
            throw e;
        }
    }

    protected abstract String getUrl();

    public HttpParameter getHttpParameter() {
        return this.httpParameter;
    }

    public void stopStreamBaseThread() {
        this.stopStreaming = true;
    }

    public boolean isThreadStopping() {
        return this.stopStreaming;
    }
}

