/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.dream.webstreaming;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import tsStreamRipper.Configuration;
import tsStreamRipper.audio.ConverterFactory;
import tsStreamRipper.audio.IExternalEncoder;
import tsStreamRipper.dream.filestream.FileStream;
import tsStreamRipper.dream.webinterface.CheckStandbyCommand;
import tsStreamRipper.dream.webinterface.WebCommand;
import tsStreamRipper.dream.webinterface.ZapCommand;
import tsStreamRipper.dream.webstreaming.IDurationCallback;
import tsStreamRipper.dream.webstreaming.IExceptionCallback;
import tsStreamRipper.dream.webstreaming.StreamBase;
import tsStreamRipper.util.ByteBufferOutputStream;

public class StreamChannel
extends StreamBase
implements IDurationCallback,
IExceptionCallback {
    private static final Logger log = Logger.getLogger(StreamChannel.class.getName());
    private boolean audioStreamExists = false;
    private Configuration config = null;
    private String url = null;
    private FileStream fs = null;
    private long startSilenceDetectionTime = Long.MAX_VALUE;
    private long endSilenceDetectionTime = Long.MAX_VALUE;
    private boolean debugBuffer = false;
    private ByteBufferOutputStream bos = new ByteBufferOutputStream();
    private boolean firstSample = true;
    private long silenceRecognitionOffset = 10000L;

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void convertMp2() throws IOException {
        IExternalEncoder encoder = ConverterFactory.getEncoder(this.config.getConvOpt(), this.fs.getNewFile(), this.fs.getId3(), this.config.getTmpDir());
        encoder.startEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCompletion(WebCommand wc, String errorText) {
        try {
            WebCommand webCommand = wc;
            synchronized (webCommand) {
                wc.wait();
                if (!wc.isCommandCompleted()) {
                    throw new RuntimeException(errorText);
                }
            }
        }
        catch (InterruptedException e1) {
            this.interrupt();
            e1.printStackTrace();
        }
    }

    private void zapToChannel() {
        CheckStandbyCommand sb = new CheckStandbyCommand(this.getHttpParameter(), this);
        log.finer("checke PowerState der Dreambox ...");
        sb.start();
        this.waitForCompletion(sb, "Checken des Power-States klappt nicht ...");
        if (sb.getInStandby().booleanValue()) {
            log.info("Dreambox ist im Standby. Aufwachen ...");
            sb = new CheckStandbyCommand(this.getHttpParameter(), this, true);
            sb.start();
            this.waitForCompletion(sb, "Aufwachen der Dreambox klappt nicht ...");
        }
        ZapCommand zap = new ZapCommand(this.getHttpParameter(), this, this.config.getChannel());
        zap.start();
        this.waitForCompletion(zap, "Umschalten auf den aufzunehmenden Kanal klappt nicht ...");
    }

    public StreamChannel(IExceptionCallback exceptionCallback, Configuration config) throws FileNotFoundException {
        super(config.getHttpParameter(), exceptionCallback);
        this.config = config;
        this.url = String.format("http://%s:%d/%s", config.getHttpParameter().getHost(), config.getHttpParameter().getPort(), config.getChannel());
        this.printInfo();
    }

    private void printInfo() {
        log.info(String.format("Stream wird geholt von : http://%s:%d", this.config.getHttpParameter().getHost(), this.config.getHttpParameter().getPort()));
        log.info(String.format("ChannelId des Streams : %s", this.config.getChannel()));
        log.info(String.format("EPG Type des Streams : %s", new Object[]{this.config.getEpgType()}));
        log.info(String.format("Vollstaendig gestreamte MP2-Dateien werden in das Verzeichnis '%s' kopiert.", this.config.getDestination().getAbsolutePath()));
        if (this.config.getConvOpt() != null) {
            if (this.config.getConvOpt().getType().equals((Object)ConverterFactory.ConverterType.AAC)) {
                log.info("Konvertierung zu m4a : Ja.");
                log.info(String.format("Pfad auf faac-encoder : '%s'", this.config.getConvOpt().getConverterPath().getAbsolutePath()));
                log.info(String.format("Loeschen orginaler MP2-Dateien : %s", this.config.getConvOpt().isRemoveOriginalFile()));
            } else if (this.config.getConvOpt().getType().equals((Object)ConverterFactory.ConverterType.MP3)) {
                log.info("Konvertierung zu MP3-Datei : Ja.");
                log.info(String.format("Pfad auf lame-encoder : '%s'", this.config.getConvOpt().getConverterPath().getAbsolutePath()));
                log.info(String.format("Loeschen orginaler MP2-Dateien : %s", this.config.getConvOpt().isRemoveOriginalFile()));
            } else {
                log.severe("Konvertierungstyp unbekannt : " + this.config.getConvOpt().getType().toString());
            }
        } else {
            log.info("Konvertierung zu m4a oder mp3 : Nein");
        }
        log.info(String.format("Restdauerkorrektur f\u00fcr Musikende in Sekunden : %s", this.config.getRestdauerKorrektur()));
        log.info("\u00dcberschreibe existierende Dateien : " + Boolean.toString(this.config.isOverwriteFiles()));
        log.info(String.format("Temporaere Dateien werden im Verzeichnis '%s' abgelegt", this.config.getTmpDir().getAbsolutePath()));
        log.info(this.config.getNameFormatter().info());
        log.info("Falls eine Datei nicht erstellt wird, werden Statusinformation ueber die Anzahl der (gerippten/doppelten/beschaedigten) Dateien seit Programmstart angegeben.");
    }

    @Override
    protected String getUrl() {
        return this.url;
    }

    @Override
    public void setDuration(int sec) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Restlauzeit des aktuellen Musikst\u00fccks in Sekunden : " + sec);
        }
        long endeNachEpg = System.currentTimeMillis() + (long)((sec + this.config.getRestdauerKorrektur()) * 1000);
        this.startSilenceDetectionTime = endeNachEpg - this.silenceRecognitionOffset;
        this.endSilenceDetectionTime = endeNachEpg + this.silenceRecognitionOffset;
    }

    @Override
    public void exceptionOccured(Exception e) {
        log.severe("Verbindung zur Dreambox vermutlich gest\u00f6rt.");
        this.stopStreamBaseThread();
    }
}

