/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.mp3;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import tsStreamRipper.mp3.SilenceRecognitionBuffer;
import tsStreamRipper.util.ByteBufferInputStream;

public class SilenceRecognitionStream
extends Thread {
    private static final Logger log = Logger.getLogger(SilenceRecognitionStream.class.getName());
    private int schwelle = 10;
    private int samples = 11;
    private ByteBuffer byteBuffer = null;
    private ByteBuffer lastSongEnd = null;
    private boolean hasSilence = false;
    private int maxPass = 10;

    public SilenceRecognitionStream(ByteBuffer buffer) {
        this.byteBuffer = buffer;
        this.byteBuffer.flip();
        this.setName("SilenceRecognition Thread");
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        int pass = 0;
        if (log.isLoggable(Level.FINE)) {
            log.fine("SilenceBuffer limit  : " + this.byteBuffer.limit());
        }
        while (!this.hasSilence && pass < this.maxPass) {
            this.byteBuffer.position(0);
            Bitstream stream = new Bitstream(new ByteBufferInputStream(this.byteBuffer));
            Decoder decoder = new Decoder();
            SilenceRecognitionBuffer buffer = new SilenceRecognitionBuffer(this.schwelle, this.samples);
            decoder.setOutputBuffer(buffer);
            while (!this.hasSilence) {
                try {
                    Header header = stream.readFrame();
                    if (header == null) {
                        log.finer("Buffer bis zum Ende gelesen.");
                        break;
                    }
                    buffer = (SilenceRecognitionBuffer)decoder.decodeFrame(header, stream);
                    stream.closeFrame();
                    if (!buffer.isSilence()) continue;
                    log.finer("Silence detected");
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(String.format("Silence-End Position : %d ", this.byteBuffer.position()));
                    }
                    this.lastSongEnd = this.byteBuffer.duplicate();
                    this.lastSongEnd.position(this.byteBuffer.position()).limit(this.byteBuffer.position());
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(String.format("Last Song cutPosition : %d ", this.lastSongEnd.limit()));
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine(String.format("Pass : %d , Schwelle : %d , Samples : %d, Position : %d ", pass, this.schwelle, this.samples, this.byteBuffer.position()));
                    }
                    this.hasSilence = true;
                }
                catch (Exception e) {
                    log.severe("Stilleerkennung: Fehler beim dekodieren des Streams. M\u00f6glicherweise ist die SAT-Sch\u00fcssel schlecht ausgerichtet oder es liegt Schnee drauf.");
                    break;
                }
            }
            this.schwelle += 10;
            if (pass % 2 == 1) {
                --this.samples;
            }
            this.samples = Math.max(this.samples, 6);
            ++pass;
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine(String.format("N\u00e4chster Stille-Test mit folgenden Parametern : Pass '%d', Schwelle '%d', Samples '%d'", pass, this.schwelle, this.samples));
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("SilenceDetectionTime %d [ms]", duration));
        }
        if (duration > 2000L) {
            log.warning("Stilleerknnung l\u00e4uft sehr lange : " + duration + " [ms].");
        }
    }

    public ByteBuffer getLastSongEnd() {
        return this.lastSongEnd;
    }

    public boolean hasSilence() {
        return this.hasSilence;
    }
}

