/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.mpeg;

import java.util.logging.Logger;

public class MPEG2PESHeader {
    private static final Logger log = Logger.getLogger(MPEG2PESHeader.class.getName());
    private byte[] data = null;
    private int headerOffset = 6;

    public MPEG2PESHeader(byte[] header) {
        this.data = header;
        if (header[0] != 0 || header[1] != 0 || header[2] != 1) {
            log.warning("PES Header invalid ... Should start with 0x00 0x00 0x01.");
        }
    }

    public int getSize() {
        return ((0xFF & this.data[4]) << 8) + (0xFF & this.data[5]);
    }

    public int getType() {
        return 0xFF & this.data[3];
    }

    public boolean isMetaStreamPacket() {
        return (0xE0 & this.getType()) == 224 || (0xE0 & this.getType()) == 192;
    }

    public boolean isVideoPacket() {
        return (0xE0 & this.getType()) == 224;
    }

    public boolean isAudioPacket() {
        return (0xE0 & this.getType()) == 192;
    }

    public boolean hasPTS() {
        return this.data != null && this.getSize() > 0 && (0x80 & this.data[this.headerOffset + 1]) > 0;
    }

    public boolean hasDTS() {
        return this.data != null && this.getSize() > 0 && (0x40 & this.data[this.headerOffset + 1]) > 0;
    }

    public long getPTS() {
        if ((0x80 & this.data[this.headerOffset + 1]) > 0) {
            return 0xFFFFFFFFL & (0xEL & (long)this.data[this.headerOffset + 3]) << 28 | (0xFFL & (long)this.data[this.headerOffset + 4]) << 22 | (0xFEL & (long)this.data[this.headerOffset + 5]) << 14 | (0xFFL & (long)this.data[this.headerOffset + 6]) << 7 | (long)((0xFE & this.data[this.headerOffset + 7]) >>> 1);
        }
        return 0L;
    }

    public long getDTS() {
        if ((0x80 & this.data[this.headerOffset + 1]) > 0) {
            return 0xFFFFFFFFL & (0xEL & (long)this.data[this.headerOffset + 8]) << 28 | (0xFFL & (long)this.data[this.headerOffset + 9]) << 22 | (0xFEL & (long)this.data[this.headerOffset + 10]) << 14 | (0xFFL & (long)this.data[this.headerOffset + 11]) << 7 | (long)((0xFE & this.data[this.headerOffset + 12]) >>> 1);
        }
        return 0L;
    }

    public String info() {
        StringBuilder sb = new StringBuilder();
        if (this.isAudioPacket()) {
            sb.append("AUDIO ");
            if (this.hasPTS()) {
                sb.append("PTS");
            }
            if (this.hasDTS()) {
                sb.append("DTS");
            }
        } else if (this.isVideoPacket()) {
            sb.append("VIDEO");
        } else {
            sb.append("UNKNOWN");
        }
        return sb.toString();
    }
}

