/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.mpeg;

import java.io.IOException;
import java.util.logging.Logger;
import mpeg2demux.MPEG2PESPacket;

public class MPEG2PESPacketExt
extends MPEG2PESPacket {
    private static final Logger log = Logger.getLogger(MPEG2PESPacketExt.class.getName());
    private int PES_SIZE = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MPEG2PESPacketExt(byte[] PESdata) throws IOException {
        if (PESdata[0] != 0 || PESdata[1] != 0 || PESdata[2] != 1) throw new IOException("Invalid PES HEADER.");
        int streamId = 0xFF & PESdata[3];
        if ((streamId & 0xE0) != 224 && (streamId & 0xE0) != 192) throw new IOException("Unknown STREAM-ID");
        this.setType(streamId);
        this.PES_SIZE = ((0xFF & PESdata[4]) << 8) + (0xFF & PESdata[5]);
        this.data = new byte[this.PES_SIZE];
        if (this.PES_SIZE != PESdata.length - 6) {
            log.warning("PES SIZE differs from data Size : " + this.PES_SIZE + " / " + (PESdata.length - 6));
            this.PES_SIZE = Math.min(PESdata.length, this.PES_SIZE) - 6;
        }
        System.arraycopy(PESdata, 6, this.data, 0, this.PES_SIZE);
        this.size = this.PES_SIZE;
    }

    public int getPesSize() {
        return this.PES_SIZE;
    }
}

