/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.mpeg;

import tsStreamRipper.util.UnsignedByteArray;

public class MPEG2TransportPacketHeader {
    private UnsignedByteArray ba = null;

    public MPEG2TransportPacketHeader() {
    }

    public MPEG2TransportPacketHeader(UnsignedByteArray ba) {
        this.ba = ba;
    }

    private boolean isBitSet(int bitmap, int bitnummer) {
        int base = 1;
        int i = 0;
        while (i < bitnummer) {
            base <<= 1;
            ++i;
        }
        return (bitmap & base) != 0;
    }

    public String info() {
        StringBuilder sb = new StringBuilder();
        sb.append("SYNC      : ").append(this.getSyncByteExists()).append("\r\n");
        sb.append("TRANERR   : ").append(this.getTransportError()).append("\r\n");
        sb.append("ADAPFIELD : ").append(this.getAdaptionFieldExists()).append("\r\n");
        sb.append("PAYSTART  : ").append(this.getPayloadStart()).append("\r\n");
        sb.append("PAYEXISTS : ").append(this.getPayloadExists()).append("\r\n");
        sb.append("SCRAM      : ").append(this.getScrambeled());
        return sb.toString();
    }

    public boolean getSyncByteExists() {
        return this.ba.valueAt(0) == 71;
    }

    public boolean getTransportError() {
        return this.isBitSet(this.ba.valueAt(1), 7);
    }

    public boolean getAdaptionFieldExists() {
        return this.isBitSet(this.ba.valueAt(3), 5);
    }

    public boolean getPayloadExists() {
        return this.isBitSet(this.ba.valueAt(3), 4);
    }

    public boolean getPayloadStart() {
        return this.isBitSet(this.ba.valueAt(1), 6);
    }

    public boolean getScrambeled() {
        return !this.isBitSet(this.ba.valueAt(3), 6) && !this.isBitSet(this.ba.valueAt(3), 7);
    }

    public int getPID() {
        int l = this.ba.valueAt(1) & 0x1F00;
        return l += this.ba.valueAt(2);
    }

    public TransportPacketType getTransportPacketType() {
        if (this.getAdaptionFieldExists() && this.getPayloadExists()) {
            return TransportPacketType.ADAPTION_FIELD_AND_PACKETIZED_ELEMENTRY_STREAM;
        }
        if (this.getAdaptionFieldExists()) {
            return TransportPacketType.ADAPTION_FIELD;
        }
        if (this.getPayloadExists()) {
            return TransportPacketType.PACKETIZED_ELEMENTRY_STREAM;
        }
        return TransportPacketType.UNKNOWN;
    }

    public String toString() {
        return this.info();
    }

    public static enum TransportPacketType {
        PACKETIZED_ELEMENTRY_STREAM,
        ADAPTION_FIELD,
        ADAPTION_FIELD_AND_PACKETIZED_ELEMENTRY_STREAM,
        SECTION,
        UNKNOWN;

    }
}

