/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.mpeg;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tsStreamRipper.mpeg.ITransportPacketListener;
import tsStreamRipper.mpeg.MPEG2PESHeader;
import tsStreamRipper.mpeg.MPEG2TransportPacketHeader;
import tsStreamRipper.mpeg.elementarystream.ElementaryStream;
import tsStreamRipper.mpeg.elementarystream.IgnoreElementaryStream;
import tsStreamRipper.mpeg.elementarystream.OutputElementaryStream;
import tsStreamRipper.mpeg.elementarystream.PatElementaryStream;
import tsStreamRipper.util.UnsignedByteArray;

public class MPEG2TransportStreamDemultiplexer
implements ITransportPacketListener {
    private static final Logger log = Logger.getLogger(MPEG2TransportStreamDemultiplexer.class.getName());
    private UnsignedByteArray tsFrame = new UnsignedByteArray();
    private MPEG2TransportPacketHeader mpegHeader = new MPEG2TransportPacketHeader(this.tsFrame);
    private Map<Long, ElementaryStream> streams = new HashMap<Long, ElementaryStream>();
    private OutputStream audioOut = null;

    public MPEG2TransportStreamDemultiplexer(OutputStream audio) {
        this.audioOut = audio;
    }

    @Override
    public void transportPackedReceived(byte[] tsPacket) throws IOException {
        this.tsFrame.setWrappedByteArray(tsPacket);
        int pid = this.mpegHeader.getPID();
        boolean payLoadStart = this.mpegHeader.getPayloadStart();
        if (pid == 8191) {
            return;
        }
        ElementaryStream esHandler = null;
        switch (this.mpegHeader.getTransportPacketType()) {
            case PACKETIZED_ELEMENTRY_STREAM: {
                esHandler = this.getHandler(pid, tsPacket);
                if (esHandler == null) break;
                esHandler.handlePacket(this.getPesData(tsPacket, 0), payLoadStart);
                break;
            }
            case ADAPTION_FIELD_AND_PACKETIZED_ELEMENTRY_STREAM: {
                esHandler = this.getHandler(pid, tsPacket);
                if (esHandler == null) break;
                byte[] adaptionField = this.getAdaptionField();
                esHandler.handleAdaptionField(adaptionField);
                esHandler.handlePacket(this.getPesData(tsPacket, adaptionField.length), payLoadStart);
                break;
            }
            case SECTION: {
                break;
            }
            case ADAPTION_FIELD: {
                break;
            }
        }
    }

    private byte[] getAdaptionField() {
        int adaptionFieldSize = this.tsFrame.valueAt(4) + 1;
        byte[] b = new byte[adaptionFieldSize];
        System.arraycopy(this.tsFrame.getWrappedData(), 4, b, 0, adaptionFieldSize);
        return b;
    }

    private ElementaryStream getHandler(long pid, byte[] tsPacket) {
        ElementaryStream handler = this.streams.get(pid);
        if (handler == null) {
            if (this.mpegHeader.getPayloadStart()) {
                MPEG2PESHeader pesHeader = new MPEG2PESHeader(this.getPesDataHeader(tsPacket));
                handler = pid == 0L ? new PatElementaryStream(pid) : (pesHeader.isAudioPacket() && pesHeader.hasPTS() ? new OutputElementaryStream(pid, ElementaryStream.StreamType.AUDIO, this.audioOut) : new IgnoreElementaryStream(pid));
                this.streams.put(pid, handler);
                if (log.isLoggable(Level.FINE)) {
                    if (pid == 0L) {
                        log.fine("PAT-Stream auf pid 0 vorhanden ...");
                    } else {
                        log.fine(String.format("Elementary Stream auf pid %s vom Type %s", pid, pesHeader.info()));
                    }
                }
                return handler;
            }
            if (log.isLoggable(Level.FINER)) {
                log.finer("Ueberspringe Transport Packet bis payload beginnt auf PID : " + pid);
            }
            return null;
        }
        return handler;
    }

    public OutputElementaryStream getAudioElementaryStream() {
        for (ElementaryStream es : this.streams.values()) {
            if (!es.getType().equals((Object)ElementaryStream.StreamType.AUDIO)) continue;
            return (OutputElementaryStream)es;
        }
        return null;
    }

    private byte[] getPesData(byte[] tsFrame, int adaptionFieldSize) {
        int pesSegmentSize = 184 - adaptionFieldSize;
        byte[] b = new byte[pesSegmentSize];
        System.arraycopy(tsFrame, 4 + adaptionFieldSize, b, 0, pesSegmentSize);
        return b;
    }

    private byte[] getPesDataHeader(byte[] tsFrame) {
        byte[] b = new byte[20];
        System.arraycopy(tsFrame, 4, b, 0, 16);
        return b;
    }
}

