/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.mpeg;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.ConnectionClosedException;
import tsStreamRipper.mpeg.ITransportPacketListener;

public class MPEG2TransportStreamReader {
    private static final Logger log = Logger.getLogger(MPEG2TransportStreamReader.class.getName());
    public static final int TRANSPORT_PACKET_SIZE = 188;
    public static final int TRANSPORT_PACKET_HEADER_SIZE = 4;
    private byte[] tsFrame = new byte[188];
    private byte[] syncFrame = new byte[376];
    private boolean syncFrameDrained = false;
    private int drainPosition = 0;
    private List<ITransportPacketListener> listener = new ArrayList<ITransportPacketListener>();
    private InputStream is = null;
    private boolean isSynced = false;

    public MPEG2TransportStreamReader(InputStream is, ITransportPacketListener listener) {
        this.is = is;
        this.addListener(listener);
    }

    public boolean decodeNextFrame() throws IOException {
        this.readNextFrame();
        byte[] frame = new byte[188];
        System.arraycopy(this.tsFrame, 0, frame, 0, 188);
        for (ITransportPacketListener aListener : this.listener) {
            aListener.transportPackedReceived(frame);
        }
        return true;
    }

    private int readNextFrame() throws IOException {
        if (!this.isSynced) {
            if (log.isLoggable(Level.INFO)) {
                log.info("synchronisiere Transportstrom. Dabei kann es zu Warnmeldungen kommen.");
            }
            this.sync();
            if (!this.isSynced) {
                log.severe("Transportstrom l\u00e4\u00dft sich nicht synchronisieren!");
                throw new ConnectionClosedException("cannot sync. Maybe this is not a TransportStream");
            }
        } else if (!this.syncFrameDrained) {
            System.arraycopy(this.syncFrame, 0, this.tsFrame, 0, 188);
            int bytesRead = this.readBytesIntoBuffer(this.is, this.tsFrame, this.drainPosition, 188 - this.drainPosition);
            if (bytesRead == -1) {
                log.severe("Stream closed");
                throw new ConnectionClosedException("stream closed while syncing frame");
            }
            this.syncFrameDrained = true;
        } else {
            int bytesRead = this.readBytesIntoBuffer(this.is, this.tsFrame);
            if (bytesRead == -1) {
                log.info("Transportsstrom geschlossen ...");
                throw new ConnectionClosedException("stream closed.");
            }
            if (bytesRead < 188) {
                log.warning("Buffer underrun. Stream is probably closing ...");
            }
        }
        if ((this.tsFrame[0] & 0xFF) != 71) {
            log.warning("Stream corrupt. SYNC lost. Trying to resync.");
            this.isSynced = false;
            this.readNextFrame();
        }
        return 188;
    }

    private boolean sync() throws IOException {
        this.isSynced = false;
        this.syncFrameDrained = false;
        this.readBytesIntoBuffer(this.is, this.syncFrame);
        HashSet<Integer> syncPoints = new HashSet<Integer>();
        int i = 0;
        while (i < this.syncFrame.length) {
            if (this.syncFrame[i] == 71) {
                for (Integer sp : syncPoints) {
                    if (sp + 188 != i) continue;
                    this.isSynced = true;
                    if (log.isLoggable(Level.FINER)) {
                        log.finer("TransportPacket is synced at stream position : " + sp);
                    }
                    System.arraycopy(this.syncFrame, sp, this.tsFrame, 0, 188);
                    byte[] tmpFrame = new byte[188];
                    this.drainPosition = 188 - sp;
                    System.arraycopy(this.syncFrame, sp + 188, tmpFrame, 0, this.drainPosition);
                    System.arraycopy(tmpFrame, 0, this.syncFrame, 0, this.drainPosition);
                    return true;
                }
                syncPoints.add(i);
            }
            ++i;
        }
        return false;
    }

    private int readBytesIntoBuffer(InputStream is, byte[] buffer) throws IOException {
        return this.readBytesIntoBuffer(is, buffer, 0, buffer.length);
    }

    private int readBytesIntoBuffer(InputStream is, byte[] buffer, int pos, int length) throws IOException {
        int count = is.read(buffer, pos, length);
        if (count == -1) {
            return -1;
        }
        count += pos;
        while (count < buffer.length) {
            int br = is.read(buffer, count, buffer.length - count);
            if (br == -1) {
                log.warning("Last message before STREAM CLOSED : " + new String(buffer));
                throw new IOException("STREAM CLOSED AT FRAME POS : " + count);
            }
            count += br;
        }
        return count;
    }

    public void addListener(ITransportPacketListener listener) {
        this.listener.add(listener);
    }

    public void removeListener(ITransportPacketListener listener) {
        this.listener.remove(listener);
    }
}

