/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.mpeg.elementarystream;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;

public abstract class ElementaryStream {
    private static final Logger log = Logger.getLogger(ElementaryStream.class.getName());
    private long pid = 0L;
    int errorCnt = 0;
    private StreamType type = null;
    private boolean isSynced = false;
    private int currentpos = 0;
    private byte[] elementaryFrameBuffer = new byte[65536];

    public ElementaryStream(long pid, StreamType type) {
        this.pid = pid;
        this.type = type;
    }

    public void handleAdaptionField(byte[] adaptionField) {
    }

    public void handlePacket(byte[] pesFrame, boolean payloadStart) throws IOException {
        if (!this.isSynced) {
            if (payloadStart) {
                this.isSynced = true;
            } else {
                log.info("synchronisiere PES Packet ...");
                return;
            }
        }
        if (payloadStart) {
            byte[] reassembeldPesPacket = new byte[this.currentpos];
            System.arraycopy(this.elementaryFrameBuffer, 0, reassembeldPesPacket, 0, this.currentpos);
            this.handleCompletePacket(reassembeldPesPacket);
            this.currentpos = 0;
            Arrays.fill(this.elementaryFrameBuffer, (byte)0);
        }
        System.arraycopy(pesFrame, 0, this.elementaryFrameBuffer, this.currentpos, pesFrame.length);
        this.currentpos += pesFrame.length;
    }

    private void handleCompletePacket(byte[] reassembeldPesPacket) {
        if (reassembeldPesPacket.length < 3) {
            log.warning("PES Packet is leer ...");
            return;
        }
        if (reassembeldPesPacket[0] == 0 && reassembeldPesPacket[1] == 0 && reassembeldPesPacket[2] == 1) {
            try {
                this.handleCompletePESPacket(reassembeldPesPacket);
                this.errorCnt = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (reassembeldPesPacket[0] == 0) {
            try {
                this.handleCompletePSIPacket(reassembeldPesPacket);
                this.errorCnt = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.warning("PSI Packet kann nicht verarbeitet werden ...");
            }
        } else {
            ++this.errorCnt;
            log.warning("Kein PES Payload gefunden ...");
        }
        if (this.errorCnt > 10) {
            log.severe("PES Payload vermutlich verschl\u00fcsselt. Bitte CAM/Karte pr\u00fcfen.");
            throw new RuntimeException("PES Payload vermutlich verschl\u00fcsselt. Bitte CAM/Karte pr\u00fcfen.");
        }
    }

    public long getPid() {
        return this.pid;
    }

    public StreamType getType() {
        return this.type;
    }

    protected abstract void handleCompletePESPacket(byte[] var1) throws IOException;

    protected abstract void handleCompletePSIPacket(byte[] var1) throws IOException;

    public static enum StreamType {
        AUDIO,
        VIDEO,
        PSI;

    }
}

