/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.mpeg.elementarystream;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import mpeg2demux.MPEG2StreamDemuxer;
import tsStreamRipper.mpeg.MPEG2PESPacketExt;
import tsStreamRipper.mpeg.elementarystream.ElementaryStream;

public class OutputElementaryStream
extends ElementaryStream {
    private static final Logger log = Logger.getLogger(OutputElementaryStream.class.getName());
    private MPEG2StreamDemuxer demuxer = new MPEG2StreamDemuxer();

    public OutputElementaryStream(long pid, ElementaryStream.StreamType type, OutputStream os) {
        super(pid, type);
        this.setOutputStream(os);
    }

    @Override
    protected void handleCompletePESPacket(byte[] pesPacket) throws IOException {
        MPEG2PESPacketExt packet = new MPEG2PESPacketExt(pesPacket);
        this.demuxer.onPacketReceive(packet, 0L, null);
    }

    @Override
    protected void handleCompletePSIPacket(byte[] psiPacket) throws IOException {
        log.warning("cannot handle PSI data");
    }

    public void setOutputStream(OutputStream out) {
        this.demuxer.setAudioOut(new BufferedOutputStream(out));
    }
}

