/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.mpeg.section.pat;

import java.util.ArrayList;
import java.util.List;
import tsStreamRipper.mpeg.section.pat.PatListEntry;
import tsStreamRipper.util.BitCoder;

public class Pat {
    private int table_id;
    private int pointer_field;
    private int section_syntax_indicator;
    private int reserved_1;
    private int section_length;
    private int transport_stream_id;
    private int reserved_2;
    private int version_number;
    private int current_next_indicator;
    private int section_number;
    private int last_section_number;
    private BitCoder bc = new BitCoder();
    private List<PatListEntry> patList = new ArrayList<PatListEntry>();

    public Pat(byte[] b) {
        this.pointer_field = b[0];
        this.table_id = b[1];
        this.section_syntax_indicator = this.bc.getBits(b, 1, 8, 1);
        this.reserved_1 = this.bc.getBits(b, 1, 10, 2);
        this.section_length = this.bc.getBits(b, 1, 12, 12);
        this.transport_stream_id = this.bc.getBits(b, 1, 24, 16);
        this.reserved_2 = this.bc.getBits(b, 1, 40, 2);
        this.version_number = this.bc.getBits(b, 1, 42, 5);
        this.current_next_indicator = this.bc.getBits(b, 1, 47, 1);
        this.section_number = this.bc.getBits(b, 1, 48, 8);
        this.last_section_number = this.bc.getBits(b, 1, 56, 8);
        int posistion = 9;
        while ((b[posistion] & 0xFF) != 255 && posistion <= b.length - 5) {
            this.patList.add(new PatListEntry(b, posistion * 8));
            posistion += 4;
        }
    }

    public String info() {
        StringBuilder sb = new StringBuilder();
        sb.append("");
        sb.append("PAT-Table. Lists : ").append((this.section_length - 12) / 4).append("\r\n");
        sb.append("======================================================\r\n");
        sb.append("TABLE_ID                 : ").append(this.table_id);
        if (this.table_id != 0) {
            sb.append(" ERROR. Should be 0x00");
        }
        sb.append("\r\n");
        sb.append("section length           : ").append(this.section_length).append("\r\n");
        sb.append("section number           : ").append(this.section_number).append("\r\n");
        sb.append("last section number      : ").append(this.last_section_number).append("\r\n");
        sb.append("section syntax indicator : ").append(this.section_syntax_indicator).append("\r\n");
        sb.append("current_next indicator   : ").append(this.current_next_indicator).append("\r\n");
        sb.append("transport stream ID      : ").append(this.transport_stream_id).append("\r\n");
        for (PatListEntry entry : this.patList) {
            sb.append(entry.info()).append("\r\n");
        }
        return sb.toString();
    }
}

