/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.io.UnsupportedEncodingException;

public class ByteOps {
    private static String JAVA_CODE_PAGE = "ISO-8859-1";

    public static final Object convertByteArrayToObject(byte[] data) throws ClassNotFoundException, StreamCorruptedException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object o = ois.readObject();
            ois.close();
            return o;
        }
        catch (StreamCorruptedException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
    }

    public static String printHex(byte[] ba) {
        StringBuffer sb = new StringBuffer(5 * ba.length + 20);
        int i = 0;
        while (i < ba.length) {
            if (i % 16 == 0) {
                sb.append(String.valueOf(Integer.toHexString(i & 0xFFFF | 0x10000).substring(1, 5)) + " - ");
            }
            sb.append(String.valueOf(Integer.toHexString(ba[i] & 0xFF | 0x100).substring(1, 3)) + " ");
            if (i % 16 == 15 || i == ba.length - 1) {
                int j = 16 - i % 16;
                while (j > 1) {
                    sb.append("   ");
                    --j;
                }
                sb.append(" - ");
                int start = i / 16 * 16;
                int end = ba.length < i + 1 ? ba.length : i + 1;
                j = start;
                while (j < end) {
                    if (ba[j] >= 32 && ba[j] <= 126) {
                        sb.append((char)ba[j]);
                    } else {
                        sb.append(".");
                    }
                    ++j;
                }
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }

    public static String printHex(String quelle) {
        return ByteOps.printHex(ByteOps.zuByteArrayMitIsoCodePage(quelle));
    }

    public static byte[] zuByteArrayMitIsoCodePage(String quelle) {
        try {
            return quelle.getBytes(JAVA_CODE_PAGE);
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }
}

