/*
 * Decompiled with CFR 0.152.
 */
package tsStreamRipper.util;

public class SimpleStringTokenizer {
    private CharSequence currentString = null;
    private char currentDelim = (char)58;
    private int currentPos = 0;
    private int currentMaxLength = 0;
    private boolean moreTokens = true;

    public SimpleStringTokenizer(CharSequence currentString, char currentDelim) {
        this.currentDelim = currentDelim;
        this.currentString = currentString;
        this.postInit();
    }

    public void setCurrentDelim(char currentDelim) {
        this.currentDelim = currentDelim;
        this.postInit();
    }

    public void setCurrentString(CharSequence currentString) {
        this.currentString = currentString;
        this.postInit();
    }

    private void postInit() {
        this.currentPos = 0;
        if (this.currentString != null) {
            this.currentMaxLength = this.currentString.length();
            this.moreTokens = true;
        } else {
            this.currentMaxLength = 0;
            this.moreTokens = false;
        }
    }

    public CharSequence nextToken() {
        if (this.currentString == null) {
            return null;
        }
        int i = this.currentPos;
        while (i < this.currentMaxLength) {
            if (this.currentString.charAt(i) == this.currentDelim) {
                CharSequence result = this.currentString.subSequence(this.currentPos, i);
                if (i < this.currentMaxLength) {
                    this.currentPos = i + 1;
                }
                return result;
            }
            ++i;
        }
        this.moreTokens = false;
        int cp = this.currentPos;
        this.currentPos = this.currentMaxLength;
        return this.currentString.subSequence(cp, this.currentMaxLength);
    }

    public boolean hasMoreTokens() {
        return this.moreTokens;
    }
}

