package gui;

import gui.ApplicationConfigHandler.BoxType;
import gui.ApplicationConfigHandler.Converter;

public class ApplicationConfig implements IApplicationConfig
{
    private String host = "";
    private String port = "8001";
    private String webport = "80";
    private String username = "";
    private String passwort = "";
    private BoxType boxType = BoxType.SAT;
    private String tmpDir = "";
    private Converter converter = Converter.KEINE_KONVERTIERUNG;
    private String faacPath = "";
    private String lamePath = "";
    private boolean removeOriginalAfterConvert = true;
    private boolean overwrite = false;
    private boolean verbose = false;
    private boolean switchFilename = false;
    private String restdauerKorrektur = "20";

    private String musicFreieAuswahl = "";
    private String music60er70er = "";
    private String music80er90er = "";
    private String musicCountry = "";
    private String musicDeutscheCharts = "";
    private String musicLovesongs = "";
    private String musicRnbHiphop = "";
    private String musicRockHymnen = "";

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#getHost()
     */
    public String getHost()
    {
        return host;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setHost(java.lang.String)
     */
    public void setHost(String host)
    {
        this.host = host;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#getPort()
     */
    public String getPort()
    {
        return port;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setPort(java.lang.String)
     */
    public void setPort(String port)
    {
        this.port = port;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#getUsername()
     */
    public String getUsername()
    {
        return username;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setUsername(java.lang.String)
     */
    public void setUsername(String username)
    {
        this.username = username;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#getPasswort()
     */
    public String getPasswort()
    {
        return passwort;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setPasswort(java.lang.String)
     */
    public void setPasswort(String passwort)
    {
        this.passwort = passwort;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#getBoxType()
     */
    public BoxType getBoxType()
    {
        return boxType;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setBoxType(gui.ApplicationConfig.BoxType)
     */
    public void setBoxType(BoxType boxType)
    {
        this.boxType = boxType;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#getTmpDir()
     */
    public String getTmpDir()
    {
        return tmpDir;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setTmpDir(java.lang.String)
     */
    public void setTmpDir(String tmpDir)
    {
        this.tmpDir = tmpDir;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#getConverter()
     */
    public Converter getConverter()
    {
        return converter;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setConverter(gui.ApplicationConfig.Converter)
     */
    public void setConverter(Converter converter)
    {
        this.converter = converter;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#getFaacPath()
     */
    public String getFaacPath()
    {
        return faacPath;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setFaacPath(java.lang.String)
     */
    public void setFaacPath(String faacPath)
    {
        this.faacPath = faacPath;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#getLamePath()
     */
    public String getLamePath()
    {
        return lamePath;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setLamePath(java.lang.String)
     */
    public void setLamePath(String lamePath)
    {
        this.lamePath = lamePath;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#isOverwrite()
     */
    public boolean isOverwrite()
    {
        return overwrite;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setOverwrite(boolean)
     */
    public void setOverwrite(boolean overwrite)
    {
        this.overwrite = overwrite;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#isVerbose()
     */
    public boolean isVerbose()
    {
        return verbose;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setVerbose(boolean)
     */
    public void setVerbose(boolean verbose)
    {
        this.verbose = verbose;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#isSwitchFilename()
     */
    public boolean isSwitchFilename()
    {
        return switchFilename;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setSwitchFilename(boolean)
     */
    public void setSwitchFilename(boolean switchFilename)
    {
        this.switchFilename = switchFilename;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#getMusic60er70er()
     */
    public String getMusic60er70er()
    {
        return music60er70er;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setMusic60er70er(java.lang.String)
     */
    public void setMusic60er70er(String music60er70er)
    {
        this.music60er70er = music60er70er;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#getMusic80er90er()
     */
    public String getMusic80er90er()
    {
        return music80er90er;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setMusic80er90er(java.lang.String)
     */
    public void setMusic80er90er(String music80er90er)
    {
        this.music80er90er = music80er90er;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#getMusicCountry()
     */
    public String getMusicCountry()
    {
        return musicCountry;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setMusicCountry(java.lang.String)
     */
    public void setMusicCountry(String musicCountry)
    {
        this.musicCountry = musicCountry;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#getMusicDeutscheCharts()
     */
    public String getMusicDeutscheCharts()
    {
        return musicDeutscheCharts;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setMusicDeutscheCharts(java.lang.String)
     */
    public void setMusicDeutscheCharts(String musicDeutscheCharts)
    {
        this.musicDeutscheCharts = musicDeutscheCharts;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#getMusicLovesongs()
     */
    public String getMusicLovesongs()
    {
        return musicLovesongs;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setMusicLovesongs(java.lang.String)
     */
    public void setMusicLovesongs(String musicLovesongs)
    {
        this.musicLovesongs = musicLovesongs;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#getMusicRnbHiphop()
     */
    public String getMusicRnbHiphop()
    {
        return musicRnbHiphop;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setMusicRnbHiphop(java.lang.String)
     */
    public void setMusicRnbHiphop(String musicRnbHiphop)
    {
        this.musicRnbHiphop = musicRnbHiphop;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#getMusicRockHymnen()
     */
    public String getMusicRockHymnen()
    {
        return musicRockHymnen;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IApplicationConfig#setMusicRockHymnen(java.lang.String)
     */
    public void setMusicRockHymnen(String musicRockHymnen)
    {
        this.musicRockHymnen = musicRockHymnen;
    }

    public String getMusicFreieAuswahl()
    {
        return musicFreieAuswahl;
    }

    public void setMusicFreieAuswahl(String musicFreieAuswahl)
    {
        this.musicFreieAuswahl = musicFreieAuswahl;
    }

    public boolean isRemoveOriginalAfterConvert()
    {
        return removeOriginalAfterConvert;
    }

    public void setRemoveOriginalAfterConvert(boolean removeOriginalAfterConvert)
    {
        this.removeOriginalAfterConvert = removeOriginalAfterConvert;
    }

    public String getWebport()
    {
        return webport;
    }

    public void setWebport(String webport)
    {
        this.webport = webport;
    }

    public void setRestdauerKorrektur(String restdauerKorrektur)
    {
        if (!"".equals(restdauerKorrektur.trim()))
        {
            this.restdauerKorrektur = restdauerKorrektur;
        }
    }

    public String getRestdauerKorrektur()
    {
        return restdauerKorrektur;
    }
}
