package gui;

import java.util.logging.ConsoleHandler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

import tsStreamRipper.util.logging.ILogEntryObserver;

public class ApplicationLogHandler extends ConsoleHandler
{
    private static final Logger log = Logger.getLogger(ApplicationLogHandler.class.getName());
    
    private ILogEntryObserver myLogObserver = null;

    public ApplicationLogHandler()
    {
        super();
        GuiManagerBean.getInstance().setLoghandler(this);
        setFormatter(new tsStreamRipper.util.logging.LogFormatter());
    }

    @Override
    public void publish(LogRecord record)
    {
        if (myLogObserver != null)
        {
            myLogObserver.publishLogRecord(getFormatter().format(record));
        }
        else
        {
            log.finer("myLogObserver ist noch leer ...");
        }
    }

    public void setMyLogObserver(ILogEntryObserver myLogObserver)
    {
        this.myLogObserver = myLogObserver;
    }

}
