package gui;

import java.util.HashMap;
import java.util.ResourceBundle;

public enum ChannelEntry
{

    FREI(),
    CE_60er_70er,
    CE_80er_90er,
    CE_Country,
    CE_DeutscheCharts,
    CE_Lovesongs,
    CE_RnB_Hiphop,
    CE_RockHymnen;

    private static HashMap<ChannelEntry, String> dispMap = new HashMap<ChannelEntry, String>();
    private static HashMap<ChannelEntry, String> channelIdMap = new HashMap<ChannelEntry, String>();
    
    private static ResourceBundle bundle = ResourceBundle.getBundle("ui_dialog");

    @Override
    public String toString()
    {
        return dispMap.get(this);
    }
    
    public String getChannelPropertiesKey()
    {
        return channelIdMap.get(this);
    }
    
    static
    {
        dispMap.put(FREI, bundle.getString("Verzeichnisse.lblFreieAuswahl.text"));
        dispMap.put(CE_60er_70er, bundle.getString("Verzeichnisse.lbl60er70er.text"));
        dispMap.put(CE_80er_90er, bundle.getString("Verzeichnisse.lbl80er90er.text"));
        dispMap.put(CE_Country, bundle.getString("Verzeichnisse.lblCountry.text"));
        dispMap.put(CE_DeutscheCharts, bundle.getString("Verzeichnisse.lblDeutscheCharts.text"));
        dispMap.put(CE_Lovesongs, bundle.getString("Verzeichnisse.lblLoveSongs.text"));
        dispMap.put(CE_RnB_Hiphop, bundle.getString("Verzeichnisse.lblRnbHiphop.text"));
        dispMap.put(CE_RockHymnen, bundle.getString("Verzeichnisse.lblRockHymnen.text"));
        
        channelIdMap.put(FREI, "keine");
        channelIdMap.put(CE_60er_70er, "60er_70er");
        channelIdMap.put(CE_80er_90er, "80er_90er");
        channelIdMap.put(CE_Country, "country");
        channelIdMap.put(CE_DeutscheCharts, "deutsche_charts");
        channelIdMap.put(CE_Lovesongs, "lovesongs");
        channelIdMap.put(CE_RnB_Hiphop, "rnb_hiphop");
        channelIdMap.put(CE_RockHymnen, "rock_hymnen");
//        60er70er=1:0:2:99:11:85:FFFF0000:0:0:0:
//            80er_90er?1:0:2:9A:11:85:FFFF0000:0:0:0:
//            country=1:0:2:9C:11:85:FFFF0000:0:0:0:
//            deutsche_charts=1:0:2:96:11:85:FFFF0000:0:0:0:
//            lovesongs=1:0:2:98:11:85:FFFF0000:0:0:0:
//            rnb_hiphop=1:0:2:9B:11:85:FFFF0000:0:0:0:
//            rock_hymnen
    }
}
