package gui;

import gui.ApplicationConfigHandler.BoxType;
import gui.ApplicationConfigHandler.Converter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import java.util.logging.Logger;

import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingConstants;
import javax.swing.WindowConstants;

/**
 */
public class Einstellungen extends JDialog
{
    private static final Logger log = Logger.getLogger(Einstellungen.class.getName());

    private MessageDialog dlgMessage = new MessageDialog(this);

    private void readConfig()
    {
        IApplicationConfig config = GuiManagerBean.getInstance().getConfig();
        tfHost.setText(config.getHost());
        tfPort.setText(config.getPort());
        tfWebPort.setText(config.getWebport());
        tfUsername.setText(config.getUsername());
        tfPasswort.setText(config.getPasswort());
        tfTmpDir.setText(config.getTmpDir());
        tfFaacEncoder.setText(config.getFaacPath());
        tfLameEncoder.setText(config.getLamePath());
        tfTmpDir.setText(config.getTmpDir());
        cbOverwrite.setSelected(config.isOverwrite());
        cbSwitchFilename.setSelected(config.isSwitchFilename());
        cbRemoveOrig.setSelected(config.isRemoveOriginalAfterConvert());
        cbVerbose.setSelected(config.isVerbose());
        cbBoxTyp.setSelectedItem(config.getBoxType());
        cbKonvertierung.setSelectedItem(config.getConverter());
        tfRestdauerOffset.setText(config.getRestdauerKorrektur());
    }

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    public Einstellungen()
    {
        initComponents();
        readConfig();
    }

    private void btnSelectTmpDirActionPerformed(ActionEvent e)
    {
        IApplicationConfig config = GuiManagerBean.getInstance().getConfig();
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION)
        {
            File file = fc.getSelectedFile();
            config.setTmpDir(file.getAbsolutePath());
            log.fine("Setze Verzeichnis für temporäre Dateien auf : " + config.getTmpDir());
            readConfig();
        }
    }

    private void btnSelectFaacEncoderActionPerformed(ActionEvent e)
    {
        IApplicationConfig config = GuiManagerBean.getInstance().getConfig();
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION)
        {
            File file = fc.getSelectedFile();
            config.setFaacPath(file.getAbsolutePath());
            log.fine("Setze Pfad des FAAC Encoder auf : " + config.getFaacPath());
            readConfig();
        }
    }

    private void btnSelectLameEncoderActionPerformed(ActionEvent e)
    {
        IApplicationConfig config = GuiManagerBean.getInstance().getConfig();
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION)
        {
            File file = fc.getSelectedFile();
            tfLameEncoder.setText(file.getAbsolutePath());
            config.setLamePath(file.getAbsolutePath());
            log.fine("Setze Pfad des LAME Encoder auf : " + config.getLamePath());
        }
    }

    private boolean validateData()
    {
        // Restdauerkorrektur
        try
        {
            Integer.parseInt(tfRestdauerOffset.getText());
        }
        catch (NumberFormatException e)
        {
            dlgMessage.setErrorText(String.format("Musikende Offset :  '%s' ist keine gültige Zahl.",tfRestdauerOffset.getText()));
            dlgMessage.setVisible(true);
            return false;
        }

        // Konverter
        if (((Converter) cbKonvertierung.getSelectedItem()).equals(Converter.MP3))
        {
            if (tfLameEncoder.getText().trim().equals(""))
            {
                dlgMessage.setErrorText("Bitte geben Sie den vollqualifizierten Pfad auf den Lame Encoder an.");
                dlgMessage.setVisible(true);
                return false;
            }
            else
            {
                File f = new File(tfLameEncoder.getText());
                if (f.isDirectory())
                {
                    dlgMessage.setErrorText("Lame Encoder: Sie haben ein Verzeichnis ausgewählt. Bitte geben Sie eine Programmdatei an.");
                    dlgMessage.setVisible(true);
                    return false;
                }
                if (!f.canExecute())
                {
                    log.warning("Ausgewählter Lame Encoder ist möglicherweise keine Ausführbare Datei und die Konvertierung wird fehlschalgen!");
                }
            }
        }

        if (((Converter) cbKonvertierung.getSelectedItem()).equals(Converter.AAC))
        {
            if (tfFaacEncoder.getText().trim().equals(""))
            {
                dlgMessage.setErrorText("Bitte geben Sie den vollqualifizierten Pfad auf den Faac Encoder an.");
                dlgMessage.setVisible(true);
                return false;
            }
            else
            {
                File f = new File(tfFaacEncoder.getText());
                if (f.isDirectory())
                {
                    dlgMessage.setErrorText("Faac Encoder: Sie haben ein Verzeichnis ausgewählt. Bitte geben Sie eine Programmdatei an.");
                    dlgMessage.setVisible(true);
                    return false;
                }
                if (!f.canExecute())
                {
                    log.warning("Ausgewählter FAAC Encoder ist möglicherweise keine ausführbare Datei und die Konvertierung wird fehlschlagen!");
                }
            }
        }

        // TMP Verzeichnis
        if (!tfTmpDir.getText().trim().equals(""))
        {
            File f = new File(tfTmpDir.getText());
            if (!f.isDirectory())
            {
                dlgMessage.setErrorText("Temp Directory: Bitte wählen Sie ein Verzeichnis aus, oder löschen es. Dann wird das Default-Tmp Verzeichnis verwendet");
                dlgMessage.setVisible(true);
                return false;
            }
        }

        return true;
    }

    private void btnSpeichernActionPerformed(ActionEvent e)
    {
        if (validateData())
        {
            writeProperties();
            GuiManagerBean.getInstance().saveConfig();
            this.dispose();
        }
    }

    private void writeProperties()
    {
        IApplicationConfig config = GuiManagerBean.getInstance().getConfig();
        config.setHost(tfHost.getText());
        config.setPort(tfPort.getText());
        config.setWebport(tfWebPort.getText());
        config.setUsername(tfUsername.getText());
        config.setPasswort(new String(tfPasswort.getPassword()));
        config.setTmpDir(tfTmpDir.getText());
        config.setFaacPath(tfFaacEncoder.getText());
        config.setLamePath(tfLameEncoder.getText());
        config.setTmpDir(tfTmpDir.getText());
        config.setOverwrite(cbOverwrite.isSelected());
        config.setSwitchFilename(cbSwitchFilename.isSelected());
        config.setRemoveOriginalAfterConvert(cbRemoveOrig.isSelected());
        config.setVerbose(cbVerbose.isSelected());
        config.setBoxType((BoxType) cbBoxTyp.getSelectedItem());
        config.setConverter((Converter) cbKonvertierung.getSelectedItem());
        config.setRestdauerKorrektur(tfRestdauerOffset.getText());
    }

    private void btnAbbrechenActionPerformed(ActionEvent e)
    {
        GuiManagerBean.getInstance().resetConfig();
        this.dispose();
    }

    private void initComponents()
    {
        // GEN-BEGIN:initComponents
        panel1 = new JPanel();
        lblHostIp = new JLabel();
        tfHost = new JTextField();
        lblPort = new JLabel();
        tfPort = new JTextField();
        label4 = new JLabel();
        tfUsername = new JTextField();
        label5 = new JLabel();
        tfPasswort = new JPasswordField();
        lblSeperatorDreambox = new JLabel();
        lblSeperatorVerzeichnisse = new JLabel();
        sepDirectory = new JSeparator();
        lblTmpVerzeichnis = new JLabel();
        tfTmpDir = new JTextField();
        btnSelectTmpDir = new JButton();
        lblKonverterprogramme = new JLabel();
        lblKonvertierung = new JLabel();
        cbKonvertierung = new JComboBox();
        lblFaacEncoder = new JLabel();
        tfFaacEncoder = new JTextField();
        btnSelectFaacEncoder = new JButton();
        lblLameEncoder = new JLabel();
        tfLameEncoder = new JTextField();
        btnSelectLameEncoder = new JButton();
        lblKonverterprogramme2 = new JLabel();
        sepOptionen = new JSeparator();
        cbOverwrite = new JCheckBox();
        cbSwitchFilename = new JCheckBox();
        cbVerbose = new JCheckBox();
        lblBoxtyp = new JLabel();
        cbBoxTyp = new JComboBox();
        cbRemoveOrig = new JCheckBox();
        sepKonverter = new JSeparator();
        sepDreambox = new JSeparator();
        lblPort2 = new JLabel();
        tfWebPort = new JTextField();
        lblRestdauer = new JLabel();
        tfRestdauerOffset = new JTextField();
        lblSekunden = new JLabel();
        panelButtons = new JPanel();
        btnSpeichern = new JButton();
        btnAbbrechen = new JButton();

        //======== this ========
        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
        setAlwaysOnTop(true);
        setModal(true);
        setResizable(false);
        Container contentPane = getContentPane();
        contentPane.setLayout(new BorderLayout());

        //======== panel1 ========
        {

            //---- tfHost ----
            tfHost.setBackground(Color.white);

            //---- tfPort ----
            tfPort.setBackground(Color.white);

            //---- btnSelectTmpDir ----
            btnSelectTmpDir.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    btnSelectTmpDirActionPerformed(e);
                }
            });

            //---- btnSelectFaacEncoder ----
            btnSelectFaacEncoder.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    btnSelectFaacEncoderActionPerformed(e);
                }
            });

            //---- btnSelectLameEncoder ----
            btnSelectLameEncoder.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    btnSelectLameEncoderActionPerformed(e);
                }
            });

            //---- tfWebPort ----
            tfWebPort.setBackground(Color.white);

            //---- tfRestdauerOffset ----
            tfRestdauerOffset.setBackground(Color.white);

            GroupLayout panel1Layout = new GroupLayout(panel1);
            panel1.setLayout(panel1Layout);
            panel1Layout.setHorizontalGroup(
                panel1Layout.createParallelGroup()
                    .addGroup(panel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(panel1Layout.createParallelGroup()
                            .addGroup(panel1Layout.createSequentialGroup()
                                .addGap(40, 40, 40)
                                .addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING)
                                    .addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false)
                                        .addGroup(panel1Layout.createSequentialGroup()
                                            .addComponent(lblHostIp, GroupLayout.PREFERRED_SIZE, 120, GroupLayout.PREFERRED_SIZE)
                                            .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                            .addComponent(tfHost, GroupLayout.PREFERRED_SIZE, 200, GroupLayout.PREFERRED_SIZE))
                                        .addGroup(panel1Layout.createSequentialGroup()
                                            .addComponent(label4)
                                            .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                            .addComponent(tfUsername, GroupLayout.PREFERRED_SIZE, 200, GroupLayout.PREFERRED_SIZE)))
                                    .addGroup(panel1Layout.createSequentialGroup()
                                        .addComponent(label5)
                                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(tfPasswort, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)))
                                .addGap(18, 18, 18)
                                .addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING)
                                    .addGroup(panel1Layout.createParallelGroup()
                                        .addGroup(panel1Layout.createSequentialGroup()
                                            .addComponent(lblPort)
                                            .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                            .addComponent(tfPort, GroupLayout.PREFERRED_SIZE, 200, GroupLayout.PREFERRED_SIZE))
                                        .addGroup(GroupLayout.Alignment.TRAILING, panel1Layout.createSequentialGroup()
                                            .addComponent(lblBoxtyp)
                                            .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                            .addComponent(cbBoxTyp, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)))
                                    .addGroup(panel1Layout.createSequentialGroup()
                                        .addComponent(lblPort2, GroupLayout.PREFERRED_SIZE, 125, GroupLayout.PREFERRED_SIZE)
                                        .addGap(6, 6, 6)
                                        .addComponent(tfWebPort, GroupLayout.PREFERRED_SIZE, 200, GroupLayout.PREFERRED_SIZE))))
                            .addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false)
                                .addGroup(GroupLayout.Alignment.LEADING, panel1Layout.createSequentialGroup()
                                    .addGap(43, 43, 43)
                                    .addComponent(lblTmpVerzeichnis, GroupLayout.PREFERRED_SIZE, 125, GroupLayout.PREFERRED_SIZE)
                                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(tfTmpDir)
                                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(btnSelectTmpDir))
                                .addGroup(GroupLayout.Alignment.LEADING, panel1Layout.createSequentialGroup()
                                    .addGap(36, 36, 36)
                                    .addGroup(panel1Layout.createParallelGroup()
                                        .addComponent(cbRemoveOrig)
                                        .addGroup(panel1Layout.createSequentialGroup()
                                            .addGap(8, 8, 8)
                                            .addGroup(panel1Layout.createParallelGroup()
                                                .addGroup(panel1Layout.createSequentialGroup()
                                                    .addComponent(lblLameEncoder, GroupLayout.PREFERRED_SIZE, 125, GroupLayout.PREFERRED_SIZE)
                                                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                                    .addComponent(tfLameEncoder, GroupLayout.PREFERRED_SIZE, 484, GroupLayout.PREFERRED_SIZE)
                                                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                                    .addComponent(btnSelectLameEncoder))
                                                .addGroup(panel1Layout.createSequentialGroup()
                                                    .addComponent(lblFaacEncoder, GroupLayout.PREFERRED_SIZE, 125, GroupLayout.PREFERRED_SIZE)
                                                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                                    .addComponent(tfFaacEncoder, GroupLayout.PREFERRED_SIZE, 484, GroupLayout.PREFERRED_SIZE)
                                                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                                    .addComponent(btnSelectFaacEncoder))
                                                .addGroup(panel1Layout.createSequentialGroup()
                                                    .addComponent(lblKonvertierung, GroupLayout.PREFERRED_SIZE, 125, GroupLayout.PREFERRED_SIZE)
                                                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                                    .addComponent(cbKonvertierung, GroupLayout.PREFERRED_SIZE, 200, GroupLayout.PREFERRED_SIZE)))))))
                            .addComponent(sepKonverter, GroupLayout.PREFERRED_SIZE, 704, GroupLayout.PREFERRED_SIZE)
                            .addGroup(panel1Layout.createSequentialGroup()
                                .addGap(11, 11, 11)
                                .addComponent(lblKonverterprogramme))
                            .addGroup(panel1Layout.createSequentialGroup()
                                .addGap(37, 37, 37)
                                .addGroup(panel1Layout.createParallelGroup()
                                    .addComponent(cbSwitchFilename)
                                    .addComponent(cbOverwrite)
                                    .addComponent(cbVerbose)
                                    .addGroup(panel1Layout.createSequentialGroup()
                                        .addComponent(lblRestdauer, GroupLayout.PREFERRED_SIZE, 148, GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(tfRestdauerOffset, GroupLayout.PREFERRED_SIZE, 80, GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(lblSekunden, GroupLayout.PREFERRED_SIZE, 195, GroupLayout.PREFERRED_SIZE))))
                            .addComponent(sepDirectory, GroupLayout.PREFERRED_SIZE, 704, GroupLayout.PREFERRED_SIZE)
                            .addComponent(sepDreambox, GroupLayout.PREFERRED_SIZE, 773, GroupLayout.PREFERRED_SIZE)
                            .addComponent(sepOptionen, GroupLayout.PREFERRED_SIZE, 719, GroupLayout.PREFERRED_SIZE)
                            .addGroup(panel1Layout.createSequentialGroup()
                                .addGap(10, 10, 10)
                                .addComponent(lblSeperatorVerzeichnisse))
                            .addGroup(panel1Layout.createSequentialGroup()
                                .addGap(11, 11, 11)
                                .addComponent(lblKonverterprogramme2))
                            .addGroup(panel1Layout.createSequentialGroup()
                                .addGap(9, 9, 9)
                                .addComponent(lblSeperatorDreambox)))
                        .addContainerGap())
            );
            panel1Layout.linkSize(SwingConstants.HORIZONTAL, new Component[] {label4, label5, lblBoxtyp, lblFaacEncoder, lblHostIp, lblKonvertierung, lblLameEncoder, lblPort, lblTmpVerzeichnis});
            panel1Layout.linkSize(SwingConstants.HORIZONTAL, new Component[] {cbBoxTyp, cbKonvertierung, tfHost, tfUsername});
            panel1Layout.linkSize(SwingConstants.HORIZONTAL, new Component[] {tfPasswort, tfPort});
            panel1Layout.linkSize(SwingConstants.HORIZONTAL, new Component[] {tfFaacEncoder, tfLameEncoder, tfTmpDir});
            panel1Layout.linkSize(SwingConstants.HORIZONTAL, new Component[] {sepDirectory, sepDreambox, sepKonverter, sepOptionen});
            panel1Layout.setVerticalGroup(
                panel1Layout.createParallelGroup()
                    .addGroup(panel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(lblSeperatorDreambox, GroupLayout.PREFERRED_SIZE, 24, GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(sepDreambox, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(panel1Layout.createParallelGroup()
                            .addGroup(panel1Layout.createSequentialGroup()
                                .addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                                    .addComponent(tfHost, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                                    .addComponent(lblHostIp))
                                .addGap(6, 6, 6)
                                .addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                                    .addComponent(tfUsername, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                                    .addComponent(label4))
                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                                    .addComponent(label5)
                                    .addComponent(tfPasswort, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                .addGap(18, 18, 18)
                                .addComponent(lblSeperatorVerzeichnisse))
                            .addGroup(panel1Layout.createSequentialGroup()
                                .addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                                    .addComponent(tfPort, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                                    .addComponent(lblPort))
                                .addGap(6, 6, 6)
                                .addGroup(panel1Layout.createParallelGroup()
                                    .addGroup(panel1Layout.createSequentialGroup()
                                        .addGap(6, 6, 6)
                                        .addComponent(lblPort2))
                                    .addComponent(tfWebPort, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                                    .addComponent(lblBoxtyp)
                                    .addComponent(cbBoxTyp, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))))
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(sepDirectory, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                            .addComponent(tfTmpDir, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(btnSelectTmpDir)
                            .addComponent(lblTmpVerzeichnis))
                        .addGap(18, 18, 18)
                        .addComponent(lblKonverterprogramme)
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(sepKonverter, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                            .addComponent(cbKonvertierung, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblKonvertierung))
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                            .addComponent(tfFaacEncoder, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(btnSelectFaacEncoder)
                            .addComponent(lblFaacEncoder))
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                            .addComponent(tfLameEncoder, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(btnSelectLameEncoder)
                            .addComponent(lblLameEncoder))
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cbRemoveOrig)
                        .addGap(18, 18, 18)
                        .addComponent(lblKonverterprogramme2)
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(sepOptionen, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                        .addGap(12, 12, 12)
                        .addComponent(cbOverwrite)
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cbSwitchFilename)
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(cbVerbose)
                        .addGap(12, 12, 12)
                        .addGroup(panel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                            .addComponent(lblRestdauer)
                            .addComponent(tfRestdauerOffset, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblSekunden))
                        .addGap(60, 60, 60))
            );
        }
        contentPane.add(panel1, BorderLayout.CENTER);

        //======== panelButtons ========
        {
            panelButtons.setBorder(null);
            panelButtons.setBackground(Color.lightGray);
            panelButtons.setLayout(new FlowLayout());
            ((FlowLayout)panelButtons.getLayout()).setAlignOnBaseline(true);

            //---- btnSpeichern ----
            btnSpeichern.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    btnSpeichernActionPerformed(e);
                }
            });
            panelButtons.add(btnSpeichern);

            //---- btnAbbrechen ----
            btnAbbrechen.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    btnAbbrechenActionPerformed(e);
                }
            });
            panelButtons.add(btnAbbrechen);
        }
        contentPane.add(panelButtons, BorderLayout.SOUTH);
        setSize(800, 705);
        setLocationRelativeTo(null);

        initComponentsI18n();
        // GEN-END:initComponents

        cbBoxTyp.addItem(BoxType.SAT);
        cbBoxTyp.addItem(BoxType.KABEL);

        cbKonvertierung.addItem(Converter.KEINE_KONVERTIERUNG);
        cbKonvertierung.addItem(Converter.MP3);
        cbKonvertierung.addItem(Converter.AAC);
    }

    private void initComponentsI18n()
    {
        // GEN-BEGIN:initI18n
        ResourceBundle bundle = ResourceBundle.getBundle("ui_dialog");
        setTitle(bundle.getString("config.this.title"));
        lblHostIp.setText(bundle.getString("config.lblHostIp.text"));
        tfHost.setToolTipText(bundle.getString("config.tfHost.toolTipText"));
        lblPort.setText(bundle.getString("config.lblPort.text"));
        tfPort.setToolTipText(bundle.getString("config.tfPort.toolTipText"));
        label4.setText(bundle.getString("config.label4.text"));
        tfUsername.setToolTipText(bundle.getString("config.tfUsername.toolTipText"));
        label5.setText(bundle.getString("config.label5.text"));
        tfPasswort.setToolTipText(bundle.getString("config.tfPasswort.toolTipText"));
        lblSeperatorDreambox.setText(bundle.getString("config.lblSeperatorDreambox.text"));
        lblSeperatorVerzeichnisse.setText(bundle.getString("config.lblSeperatorVerzeichnisse.text"));
        lblTmpVerzeichnis.setText(bundle.getString("config.lblTmpVerzeichnis.text"));
        tfTmpDir.setToolTipText(bundle.getString("config.tfTmpDir.toolTipText"));
        btnSelectTmpDir.setText(bundle.getString("config.btnSelectTmpDir.text"));
        btnSelectTmpDir.setToolTipText(bundle.getString("config.btnSelectTmpDir.toolTipText"));
        lblKonverterprogramme.setText(bundle.getString("config.lblKonverterprogramme.text"));
        lblKonvertierung.setText(bundle.getString("config.lblKonvertierung.text"));
        cbKonvertierung.setToolTipText(bundle.getString("config.cbKonvertierung.toolTipText"));
        lblFaacEncoder.setText(bundle.getString("config.lblFaacEncoder.text"));
        tfFaacEncoder.setToolTipText(bundle.getString("config.tfFaacEncoder.toolTipText"));
        btnSelectFaacEncoder.setText(bundle.getString("config.btnSelectFaacEncoder.text"));
        btnSelectFaacEncoder.setToolTipText(bundle.getString("config.btnSelectFaacEncoder.toolTipText"));
        lblLameEncoder.setText(bundle.getString("config.lblLameEncoder.text"));
        tfLameEncoder.setToolTipText(bundle.getString("config.tfLameEncoder.toolTipText"));
        btnSelectLameEncoder.setText(bundle.getString("config.btnSelectLameEncoder.text"));
        btnSelectLameEncoder.setToolTipText(bundle.getString("config.btnSelectLameEncoder.toolTipText"));
        lblKonverterprogramme2.setText(bundle.getString("config.lblKonverterprogramme2.text"));
        cbOverwrite.setText(bundle.getString("config.cbOverwrite.text"));
        cbOverwrite.setToolTipText(bundle.getString("config.cbOverwrite.toolTipText"));
        cbSwitchFilename.setText(bundle.getString("config.cbSwitchFilename.text"));
        cbSwitchFilename.setToolTipText(bundle.getString("config.cbSwitchFilename.toolTipText"));
        cbVerbose.setText(bundle.getString("config.cbVerbose.text"));
        cbVerbose.setToolTipText(bundle.getString("config.cbVerbose.toolTipText"));
        lblBoxtyp.setText(bundle.getString("MainWindow.lblBoxtyp.text"));
        cbRemoveOrig.setText(bundle.getString("MainWindow.cbRemoveOrig.text"));
        cbRemoveOrig.setToolTipText(bundle.getString("MainWindow.cbRemoveOrig.toolTipText"));
        lblPort2.setText(bundle.getString("MainWindow.lblPort2.text"));
        tfWebPort.setToolTipText(bundle.getString("MainWindow.tfWebPort.toolTipText"));
        lblRestdauer.setText(bundle.getString("MainWindow.lblRestdauer.text"));
        lblRestdauer.setToolTipText(bundle.getString("MainWindow.lblRestdauer.toolTipText"));
        tfRestdauerOffset.setToolTipText(bundle.getString("MainWindow.tfRestdauerOffset.toolTipText"));
        lblSekunden.setText(bundle.getString("MainWindow.lblSekunden.text"));
        lblSekunden.setToolTipText(bundle.getString("MainWindow.lblSekunden.toolTipText"));
        btnSpeichern.setText(bundle.getString("config.btnSpeichern.text"));
        btnAbbrechen.setText(bundle.getString("config.btnAbbrechen.text"));
        // GEN-END:initI18n
    }

    // GEN-BEGIN:variables
    private JPanel panel1;
    private JLabel lblHostIp;
    private JTextField tfHost;
    private JLabel lblPort;
    private JTextField tfPort;
    private JLabel label4;
    private JTextField tfUsername;
    private JLabel label5;
    private JPasswordField tfPasswort;
    private JLabel lblSeperatorDreambox;
    private JLabel lblSeperatorVerzeichnisse;
    private JSeparator sepDirectory;
    private JLabel lblTmpVerzeichnis;
    private JTextField tfTmpDir;
    private JButton btnSelectTmpDir;
    private JLabel lblKonverterprogramme;
    private JLabel lblKonvertierung;
    private JComboBox cbKonvertierung;
    private JLabel lblFaacEncoder;
    private JTextField tfFaacEncoder;
    private JButton btnSelectFaacEncoder;
    private JLabel lblLameEncoder;
    private JTextField tfLameEncoder;
    private JButton btnSelectLameEncoder;
    private JLabel lblKonverterprogramme2;
    private JSeparator sepOptionen;
    private JCheckBox cbOverwrite;
    private JCheckBox cbSwitchFilename;
    private JCheckBox cbVerbose;
    private JLabel lblBoxtyp;
    private JComboBox cbBoxTyp;
    private JCheckBox cbRemoveOrig;
    private JSeparator sepKonverter;
    private JSeparator sepDreambox;
    private JLabel lblPort2;
    private JTextField tfWebPort;
    private JLabel lblRestdauer;
    private JTextField tfRestdauerOffset;
    private JLabel lblSekunden;
    private JPanel panelButtons;
    private JButton btnSpeichern;
    private JButton btnAbbrechen;
    // GEN-END:variables
}
