package gui;

import tsStreamRipper.util.logging.ILogEntryObserver;

/**
 * Die Singleton-Implementierung dieser Bean wird teilweise durch den Jar-In-Jar Classloader von Elcipse ausgehebelt.
 */
public class GuiManagerBean implements IGuiManagerBean
{
    private boolean guiRunning = false;

    private boolean streamRunning = true;

    private ApplicationLogHandler loghandler = null;

    private ILogEntryObserver window = null;

    private ApplicationConfigHandler configHandler = new ApplicationConfigHandler();

    private static IGuiManagerBean instance = null;

    public GuiManagerBean()
    {
//        try
//        {
//            throw new Exception();
//        }
//        catch (Exception e)
//        {
//            e.printStackTrace();
//        }
//        
//        dumpClassLoader();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IGuiManagerBean#isStreamRunning()
     */
    public boolean isStreamRunning()
    {
        return streamRunning;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IGuiManagerBean#isGuiRunning()
     */
    public boolean isGuiRunning()
    {
        return guiRunning;
    }

    @SuppressWarnings("unused")
    private void dumpClassLoader()
    {
        int i = 1;
        ClassLoader cl = this.getClass().getClassLoader();
        while (cl != null)
        {
            System.out.println("CL " + i++ + " > " + cl);
            cl = cl.getParent();
        }
        getClass().getClassLoader();
        System.out.println("System CL :" + ClassLoader.getSystemClassLoader());
        System.out.println("---------------------");
    }

    public static IGuiManagerBean getInstance()
    {
        if (instance == null)
        {
            instance = new GuiManagerBean();
        }
        return instance;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IGuiManagerBean#setLoghandler(gui.ApplicationLogHandler)
     */
    public void setLoghandler(ApplicationLogHandler loghandler)
    {
        synchronized (this)
        {
            this.loghandler = loghandler;
            if (window != null)
            {
                loghandler.setMyLogObserver(window);
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IGuiManagerBean#getLoghandler()
     */
    public ApplicationLogHandler getLoghandler()
    {
        return loghandler;
    }

    public void setWindow(ILogEntryObserver window)
    {
        synchronized (this)
        {
            guiRunning = true;
            this.window = window;
            if (loghandler != null)
            {
                loghandler.setMyLogObserver(window);
            }
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IGuiManagerBean#getConfig()
     */
    public IApplicationConfig getConfig()
    {
        return configHandler.getConfig();
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IGuiManagerBean#setConfig(gui.ApplicationConfigHandler)
     */
    public void setConfig(ApplicationConfigHandler configHandler)
    {
        this.configHandler = configHandler;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IGuiManagerBean#saveConfig()
     */
    public void saveConfig()
    {
        if (configHandler != null)
        {
            configHandler.saveConfig();
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IGuiManagerBean#resetConfig()
     */
    public void resetConfig()
    {
        if (configHandler != null)
        {
            configHandler.saveConfig();
        }
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IGuiManagerBean#setGuiRunning(boolean)
     */
    public void setGuiRunning(boolean guiRunning)
    {
        this.guiRunning = guiRunning;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gui.IGuiManagerBean#setStreamRunning(boolean)
     */
    public void setStreamRunning(boolean streamRunning)
    {
        this.streamRunning = streamRunning;
    }

    // /*
    // * (non-Javadoc)
    // *
    // * @see gui.IGuiManagerBean#showMainWindow()
    // */
    // public MainWindow showMainWindow()
    // {
    // MainWindow mw = new MainWindow();
    // mw.setVisible(true);
    // setWindow(mw);
    // return mw;
    // }
}
