package gui;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.*;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextArea;

/**
 */
public class MessageDialog extends JDialog
{
    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    public MessageDialog(Frame owner)
    {
        super(owner);
        initComponents();
    }

    public MessageDialog(Dialog owner)
    {
        super(owner);
        initComponents();
    }

    public void setErrorText(String text)
    {
        taMessage.setText(text);
    }

    private void btnOkActionPerformed(ActionEvent e)
    {
        this.dispose();
    }

    private void initComponents()
    {
        // GEN-BEGIN:initComponents
        btnOk = new JButton();
        taMessage = new JTextArea();
        label1 = new JLabel();
        label2 = new JLabel();
        label3 = new JLabel();

        //======== this ========
        setResizable(false);
        setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        Container contentPane = getContentPane();
        contentPane.setLayout(new BorderLayout());

        //---- btnOk ----
        btnOk.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                btnOkActionPerformed(e);
            }
        });
        contentPane.add(btnOk, BorderLayout.SOUTH);

        //---- taMessage ----
        taMessage.setWrapStyleWord(true);
        taMessage.setLineWrap(true);
        contentPane.add(taMessage, BorderLayout.CENTER);
        contentPane.add(label1, BorderLayout.NORTH);
        contentPane.add(label2, BorderLayout.WEST);
        contentPane.add(label3, BorderLayout.EAST);
        setSize(590, 150);
        setLocationRelativeTo(null);

        initComponentsI18n();
        // GEN-END:initComponents
        
        taMessage.setEditable(false);  
        taMessage.setCursor(null);  
        taMessage.setOpaque(false);  
        taMessage.setFocusable(false); 
        taMessage.setWrapStyleWord(true);
        taMessage.setLineWrap(true);
    }

    private void initComponentsI18n()
    {
        // GEN-BEGIN:initI18n
        ResourceBundle bundle = ResourceBundle.getBundle("ui_dialog");
        setTitle(bundle.getString("MessageDialog.this.title"));
        btnOk.setText(bundle.getString("MessageDialog.btnOk.text"));
        label1.setText(bundle.getString("MessageDialog.label1.text"));
        label2.setText(bundle.getString("MessageDialog.label2.text"));
        label3.setText(bundle.getString("MessageDialog.label3.text"));
        //GEN-END:initI18n
    }

    // GEN-BEGIN:variables
    private JButton btnOk;
    private JTextArea taMessage;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    // GEN-END:variables
}
