package gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;

import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingConstants;

/**
 */
public class Verzeichnisse extends JDialog
{
    /**
     * 
     */
    private static final long serialVersionUID = 1L;


    public Verzeichnisse(Frame owner)
    {
        super(owner);
        initComponents();
        readConfig();
    }

    public Verzeichnisse(Dialog owner)
    {
        super(owner);
        initComponents();
        readConfig();
    }

    private void writeConfig()
    {
        IApplicationConfig config = GuiManagerBean.getInstance().getConfig();
        config.setMusic60er70er(tf60er70er.getText());
        config.setMusic80er90er(tf80er90er.getText());
        config.setMusicCountry(tfCountry.getText());
        config.setMusicDeutscheCharts(tfDeutscheCharts.getText());
        config.setMusicLovesongs(tfLovesongs.getText());
        config.setMusicRockHymnen(tfRockHymnen.getText());
        config.setMusicRnbHiphop(tfRnbHiphop.getText());
        config.setMusicFreieAuswahl(tfFreieAuswahl.getText());

        GuiManagerBean.getInstance().saveConfig();
    }

    private void readConfig()
    {
        IApplicationConfig config = GuiManagerBean.getInstance().getConfig();
        tf60er70er.setText(config.getMusic60er70er());
        tf80er90er.setText(config.getMusic80er90er());
        tfCountry.setText(config.getMusicCountry());
        tfDeutscheCharts.setText(config.getMusicDeutscheCharts());
        tfLovesongs.setText(config.getMusicLovesongs());
        tfRockHymnen.setText(config.getMusicRockHymnen());
        tfRnbHiphop.setText(config.getMusicRnbHiphop());
        tfFreieAuswahl.setText(config.getMusicFreieAuswahl());
    }

    private void btn80er90erActionPerformed(ActionEvent e)
    {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION)
        {
            File file = fc.getSelectedFile();
            tf80er90er.setText(file.getAbsolutePath());
        }
    }

    private void btnCountryActionPerformed(ActionEvent e)
    {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION)
        {
            File file = fc.getSelectedFile();
            tfCountry.setText(file.getAbsolutePath());
        }
    }

    private void btnDeutscheChartsActionPerformed(ActionEvent e)
    {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION)
        {
            File file = fc.getSelectedFile();
            tfDeutscheCharts.setText(file.getAbsolutePath());
        }
    }

    private void btnLovesongsActionPerformed(ActionEvent e)
    {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION)
        {
            File file = fc.getSelectedFile();
            tfLovesongs.setText(file.getAbsolutePath());
        }

    }

    private void btnRnbHiphopActionPerformed(ActionEvent e)
    {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION)
        {
            File file = fc.getSelectedFile();
            tfRnbHiphop.setText(file.getAbsolutePath());
        }

    }

    private void btnRockHymnenActionPerformed(ActionEvent e)
    {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION)
        {
            File file = fc.getSelectedFile();
            tfRockHymnen.setText(file.getAbsolutePath());
        }

    }

    private void btnSpeichernActionPerformed(ActionEvent e)
    {
        writeConfig();
        this.dispose();
    }

    private void btnAbbrechenActionPerformed(ActionEvent e)
    {
        GuiManagerBean.getInstance().resetConfig();
        this.dispose();
    }

    private void buttonbtn60er70er2ActionPerformed(ActionEvent e)
    {
        IApplicationConfig config = GuiManagerBean.getInstance().getConfig();
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION)
        {
            File file = fc.getSelectedFile();
            config.setMusic60er70er(file.getAbsolutePath());
            readConfig();
        }
    }

    private void btnFreieAuswahlActionPerformed(ActionEvent e)
    {
        IApplicationConfig config = GuiManagerBean.getInstance().getConfig();
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION)
        {
            File file = fc.getSelectedFile();
            config.setMusicFreieAuswahl(file.getAbsolutePath());
            readConfig();
        }
    }

    private void initComponents()
    {
        // GEN-BEGIN:initComponents
        panel2 = new JPanel();
        lblSeperatorVerzeichnisse = new JLabel();
        separator2 = new JSeparator();
        lbl60er70er = new JLabel();
        tf60er70er = new JTextField();
        btn60er70er = new JButton();
        lbl80er90er = new JLabel();
        tf80er90er = new JTextField();
        btn80er90er = new JButton();
        lblCountry = new JLabel();
        tfCountry = new JTextField();
        btnCountry = new JButton();
        lblDeutscheCharts = new JLabel();
        tfDeutscheCharts = new JTextField();
        btnDeutscheCharts = new JButton();
        lblLoveSongs = new JLabel();
        tfLovesongs = new JTextField();
        btnLovesongs = new JButton();
        lblRnbHiphop = new JLabel();
        tfRnbHiphop = new JTextField();
        btnRnbHiphop = new JButton();
        lblRockHymnen = new JLabel();
        tfRockHymnen = new JTextField();
        btnRockHymnen = new JButton();
        lblFreieAuswahl = new JLabel();
        tfFreieAuswahl = new JTextField();
        btnFreieAuswahl = new JButton();
        panel1 = new JPanel();
        btnSpeichern = new JButton();
        btnAbbrechen = new JButton();

        //======== this ========
        setResizable(false);
        setModal(true);
        Container contentPane = getContentPane();
        contentPane.setLayout(new BorderLayout());

        //======== panel2 ========
        {

            //---- tf60er70er ----
            tf60er70er.setBackground(Color.white);

            //---- btn60er70er ----
            btn60er70er.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    buttonbtn60er70er2ActionPerformed(e);
                }
            });

            //---- tf80er90er ----
            tf80er90er.setBackground(Color.white);

            //---- btn80er90er ----
            btn80er90er.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    btn80er90erActionPerformed(e);
                }
            });

            //---- tfCountry ----
            tfCountry.setBackground(Color.white);

            //---- btnCountry ----
            btnCountry.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    btnCountryActionPerformed(e);
                }
            });

            //---- tfDeutscheCharts ----
            tfDeutscheCharts.setBackground(Color.white);

            //---- btnDeutscheCharts ----
            btnDeutscheCharts.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    btnDeutscheChartsActionPerformed(e);
                }
            });

            //---- tfLovesongs ----
            tfLovesongs.setBackground(Color.white);

            //---- btnLovesongs ----
            btnLovesongs.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    btnLovesongsActionPerformed(e);
                }
            });

            //---- tfRnbHiphop ----
            tfRnbHiphop.setBackground(Color.white);

            //---- btnRnbHiphop ----
            btnRnbHiphop.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    btnRnbHiphopActionPerformed(e);
                }
            });

            //---- tfRockHymnen ----
            tfRockHymnen.setBackground(Color.white);

            //---- btnRockHymnen ----
            btnRockHymnen.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    btnRockHymnenActionPerformed(e);
                }
            });

            //---- tfFreieAuswahl ----
            tfFreieAuswahl.setBackground(Color.white);

            //---- btnFreieAuswahl ----
            btnFreieAuswahl.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    btnFreieAuswahlActionPerformed(e);
                }
            });

            GroupLayout panel2Layout = new GroupLayout(panel2);
            panel2.setLayout(panel2Layout);
            panel2Layout.setHorizontalGroup(
                panel2Layout.createParallelGroup()
                    .addGroup(panel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(panel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false)
                            .addComponent(separator2, GroupLayout.Alignment.LEADING)
                            .addGroup(GroupLayout.Alignment.LEADING, panel2Layout.createSequentialGroup()
                                .addGap(33, 33, 33)
                                .addGroup(panel2Layout.createParallelGroup()
                                    .addGroup(panel2Layout.createSequentialGroup()
                                        .addComponent(lbl60er70er, GroupLayout.PREFERRED_SIZE, 125, GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(tf60er70er, GroupLayout.PREFERRED_SIZE, 484, GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(btn60er70er))
                                    .addGroup(GroupLayout.Alignment.TRAILING, panel2Layout.createParallelGroup()
                                        .addGroup(panel2Layout.createSequentialGroup()
                                            .addComponent(lbl80er90er, GroupLayout.PREFERRED_SIZE, 125, GroupLayout.PREFERRED_SIZE)
                                            .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                            .addComponent(tf80er90er, GroupLayout.PREFERRED_SIZE, 484, GroupLayout.PREFERRED_SIZE)
                                            .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                            .addComponent(btn80er90er))
                                        .addGroup(panel2Layout.createSequentialGroup()
                                            .addComponent(lblCountry, GroupLayout.PREFERRED_SIZE, 125, GroupLayout.PREFERRED_SIZE)
                                            .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                            .addComponent(tfCountry, GroupLayout.PREFERRED_SIZE, 484, GroupLayout.PREFERRED_SIZE)
                                            .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                            .addComponent(btnCountry))
                                        .addGroup(GroupLayout.Alignment.TRAILING, panel2Layout.createParallelGroup()
                                            .addGroup(panel2Layout.createSequentialGroup()
                                                .addComponent(lblDeutscheCharts, GroupLayout.PREFERRED_SIZE, 125, GroupLayout.PREFERRED_SIZE)
                                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                                .addComponent(tfDeutscheCharts, GroupLayout.PREFERRED_SIZE, 484, GroupLayout.PREFERRED_SIZE)
                                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                                .addComponent(btnDeutscheCharts))
                                            .addGroup(panel2Layout.createSequentialGroup()
                                                .addComponent(lblLoveSongs, GroupLayout.PREFERRED_SIZE, 125, GroupLayout.PREFERRED_SIZE)
                                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                                .addComponent(tfLovesongs, GroupLayout.PREFERRED_SIZE, 484, GroupLayout.PREFERRED_SIZE)
                                                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                                .addComponent(btnLovesongs))
                                            .addGroup(GroupLayout.Alignment.TRAILING, panel2Layout.createParallelGroup()
                                                .addGroup(panel2Layout.createSequentialGroup()
                                                    .addComponent(lblRnbHiphop, GroupLayout.PREFERRED_SIZE, 125, GroupLayout.PREFERRED_SIZE)
                                                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                                    .addComponent(tfRnbHiphop, GroupLayout.PREFERRED_SIZE, 484, GroupLayout.PREFERRED_SIZE)
                                                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                                    .addComponent(btnRnbHiphop))
                                                .addGroup(panel2Layout.createSequentialGroup()
                                                    .addComponent(lblRockHymnen, GroupLayout.PREFERRED_SIZE, 125, GroupLayout.PREFERRED_SIZE)
                                                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                                    .addComponent(tfRockHymnen, GroupLayout.PREFERRED_SIZE, 484, GroupLayout.PREFERRED_SIZE)
                                                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                                    .addComponent(btnRockHymnen))
                                                .addGroup(GroupLayout.Alignment.TRAILING, panel2Layout.createSequentialGroup()
                                                    .addComponent(lblFreieAuswahl, GroupLayout.PREFERRED_SIZE, 125, GroupLayout.PREFERRED_SIZE)
                                                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                                    .addComponent(tfFreieAuswahl, GroupLayout.PREFERRED_SIZE, 484, GroupLayout.PREFERRED_SIZE)
                                                    .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                                                    .addComponent(btnFreieAuswahl)))))))
                            .addComponent(lblSeperatorVerzeichnisse, GroupLayout.Alignment.LEADING))
                        .addContainerGap())
            );
            panel2Layout.linkSize(SwingConstants.HORIZONTAL, new Component[] {tf60er70er, tf80er90er, tfCountry, tfDeutscheCharts, tfLovesongs, tfRnbHiphop, tfRockHymnen});
            panel2Layout.linkSize(SwingConstants.HORIZONTAL, new Component[] {lbl60er70er, lbl80er90er, lblCountry, lblDeutscheCharts, lblLoveSongs, lblRnbHiphop, lblRockHymnen});
            panel2Layout.linkSize(SwingConstants.HORIZONTAL, new Component[] {btn60er70er, btn80er90er, btnCountry, btnDeutscheCharts, btnLovesongs, btnRnbHiphop, btnRockHymnen});
            panel2Layout.setVerticalGroup(
                panel2Layout.createParallelGroup()
                    .addGroup(panel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(lblSeperatorVerzeichnisse)
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(separator2, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(panel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                            .addComponent(tf60er70er, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(btn60er70er)
                            .addComponent(lbl60er70er))
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(panel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                            .addComponent(tf80er90er, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(btn80er90er)
                            .addComponent(lbl80er90er))
                        .addGap(7, 7, 7)
                        .addGroup(panel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                            .addComponent(tfCountry, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(btnCountry)
                            .addComponent(lblCountry))
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(panel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                            .addComponent(tfDeutscheCharts, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(btnDeutscheCharts)
                            .addComponent(lblDeutscheCharts))
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(panel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                            .addComponent(tfLovesongs, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(btnLovesongs)
                            .addComponent(lblLoveSongs))
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(panel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                            .addComponent(tfRnbHiphop, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(btnRnbHiphop)
                            .addComponent(lblRnbHiphop))
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(panel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                            .addComponent(tfRockHymnen, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                            .addComponent(lblRockHymnen)
                            .addComponent(btnRockHymnen))
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(panel2Layout.createParallelGroup()
                            .addGroup(panel2Layout.createSequentialGroup()
                                .addGap(6, 6, 6)
                                .addComponent(lblFreieAuswahl))
                            .addGroup(panel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                                .addComponent(btnFreieAuswahl)
                                .addComponent(tfFreieAuswahl, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)))
                        .addContainerGap())
            );
        }
        contentPane.add(panel2, BorderLayout.CENTER);

        //======== panel1 ========
        {
            panel1.setBorder(null);
            panel1.setBackground(Color.lightGray);
            panel1.setLayout(new FlowLayout());
            ((FlowLayout)panel1.getLayout()).setAlignOnBaseline(true);

            //---- btnSpeichern ----
            btnSpeichern.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    btnSpeichernActionPerformed(e);
                }
            });
            panel1.add(btnSpeichern);

            //---- btnAbbrechen ----
            btnAbbrechen.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    btnAbbrechenActionPerformed(e);
                }
            });
            panel1.add(btnAbbrechen);
        }
        contentPane.add(panel1, BorderLayout.SOUTH);
        setSize(745, 415);
        setLocationRelativeTo(null);

        initComponentsI18n();
        // GEN-END:initComponents
    }

    private void initComponentsI18n()
    {
        // GEN-BEGIN:initI18n
        ResourceBundle bundle = ResourceBundle.getBundle("ui_dialog");
        setTitle(bundle.getString("Verzeichnisse.this.title"));
        lblSeperatorVerzeichnisse.setText(bundle.getString("Verzeichnisse.lblSeperatorVerzeichnisse.text"));
        lbl60er70er.setText(bundle.getString("Verzeichnisse.lbl60er70er.text"));
        tf60er70er.setToolTipText(bundle.getString("Verzeichnisse.tf60er70er.toolTipText"));
        btn60er70er.setText(bundle.getString("Verzeichnisse.btn60er70er.text"));
        lbl80er90er.setText(bundle.getString("Verzeichnisse.lbl80er90er.text"));
        tf80er90er.setToolTipText(bundle.getString("Verzeichnisse.tf80er90er.toolTipText"));
        btn80er90er.setText(bundle.getString("Verzeichnisse.btn80er90er.text"));
        lblCountry.setText(bundle.getString("Verzeichnisse.lblCountry.text"));
        tfCountry.setToolTipText(bundle.getString("Verzeichnisse.tfCountry.toolTipText"));
        btnCountry.setText(bundle.getString("Verzeichnisse.btnCountry.text"));
        lblDeutscheCharts.setText(bundle.getString("Verzeichnisse.lblDeutscheCharts.text"));
        tfDeutscheCharts.setToolTipText(bundle.getString("Verzeichnisse.tfDeutscheCharts.toolTipText"));
        btnDeutscheCharts.setText(bundle.getString("Verzeichnisse.btnDeutscheCharts.text"));
        lblLoveSongs.setText(bundle.getString("Verzeichnisse.lblLoveSongs.text"));
        tfLovesongs.setToolTipText(bundle.getString("Verzeichnisse.tfLovesongs.toolTipText"));
        btnLovesongs.setText(bundle.getString("Verzeichnisse.btnLovesongs.text"));
        lblRnbHiphop.setText(bundle.getString("Verzeichnisse.lblRnbHiphop.text"));
        tfRnbHiphop.setToolTipText(bundle.getString("Verzeichnisse.tfRnbHiphop.toolTipText"));
        btnRnbHiphop.setText(bundle.getString("Verzeichnisse.btnRnbHiphop.text"));
        lblRockHymnen.setText(bundle.getString("Verzeichnisse.lblRockHymnen.text"));
        tfRockHymnen.setToolTipText(bundle.getString("Verzeichnisse.tfRockHymnen.toolTipText"));
        btnRockHymnen.setText(bundle.getString("Verzeichnisse.btnRockHymnen.text"));
        lblFreieAuswahl.setText(bundle.getString("Verzeichnisse.lblFreieAuswahl.text"));
        tfFreieAuswahl.setToolTipText(bundle.getString("Verzeichnisse.tfFreieAuswahl.toolTipText"));
        btnFreieAuswahl.setText(bundle.getString("Verzeichnisse.btnFreieAuswahl.text"));
        btnSpeichern.setText(bundle.getString("Verzeichnisse.btnSpeichern.text"));
        btnAbbrechen.setText(bundle.getString("Verzeichnisse.btnAbbrechen.text"));
        // GEN-END:initI18n
    }

    // GEN-BEGIN:variables
    private JPanel panel2;
    private JLabel lblSeperatorVerzeichnisse;
    private JSeparator separator2;
    private JLabel lbl60er70er;
    private JTextField tf60er70er;
    private JButton btn60er70er;
    private JLabel lbl80er90er;
    private JTextField tf80er90er;
    private JButton btn80er90er;
    private JLabel lblCountry;
    private JTextField tfCountry;
    private JButton btnCountry;
    private JLabel lblDeutscheCharts;
    private JTextField tfDeutscheCharts;
    private JButton btnDeutscheCharts;
    private JLabel lblLoveSongs;
    private JTextField tfLovesongs;
    private JButton btnLovesongs;
    private JLabel lblRnbHiphop;
    private JTextField tfRnbHiphop;
    private JButton btnRnbHiphop;
    private JLabel lblRockHymnen;
    private JTextField tfRockHymnen;
    private JButton btnRockHymnen;
    private JLabel lblFreieAuswahl;
    private JTextField tfFreieAuswahl;
    private JButton btnFreieAuswahl;
    private JPanel panel1;
    private JButton btnSpeichern;
    private JButton btnAbbrechen;
    // GEN-END:variables
}
