package mpeg2demux;

/**
 * User: Andreas Rosenberg
 * Date: 01.03.2004
 * Time: 22:31:29
 * A generic class to handle extension packages. The high nibble in the first
 * byte after the start code identifies the type of the extension packet.
 */
public class MPEG2Extension extends MPEG2Packet implements MPEG2PacketInterface {
    public int startCodeIdentifier() {
        return ((255&data[0]) >> 4);
    }

    public String name() {
        switch (this.startCodeIdentifier()){
            case MPEG2Parser.MPEG2ESequenceExtensionID:
                return "SequenceExtension";
            case MPEG2Parser.MPEG2ESequenceDisplayExtensionID:
                return "SequenceDisplayExtension";
            case MPEG2Parser.MPEG2EQuantMatrixExtensionID:
                return "QuantMatrixExtension";
            case MPEG2Parser.MPEG2ECopyrightExtensionID:
                return "CopyrightExtension";
            case MPEG2Parser.MPEG2ESequenceScalableExtensionID:
                return "SequenceScalableExtension";
            case MPEG2Parser.MPEG2EPictureDisplayExtensionID:
                return "PictureDisplayExtension";
            case MPEG2Parser.MPEG2EPictureCodingExtensionID:
                return "PictureCodingExtension";
            case MPEG2Parser.MPEG2EPictureSpatialScalableExtensionID:
                return "PictureSpatialScalableExtension";
            case MPEG2Parser.MPEG2EPictureTemporalScalableExtensionID:
                return "PictureTemporalScalableExtension";
        }
        return "Reserved extension code!";
    }
}
