package mpeg2demux;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * User: Andreas Rosenberg
 * Date: 14.09.2003
 * Time: 11:14:47
 * This is a (mostly) abstract class for an MPEG-Packet.
 */

public class MPEG2Packet implements MPEG2PacketInterface {

    public static final int MPEG2HeadSize=4;

    protected long filePos;
    protected byte header[] = new byte[3];
    protected int type=0;
    protected byte data[];
    protected int size=0; /* this size is only the size of the data member */

    public long getFilePos() {
        return filePos;
    }

    public void setFilePos(long filePos) {
        this.filePos = filePos;
    }

    public byte[] getHeader() {
        return header;
    }

    public void setHeader(byte[] header) {
        this.header = header;
    }

    public int type() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public byte[] getData() {
        return data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setSize(int iSize) {
        this.size = iSize;
    }

    public void readPacketWithSize(InputStream in,int size) throws java.io.IOException {
        in.read(data,0,size);
    }

    public void readPacket(InputStream in,MPEG2Parser parser) throws java.io.IOException {
    }

    public void writePacket(OutputStream out) throws java.io.IOException {
        out.write(0);
        out.write(0);
        out.write(1);
        out.write(this.type);
        out.write(this.data,0,this.size);
    }

    public int size() { /* if size returns 0 this packet has not been filled with data */
        return this.size;
    }
    public String name() {
        return "MPEG2-Packet";
    }
    public String info() {
        return "MPEG2-Packet";
    }

    public String toString(){
        return this.name();
    }
    public int sizePacketHeader(){
        return 0;
    }
    public long getPTS(){
        return 0;
    }
    public boolean isMetaStreamPacket(){
        return false;
    }
    public boolean isStructurePacket(){
        return true;
    }
    public boolean isVideoPacket(){
        return false;
    }
    public boolean isAudioPacket(){
        return false;
    }
    public boolean hasPTS(){
        return false;
    }

    public String MpegTimeStampToString(long ts) {
        long h,min,sec,r=324000000,r1=5400000;
        h = ts / r;
        ts = ts % r;
        min = ts / r1;
        ts = ts % r1;
        sec = ts / 90000;
        ts = ts % 90000;
        return Long.toString(h)+":"+Long.toString(min)+"."+Long.toString(sec)+"."+Long.toString(ts);
    }
    /* do nothing for generic packages */
    public boolean parseEncapsulatedData(MPEG2PacketStreamListener listener, MPEG2Addable collector){
        return true;
    }
}
