package mpeg2demux;

import java.io.InputStream;
import java.io.OutputStream;

/**
 * User: Andreas Rosenberg
 * Date: 14.09.2003
 * Time: 22:44:17
 * This is an interface representing the needed methods being used by this framework.
 */
public interface MPEG2PacketInterface {
    public int     type();
    public void    setType(int type);
    public boolean isMetaStreamPacket();
    public boolean isStructurePacket();
    public boolean isVideoPacket();
    public boolean isAudioPacket();
    public boolean hasPTS();
    public int     size();
    public void    setSize(int iSize);
    public int     sizePacketHeader();
    public long    getFilePos();
    public byte[]  getData();
    public void    setData(byte[] data);
    public long    getPTS();
    public String  name();
    public String  info();
    public void    setFilePos(long pos);
    public boolean parseEncapsulatedData(MPEG2PacketStreamListener listener, MPEG2Addable collector);
    public void    readPacket(InputStream in,MPEG2Parser parser) throws java.io.IOException;
    public void    readPacketWithSize(InputStream in,int size) throws java.io.IOException;
    public void    writePacket(OutputStream out) throws java.io.IOException;
}
