package mpeg2demux;

import java.io.InputStream;

/**
 * User: Andreas Rosenberg
 * Date: 01.03.2004
 * Time: 22:32:20
 * A Picture Header precedes each frame and determines the type of the frame.
 */
public class MPEG2PictureHeader extends MPEG2Packet implements MPEG2PacketInterface{

    public String name() {
        String name;
        name = "MPEG2PictureHeader";
        return name;
    }
    public int getPictureType() {
        return (63&data[1]) >> 3;
    }

    public String info() {
        String name;
        int picture_coding_type;
        name = "MPEG2PictureHeader";
        if (size > 2) {
            picture_coding_type = (63&data[1]) >> 3;
            switch(picture_coding_type) {
                case 1:  /* Intro coded frame - I frame */
                    name = name + " I-Frame";
                    break;
                case 2:  /* predictive coded frame - P frame */
                    name = name + " P-Frame";
                    break;
                case 3:  /* bidirectional coded frame - B frame */
                    name = name + " B-Frame";
                    break;
                default: /* all other picture type are forbidden, reserved or should not be used */
                    break;
            }
        }
        return name;
    }

    public void readPacket(InputStream in, MPEG2Parser parser) throws java.io.IOException {
        byte tmp[] = new byte[2];
        int psize,picture_coding_type;

        type = MPEG2Parser.MPEG2PictureHeader;
        in.read(tmp,0,2);
        psize = 4;
        picture_coding_type = (63&tmp[1]) >> 3;
        switch(picture_coding_type) {
            case 1:  /* Intro coded frame - I frame */
                break;
            case 2:  /* predictive coded frame - P frame */
                psize = 5;
                break;
            case 3:  /* bidirectional coded frame - B frame */
                psize = 5;
                break;
            default: /* all other picture type are forbidden, reserved or should not be used */
                break;
        }
        data = new byte[psize];
        data[0] = tmp[0];
        data[1] = tmp[1];
        in.read(data,2,psize-2);
        size = psize;
        /* ignoring the extra information picture flag for now */
    }
}
