package mpeg2demux;

import java.io.InputStream;

/**
 * User: Andreas Rosenberg
 * Date: 14.09.2003
 * Time: 15:24:15
 */
public class MPEG2ProgramStreamSystemHeader extends MPEG2Packet implements MPEG2PacketInterface{

    public void readPacket(InputStream in, MPEG2Parser parser) throws java.io.IOException {
        byte tmp[] = new byte[2];
        int psize;

        type = MPEG2Parser.MPEG2ProgramStreamSystemHeader;
        tmp = new byte[2];
        in.read(tmp,0,2);
        psize = ((255&tmp[0])<<8) + (255&tmp[1]);
        data = new byte [psize+2];
        data[0] = tmp[0];
        data[1] = tmp[1];
        in.read(data,2,psize);
        size = 2+psize;
    }

    public String name() {
        return "MPEG2ProgramStreamSystemHeader";
    }
}
