package mpeg2demux;
import java.io.InputStream;
import java.io.StringWriter;

/**
 * User: Andreas Rosenberg
 * Date: 14.09.2003
 * Time: 11:57:53
 */
public class MPEG2SequenceHeader extends MPEG2Packet implements MPEG2PacketInterface{

    public void readPacket(InputStream in,MPEG2Parser parser) throws java.io.IOException {
        byte tmp[] = new byte[8];
        byte tmp2[] = new byte[64];
        byte flags;
        int offset;

        type = MPEG2Parser.MPEG2SequenceHeader;

        in.read(tmp,0,8);
        size = 8;
        flags = (byte)(3&tmp[7]);
        if ((0x02 & flags)>0) {   /* load intra Q matrix */
            in.read(tmp2,0,64);
            size += 64;
            flags |= (1&tmp2[63]);
        }
        if ((0x01 & flags)>0) {   /* load non intra Q matrix */
            size += 64;
        }

        data = new byte[size];
        System.arraycopy(tmp,0,data,0,8);
        offset = 8;
        if ((0x02&flags)>0){
            System.arraycopy(tmp2,0,data,offset,64);
            offset +=64;
        }
        if ((0x01&flags)>0)
            in.read(data,offset,64);
    }

    public String name() {
        return "MPEG2 SequenceHeader";
    }
    public String info() {
        int i,flags,width,height,aspectRatio,frameRate,bitrate,vbvBufferSize;
        String aspectRatios[]={"inv!","1:1","3:4","9:16","1:2,21"};
        String frameRates[]={"inv!","23,976","24","25","29,97","30","50","59,94","60"};
        StringWriter writer = new StringWriter();

        writer.write("MPEG2 SequenceHeader:\n");
        i = 0;
        width = (255&data[i]) + (240&data[i+1])<<4;
        height = (15&data[i+1])<<8 +(240&data[i+2]);
        writer.write("Resolution: "+width+"x"+height+" ");
        aspectRatio = (240&data[i+3])>>>4;
        writer.write("AspectRatio: "+aspectRatios[aspectRatio]+" ");
        frameRate = (15&data[i+3]);
        writer.write("Frame rate: "+frameRates[frameRate]+"\n");
        bitrate = (255&data[i+4]) | (255&data[i+5])<<8 | (192&data[i+6])<<10;
        writer.write("Bitrate: "+bitrate*400+"Bits/s ");
        vbvBufferSize = (31&data[i+6])+(247&data[i+7])<<2;
        writer.write("VBV-Buffer-Size: "+vbvBufferSize+"\n");

        return writer.toString();
    }

}
